/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** cubic.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "math.h"
#include "cubic.h"

cubic::cubic(base *p,char *n ):csgobj(p,n)
{
int i;
	numtype = NUM_CUBIC;
	count=0;
	for (i=0;i<19;i++) {koeff[i]=0;}
	if (parent) addToParent(parent);
}

cubic::~cubic()
{
}

int cubic::addToParent(base *p) 
{ 
	if (!p) return -2; 
	return p->addChild(this); 
} 
 
void	cubic::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("cubic: %s\n", name); 
} 

int	cubic::addKoeff(double k)
{
	if (count==19) return 0;
	koeff[count++]=k;

	return 0;
}

int	cubic::reset()
{
	int i;

	for(i = 0;i < 19;i++)
	{
		koeff[i]=0;
	}
	count=0;

	return 0;
}

int	cubic::exportPOV(FILE *fp,int tab,int tabsize,int anim)
{
	int i;

	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = cubic\n");
	printTab(fp,tab);
	fprintf(fp,"cubic { < ");
	for (i=0;i<19;i++)
	{
		fprintf(fp," %f, ",koeff[i]);
	}
	fprintf(fp,"%f > \n",koeff[count]);

	dim::exportPOV(fp,tab,tabsize,anim);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");

	return 0;
}

int	cubic::save(FILE *fp)
{
	int i;

	if (!fp) return -1;

	setFile(fp);

	writeChunk("CUBI");
	SN(name);

	saveFlags(fp);

	for(i = 0;i < 19;i++)
	{
		SD(koeff[i]);
	}

	anim::save(fp);
	dim::save(fp);

	writeChunkLen();

	return 0;
}

int	cubic::load(FILE *fp,int l)
{
	int i,pos = ftell(fp);

	loadFlags(fp,l);

	for(i = 0;i < 19;i++)
	{
		koeff[i] = readDouble(fp);
	}

	anim::load(fp,l - (ftell(fp) - pos));	
	dim::load(fp,l - (ftell(fp) - pos));	

	return 0;
}





