/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** graph.h
*/

#ifndef __GRAPH_H__
#define __GRAPH_H__

#include <list.h>
#include <matmath.h>

class edge;
class graph;

class node
{
protected:
	list<edge*>	edgelist;
	int		flags;
	graph		*parent;
	Vector3		v3;

public:
	node(graph*,Vector3 v);
	node(graph*,node*);
	~node();

	const char	*id();

	Vector3		vector();
	void		setVector(Vector3);

	void		add(edge *e);

	edge		*getEdge(int i);
	int		numEdges();

	void		removeEdge(edge *t);

	void		clearFlags(int f=0);

	void		replace(node*);
	int		connected(node*);

private:
	int		distance(node*);

friend class graph;
};

class edge
{
protected:
	node		*k1,*k2;
	int		flags,num_id;
	graph		*parent;

public:
	edge(graph*,node *kp1,node *kp2,int id);
	~edge();

	node		*node1();
	node		*node2();

	int		id();

	edge		*swap();

	int		closed();
	int		unique();

	void		replace(node*,node*);
	
	Vector3		vector();

friend class graph;
};


class graph
{
protected:
	list<node*>	nodelist;
	list<edge*>	edgelist;

public:
	graph();
	~graph();

	int		add(node*);
	int		add(edge*);
	int		remove(node*);
	int		remove(edge*);
	node		*getNode(int);
	edge		*getEdge(int);

	int		numNodes();
	int		numEdges();

	node		*findNode(Vector3);

	int		distance(node*,node*);

	int		isClose(list<edge*>*l = 0,int grade = 0);
	int		close();

	list<edge*>	getOpenPolygone(list<edge*>);

	int		removeDoubleEdges();
	int		removeDoubleNodes();

friend class node;
friend class edge;
};

#endif



