/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** gmesh.cpp
*/

#include "gmesh.h"


gnode::gnode(Vector3 v3)
{
	parent = 0;
	v = v3;
	state = 0;
}

gnode::gnode(gmesh *p,Vector3 v3)
{
	parent = p;
	v = v3;
	state = 0;
	
	if(parent)
		parent->addNode(this);
}

gnode::~gnode()
{
	nodelist.empty();
	if(parent)
		parent->removeNode(this);
}

Vector3	gnode::vector()
{
	return v;
}

void	gnode::setVector(Vector3 v3)
{
	v = v3;
}

int	gnode::addNode(gnode *n)
{
	return nodelist.append(n);
}

gnode	*gnode::getNode(int n)
{
	return nodelist[n];
}

int	gnode::removeNode(gnode *n)
{
	return nodelist.deleteAt(nodelist.find(n));
}

void	gnode::setState(int st)
{
	state = st;
}

gmesh::gmesh()
{
}

gmesh::~gmesh()
{
	while(nodelist.length())
	{
		delete nodelist[0];
	}
}

int	gmesh::addNode(gnode *n)
{
	return nodelist.append(n);
}

gnode	*gmesh::getNode(int n)
{
	return nodelist[n];
}

int	gmesh::removeNode(gnode *n)
{
	return nodelist.deleteAt(nodelist.find(n));
}

int	gmesh::numNodes()
{
	return nodelist.length();
}

gnode	*gmesh::findNode(Vector3 v3)
{
	int	i;
	
	for(i = 0;nodelist.length();i++)
	{
		if(nodelist[i]->vector() == v3)
		{
			return nodelist[i];
		}
	}
	
	return 0;
}

void	gmesh::sortNodes()
{
	list<gnode*>::sortfunction	*sfp;
	
	sfp = (list<gnode*>::sortfunction*)&sf;
	
	nodelist.sort(sfp);
}

int	gmesh::insortNode(gnode *n)
{
	addNode(n);
	
	sortNodes();
	
	return 0;
}

int	gmesh::sf(gnode* n1,gnode* n2)
{
	Vector3	v1,v2;
	
	v1 = n1->vector();
	v2 = n2->vector();
	
	if(v1[0] > v2[0])
		return 1;
	else if(v1[0] < v2[0])
		return -1;
	else if(v1[1] > v2[1])
		return 1;
	else if(v1[1] < v2[1])
		return -1;
	else if(v1[2] > v2[2])
		return 1;
	else if(v1[2] < v2[2])
		return -1;
	
	return 0;
}


