/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** atom.cpp
*/
#include "atom.h"
#include "num.h"

atom::atom(base *p,const char *n,texture *t) :
	body(p,n,t)
{
	numtype = NUM_ATOM;
}

atom::atom(base *p,const char *n,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	body(p,n,0,vs,vr,vt)
{
	numtype = NUM_ATOM;
}

atom::atom(base *p,const char *n,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	body(p,n,t,vs,vr,vt)
{
	numtype = NUM_ATOM;
}

atom::atom(base *p,atom *ac) :
	body(p,ac)
{
	numtype = NUM_ATOM;
}

atom::~atom()
{
}

void	atom::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("box: %s\n",name);
}



