#ifndef __TIMEWIDGET_H_INCLUDED__
#define __TIMEWIDGET_H_INCLUDED__

#include <qwidget.h>

#define TW_UNIT_COUNT 60
#define TW_TICKS_PER_UNIT 6

class CTimeWidget : public QWidget
{
	Q_OBJECT
 public:
	CTimeWidget(QWidget* parent);

 protected:
	int _value;
	bool isRunning() { return _running; }
	bool _running;
	virtual void paintEvent(QPaintEvent*);

 public slots:
        void slotTimer(long c);
        void slotStart();
	void slotPause();
	void slotStop();

	void reset() { _value = 0; update(); }

 signals:
	void sigTimeout();
};

#endif // !__TIMEWIDGET_H_INCLUDED__
