#include "main.h"

#include "timewidget.h"

#include "kwormwidget.h"

#include <qpainter.h>
#include <qpen.h>
#include <qbrush.h>

#define BAR_COLOR_EVEN blue
#define BAR_COLOR_ODD red
#define BAR_COLOR_EMPTY black
#define BAR_COLOR_INACTIVE green

CTimeWidget::CTimeWidget(QWidget* parent) : QWidget(parent)
{
	connect(this,SIGNAL(sigTimeout()),this,SLOT(reset()));
	setBackgroundMode(NoBackground);
}

void CTimeWidget::slotStart()
{
	_running = true;
	reset();
}

void CTimeWidget::slotPause()
{
	_running = false;
}

void CTimeWidget::slotStop()
{
	_running = false;
	reset();
	
}

void CTimeWidget::slotTimer(long c)
{
	if (isRunning() && !(c % TW_TICKS_PER_UNIT)) {
		++_value;
		update();
		if (_value == TW_UNIT_COUNT) emit sigTimeout();
	}
}

void CTimeWidget::paintEvent(QPaintEvent*)
{
	QPainter pt(this);
	int maxY = TW_UNIT_COUNT * 20;
	if (!isRunning()) {
		pt.fillRect(0,0,20,maxY,BAR_COLOR_INACTIVE);
		return;
	}
	QPen evenPen(BAR_COLOR_EVEN);
	QPen oddPen(BAR_COLOR_ODD);
	pt.setWindow(0,0,20,maxY);
	for (int i=0;i <= _value;i++) {
		if (i % 2) pt.setPen(evenPen);
		else pt.setPen(oddPen);
		pt.fillRect(0,maxY - (i+1) * 20,20,/*maxY - i * */20,(i % 2 ? BAR_COLOR_EVEN : BAR_COLOR_ODD));
	}
	pt.fillRect(0,0,20,maxY - (_value + 1) * 20,BAR_COLOR_EMPTY);
}
