/***************************************************************************
    kwa.cpp  fr KWA - Kanadische Waldbrandaustreter
		Spielfeld, Klassen-Implementation

                             -------------------
    begin                : Sat Sep 30 2000
    copyright            : (C) 2000 by Ulrich Bochert
    email                : schroeder_bochert@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <qwidget.h>
#include <qapplication.h>
#include <qdatetime.h>
#include <math.h>
#include <stdlib.h>//enthlt srand
#include <qpainter.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <kapp.h>

#include "kwa.h"
#include "spielstein.h"
#include "feuerwehr.h"
#include "kontroll1.h"

SpielStein *ss[200][100];
FeuerWehr *fw[9];
int DorfX[11];
int DorfY[11];

Kontroll *k1;
int TpAlt=0;//fr Kontroll



kwa::kwa(QWidget *parent, const char *name, WFlags f)
          :QWidget(parent, name)
{
//        setStyle(WStyle_NoBorder);
        char SFName[]="KWA - Kanadische Waldbrand Austreter fr KDE";
        char *SFName_p=SFName;
        setCaption(SFName_p);

        //printf("sfkonstruktor\n");
        setGeometry(0,0,790,567);
        //etWFlags( WStyle_Customize | WStyle_NoBorder);
        w=width();
        h=height();
        z=79.0;
        s=63.0;
        g=int(w/z);
        FeuerStaerke=50;
        LoeschStaerke=1.5;
        WasserVerbrauch=1.5;
        BenzinVerbrauch=4.0;
        MaxSpielDauer=4500;

        ZufallInit();

        if(g>h/s+1) g=int(h/s);
        startTimer(200);
        timerOn=true;

// MenueBar bauen
        QPopupMenu *file = new QPopupMenu;
        CHECK_PTR( file );
        QPopupMenu *evaluation = new QPopupMenu;
        CHECK_PTR( evaluation );
        QPopupMenu *help = new QPopupMenu;
        CHECK_PTR( help);
        file->insertItem("&Menleiste aus/an", this, SLOT(MenuOff()), Key_M);
        file->insertItem("&Neues Spiel", this, SLOT(NewGame()), Key_N);
        file->insertItem("Spiel &laden", this, SLOT(OpenGame()), Key_L);
        file->insertItem("Spiel &speichern... ", this, SLOT(SaveGame()), Key_S);
        file->insertItem("Spiel &anhalten", this, SLOT(PauseGame()), Key_A);
        file->insertItem("&Verlassen", this, SLOT(QuitGame()), Key_Q);

        evaluation->insertItem("&Zwischenstand", this, SLOT(Auswertung()), Key_Z);

        help->insertItem("&Inhalt", this, SLOT(help()), Key_F1);

        menueBar= new QMenuBar(this);
        CHECK_PTR( menueBar );
        menueBar->insertItem( "&Datei", file );
        menueBar->insertItem( "Aus&wertung", evaluation );
        menueBar->insertItem( "&Hilfe", help );


// Spielsteine bauen
        for (int i=0; i<z; i++)
            for (int j=0; j<s; j++)
                {
                  ss[i][j] = new SpielStein (this,"",i,j);
                  connect (ss[i][j], SIGNAL(FWRichtungSetzen(int, int, int )),
                           this,SLOT(FWRichtungSetzen(int, int, int)));
                  connect (ss[i][j], SIGNAL(FWMenueBauen(int, int, int )),
                           this,SLOT(FWMenueBauen(int, int, int)));
                  connect (ss[i][j], SIGNAL(WillLoeschenChanged(int, bool, int, int )),
                           this,SLOT(FWSetWillLoeschen(int, bool, int, int)));
                  connect (ss[i][j], SIGNAL(FWKontrollClose()),
                           this,SLOT(KontrollClose()));
                }

// Feuerwehren bauen
            for (int i=0; i<9; i++)
            {
                fw[i]=new FeuerWehr(i+1, float(ZufallsZahl()*z),
                                    float(ZufallsZahl()*s), z, s,
                                    double(ZufallsZahl()*360),
                                    int(25+ZufallsZahl()*75),
                                    int(2500+ZufallsZahl()*7500));
            }
// DorfBauen
            /*double tmpX=20+ZufallsZahl()*(z-40);
            double tmpY=15+ZufallsZahl()*(s-30);
            ss[int(tmpX)][int(tmpY)]->setHaus(true);
            DorfX[0]=int(tmpX);
            DorfY[0]=int(tmpY);
            for (int n=1; n<11; n++)
            {
                tmpX=tmpX+((ZufallsZahl()-0.5)*2);
                tmpY=tmpY+((ZufallsZahl()-0.5)*2);
                ss[int(tmpX)][int(tmpY)]->setHaus(true);
                DorfX[n]=int(tmpX);
                DorfY[n]=int(tmpY);
            }*/

//KontrollFeld bauen
        k1=new Kontroll(this,0);
        connect (k1,SIGNAL(LoeschenChanged2(int, bool)),this,SLOT(FWSetWillLoeschen2(int,bool)));
        connect (k1,SIGNAL(k1_hidden(int)),this,SLOT(FW_k1_hidden(int)));
        connect (k1,SIGNAL(k1_moved()),this,SLOT(FW_k1_moved()));
        k1->close();
	SpielFeldNeuZeichnen();

        init();
}

void kwa::init()
{
        DorfBrennt=false;
        timercount=0;
        timercount2=0;
        FeuerLegenCounter=0;
        FWselected=false;
// Spielsteine zurcksetzen
        for (int i=0; i<z; i++)
            for (int j=0; j<s; j++)
                {
                  ss[i][j]->init(i, j);
                }
// Feuerwehren zurcksetzen
            for (int i=0; i<9; i++)
            {
                fw[i]->init(i+1, float(ZufallsZahl()*z),
                                    float(ZufallsZahl()*s), z, s,
                                    double(ZufallsZahl()*360),
                                    int(25+ZufallsZahl()*75),
                                    int(2500+ZufallsZahl()*7500));
            }
// Dorf zurcksetzen
            double tmpX=20+ZufallsZahl()*(z-40);
            double tmpY=15+ZufallsZahl()*(s-30);
            ss[int(tmpX)][int(tmpY)]->setHaus(true);
            DorfX[0]=int(tmpX);
            DorfY[0]=int(tmpY);
            for (int n=1; n<11; n++)
            {
                tmpX=tmpX+((ZufallsZahl()-0.5)*2);
                tmpY=tmpY+((ZufallsZahl()-0.5)*2);
                ss[int(tmpX)][int(tmpY)]->setHaus(true);
                DorfX[n]=int(tmpX);
                DorfY[n]=int(tmpY);
            }

//KontrollFeld zurcksetzen
        k1->close();
}

kwa::~kwa()
{
        //printf("SF destruktor\n");
/*      disconnect();
        k1->close();
*/
}
void kwa::closeEvent(QCloseEvent *e)
{
        e->ignore();
        QuitGame();
}

void kwa::resizeEvent(QResizeEvent *)
{
        //printf("Resize\n");
        w=width();
        h=height();
        g=int(w/z);

        if(g>h/s+1)
                g=int(h/s);

        GitterZeichnen();
}
void kwa::moveEvent(QMoveEvent *)
{
        GitterZeichnen();
}
void kwa::showEvent(QShowEvent *)
{
        GitterZeichnen();
}
void kwa::focusInEvent(QFocusEvent*)
{
        GitterZeichnen();
}
void kwa::keyPressEvent(QKeyEvent *k)
{
//                printf("KeyPress %x\n", k->key());
        if (k->key()==Key_M)
        {
//                printf("KeyPress M\n");
                MenuOff();
        }
        else if (k->key()==Key_Meta)
        {
//                printf("KeyPress ALT %d\n", k->key());
                MenuOff();
        }
}
void kwa::SpielFeldNeuZeichnen()
{
        //printf("sf neuzeichnen\n");
        SFinitialisiert=false;
        if (g>0)
        {
        for (int i=0; i<z; i++)
            for (int j=0; j<s; j++)
                {
                //printf("sf %2d, %2d, %2d\n", i, j, g);
                //ss[i][j]->setGeometry(i*g,j*(g-1), (g-1), (g-2));
                ss[i][j]->setGeometry(i*g,j*(g-1), g, (g-1));//ohne Gitternetz
                //printf("sf ende %2d, %2d, %2d\n", i, j, g);

                }
        }
        //printf("sf neuzeichnen 1\n");
        float tmp1;
        float tmp2;
        for (int i=0; i<9; i++)
        {
            tmp1=fw[i]->getXPos();
            tmp2=fw[i]->getYPos();
            //printf("FW%2d , x %1.5f y %1.5f\n", i,tmp1,tmp2);
            ss[int(tmp1)][int(tmp2)]->setType(i+1);
            //printf("FW%2d Typesetzen, x %3d y %3d\n",i,int(tmp1),int(tmp2));

        }
}
void kwa::ZufallInit()
{
        //printf("zufallsinit\n");
        QTime midnight(0,0,0);
        srand(midnight.secsTo(QTime::currentTime()) );
}

float kwa::ZufallsZahl()
{
                //printf("zufallszahlzwischen null und eins\n");
        return float (rand()/(RAND_MAX + 1.0));
}
void kwa::FeuerLegen()
{
                int tmp1=int(ZufallsZahl()*z);
                int tmp2=int(ZufallsZahl()*s);
        if(ss[tmp1][tmp2]->getHaus()==false)
        {
                ss[tmp1][tmp2]->setFeuerStatus(24);
                FeuerLegenCounter++;
        }
        else FeuerLegen();
                //printf("feuergelegt\n");
}
void kwa::FeuerAusbreiten(int x, int y)
{
        //printf("FeuerAusbreiten\n");
        double tmp1;
        double tmp2;
        tmp1=ss[x][y]->getFeuerStatus();
        if (tmp1<5||tmp1>=200)return;
        ss[x][y]->setFeuerStatus(tmp1+2);
        for (int i=-1; i<2;i++)
                {
                          if (x+i<0 || x+i>z-1 ) continue;
                          tmp2=ss[x+i][y]->getFeuerStatus();
                          //printf("FeuerAusbreiten %3d, %3d %4.1f\n", x+i, y, tmp2);
                          ss[x+i][y]->setFeuerStatus(tmp2+2);
                }
        for (int i=-1; i<2; i++)
                {
                          if (y+i<0 || y+i>s-1) continue;
                          tmp2=ss[x][y+i]->getFeuerStatus();
                          //printf("FeuerAusbreiten %3d, %3d %4.1f\n", x, y+i, tmp2);
                          ss[x][y+i]->setFeuerStatus(tmp2+2);
                }
//printf("FeuerAusbr. Verlassen\n");
}

void kwa::timerEvent(QTimerEvent *)
{
        int n;
        timercount++;
        timercount2++;
        if(SFinitialisiert==false)
        {
        for (int i=0; i<z; i++)
            for (int j=0; j<s; j++)
            {
                ss[i][j]->RahmenZeichnen();
            }
        SFinitialisiert=true;
        }

        //int FeuerStaerke=50;//Spielsteine pro TimerEvent, auf denen Feuer ausgebreitet wird
        //float LoeschStaerke=1.5;
        //BenzinVerbrauch wird im FeuerwehrModul gesteuert
        //float WasserVerbrauch=1.0;
//SpielEnde
        if (timercount>MaxSpielDauer)
        {
                Auswertung();
        }
        else if (DorfBrennt==true)
        {
                Auswertung();
                NewGame();
        }
//Feuer ausbreiten
        for (n=0; n<FeuerStaerke; n++)
        {
                int tmp1=int(ZufallsZahl()*z);
                int tmp2=int(ZufallsZahl()*s);
                double tmp=ss[tmp1][tmp2]->getFeuerStatus();
                if (tmp>5 && tmp<200) FeuerBrennt=true;
                FeuerAusbreiten(tmp1, tmp2);
                if (timercount2>z*s/FeuerStaerke/5)//5 Felder sollen mindestens brennen
                {
                        //printf("Feuerbrennt: %ld\n", FeuerBrennt);
                        timercount2=0;
                        if (FeuerBrennt==false) FeuerLegen();
                        FeuerBrennt=false;
                }
        }
// Huser nachzeichnen
        //printf("Haus \n");
        for (int i=0; i<11; i++)
        {
            //printf("Haus %3d, %3d\n", DorfX[i], DorfY[i]);
            ss[DorfX[i]][DorfY[i]]->SpielSteinFarbeSetzen();
            if(ss[DorfX[i]][DorfY[i]]->getFeuerStatus()>5) DorfBrennt=true;
        }
// Feuerwehren lschen, orten Feuer und fahren
        for (n=0; n<9; n++)
        {
        //LSCHEN
                //printf("FWLOESCHEN\n");
                int tmpX=int(fw[n]->getXPos());
                int tmpY=int(fw[n]->getYPos());
                double tmpW=fw[n]->getWasser();
            if (fw[n]->getWillLoeschen()==true)
            {
                if (tmpW>0)
                {
                //printf("Wasser %4d in FW %1d\n",tmpW, n+1);
                        for (int i=-2; i<3;i++)
                          for (int j=-2; j<3;j++)
                          {
                           if (tmpX+i<0 || tmpX+i>z-1 || tmpY+j<0 || tmpY+j>s-1)
                                 continue;
                           double tmpF=ss[tmpX+i][tmpY+j]->getFeuerStatus();
                           if (tmpF>5 && tmpF<200)
                           {
                                 //printf("FeuerStat %1.4f %1d \n",tmpF,n+1);
                                 tmpF=tmpF+(1-(pow(i,2)+pow(j,2))/8)*LoeschStaerke;
                                 ss[tmpX+i][tmpY+j]->setFeuerStatus(tmpF);
                                 tmpW=tmpW-WasserVerbrauch;
                                 fw[n]->setWasser(tmpW);
                           //SelbstSchutz bei Wassermangel
                                 if (tmpW<=0)
                                 {
                                         fw[n]->setWillLoeschen(false);
                                         ss[tmpX][tmpY]->setWillLoeschen(false);
                                 }
                          }
                          else if (tmpF>0 && tmpF<=5)
                                {
                                 tmpW=tmpW-WasserVerbrauch;
                                 fw[n]->setWasser(tmpW);
                                 ss[tmpX+i][tmpY+j]->setFeuerStatus(0);
                                }
                          }
                }
            }
        //FEUER SUCHEN
            if ((ss[tmpX][tmpY]->getFeuerStatus()<5||ss[tmpX][tmpY]->getFeuerStatus()>150) && fw[n]->getWillLoeschen()==true)
            {
                //printf("feuerSuchen %1d\n",n);
                int fsMaxX=0; // merkt sich das Feld mit dem strksten Feuer
                int fsMaxY=0;
                double fsWichtung=30.0;//je kleiner, desto nher und strker (jnger) ist das Feuer
                for (int i=-3; i<4;i++)
                  for (int j=-3; j<4;j++)
                  {
                        if (tmpX+i<0 || tmpX+i>z-1 || tmpY+j<0 || tmpY+j>s-1)
                                continue;
                        if (ss[tmpX+i][tmpY+j]->getFeuerStatus()>1 && ss[tmpX+i][tmpY+j]->getFeuerStatus()<200)
                        {
                            if (fsWichtung>i*i+j*j+ss[tmpX+i][tmpY+j]->getFeuerStatus()/200)
                            {
                                fsMaxX=i;
                                fsMaxY=j;
                                fsWichtung=i*i+j*j+ss[tmpX+i][tmpY+j]->getFeuerStatus()/200;
                            }
                        }
                  }
                if (fsWichtung<30.0)
                {
                        //printf("F gefunden %1d, x %2d, y %2d\n",n+1,tmpX+fsMaxX,tmpY+fsMaxY);
                        fw[n]->setRichtung(tmpX+fsMaxX,tmpY+fsMaxY );
                        fw[n]->setFahrt(fsWichtung/190.0 );
                }
                else
                {
                        fw[n]->setFahrt(0.1);
                        //zum Tanken ins Dorf
                        if(fw[n]->getBenzin()<30||fw[n]->getWasser()<1000)
                        {
                                fw[n]->setRichtung(DorfX[1], DorfY[1]);
                                double fwX=double(fw[n]->getXPos());
                                double fwY=double(fw[n]->getYPos());
                                double dX=double(DorfX[1]);
                                double dY=double(DorfY[1]);
                                if((fwX-dX)*(fwX-dX)+(fwY-dY)*(fwY-dY)<.25)
                                {
                                        fw[n]->setFahrt(sqrt((fwX-dX)*(fwX-dX)+(fwY-dY)*(fwY-dY)));
                                }

                        }
                }
            }
            else if (ss[tmpX][tmpY]->getFeuerStatus()>=5 && ss[tmpX][tmpY]->getFeuerStatus()<150)//SelbstSchutz
            {
                //Flucht:
                //printf("Alarm bei %2d\n",n+1);
                for (int i=-1; i<2;i++)
                  for (int j=-1; j<2;j++)
                  {
                        if (tmpX+i<0 || tmpX+i>z-1 || tmpY+j<0 || tmpY+j>s-1) continue;
                        if (ss[tmpX+i][tmpY+j]->getFeuerStatus()<5||ss[tmpX+i][tmpY+j]->getFeuerStatus()>150)
                        {
                          //printf("Alarm2 bei %2d\n",n+1);
                          fw[n]->setRichtung(tmpX+i,tmpY+j );
                          fw[n]->setFahrt(0.1);
                          //fw[n]->setWillLoeschen(true);
                          break;
                         }
                  }

            }
        //FAHREN
                fw[n]->fahren(BenzinVerbrauch);
                int tmp2X=int(fw[n]->getXPos());
                int tmp2Y=int(fw[n]->getYPos());
                //Nachmalen der FWs
                ss[tmpX][tmpY]->setType(n+1);
                ss[tmpX][tmpY]->setWillLoeschen(fw[n]->getWillLoeschen());
                ss[tmpX][tmpY]->setAbgebrannt(fw[n]->getAbgebrannt());
                ss[tmpX][tmpY]->setSelected(fw[n]->getSelected());
                ss[tmpX][tmpY]->SpielSteinFarbeSetzen();
              //zu hei?
                double tmp=ss[tmp2X][tmp2Y]->getFeuerStatus();
                        if (tmp> 50 && tmp <150 && fw[n]->getAbgebrannt()==false)
                        {
                                //FW hlt an
                                tmp2X=tmpX;
                                tmp2Y=tmpY;
                                fw[n]->setXPos(tmpX);
                                fw[n]->setYPos(tmpY);
                                //brennt FW?
                                tmp=ss[tmpX][tmpY]->getFeuerStatus();
                                if (tmp> 50 && tmp <150 && fw[n]->getAbgebrannt()==false)
                                {
                                        //printf("FW brennt %1d\n", n+1);
                                        fw[n]->setBenzin(0);
                                        fw[n]->setWasser(0);
                                        ss[tmp2X][tmp2Y]->setAbgebrannt(true);
                                        fw[n]->setAbgebrannt(true);
                                }
                        }
                if(tmpX!=tmp2X||tmpY!=tmp2Y)// wenn sich FW-Position gendert hat...
                        {
                        // Benzinaustausch erforderlich?
                        int tmpFW=ss[tmp2X][tmp2Y]->getType();
                        if (tmpFW>0)
                        {
                                if (fw[tmpFW-1]->getBenzin()==0 && fw[tmpFW-1]->getAbgebrannt()==false)
                                {
                                        double tmpB=fw[n]->getBenzin();
                                        fw[tmpFW-1]->setBenzin(tmpB/2);
                                        fw[n]->setBenzin(tmpB/2);
                                }
                        }
                        ss[tmpX][tmpY] ->setType(0);
                        ss[tmpX][tmpY] ->setSelected(false);
                        ss[tmpX][tmpY] ->setWillLoeschen(true);
                        ss[tmpX][tmpY] ->setAbgebrannt(false);
                        ss[tmp2X][tmp2Y]->setType(n+1);
                //Tanken
                        bool tmp=ss[tmp2X][tmp2Y]->getHaus();
                        if (tmp==true)
                                {
                                //printf("Tanken %1d\n", n+1);
                                fw[n]->setBenzin(100);
                                fw[n]->setWasser(10000);
                                }
                        if(fw[n]->getSelected()==true)ss[tmp2X][tmp2Y]->setSelected(true);
                        if(fw[n]->getWillLoeschen()==false)ss[tmp2X][tmp2Y]->setWillLoeschen(false);
                        }
        }
}
void kwa::FWRichtungSetzen(int Tp, int xPos, int yPos)
{
    //printf("SFssSelected\n");
     if (FWselected==false)
     {
        if (Tp==0)// keine FW angeklickt
        {
                FWsuchen(xPos, yPos, 1);
                return;
        }
        else// FW angeklickt
        {
                //printf("neue Richtg %2d, %2dfr%2d\n",xPos,yPos,SSType);
                SSType=Tp;
                int x=int(fw[SSType-1]->getXPos());
                int y=int(fw[SSType-1]->getYPos());
                ss[x][y]->setSelected(true);
                fw[SSType-1]->setSelected(true);
                FWselected=true;
                FWMenueBauen(Tp, x, y);
                //printf("Selected auf wahr, Tp: %d\n", Tp);
        }
     }
     else //FWselected==true
     {
        fw[SSType-1]->setRichtung(xPos,yPos);
     }
//printf("SFssSelected_verl\n");
}
void kwa::FWMenueBauen(int Tp, int xPos, int yPos)
{
       //printf("FWMenue Tp:%1d TpAlt: %1d\n", Tp, TpAlt);
	double Richtung=fw[Tp-1]->getRichtung();
	double Speed=fw[Tp-1]->getFahrt();
	int Benzin=fw[Tp-1]->getBenzin();
	int Wasser=int(fw[Tp-1]->getWasser()/100);
	bool Loeschen=fw[Tp-1]->getWillLoeschen();
	k1->init(Tp,Richtung,Speed,Benzin,Wasser,Loeschen);
 	
 	disconnect (fw[TpAlt],0, k1,0);
	disconnect ( k1,0,fw[TpAlt],0);

        TpAlt=Tp-1;

        connect (fw[Tp-1],SIGNAL(FahrtChanged(double)),k1,SLOT(SpeedSlot(double)));
        connect (k1,SIGNAL(SpeedChanged(double)),fw[Tp-1],SLOT(FahrtSlot(double)));
        connect (fw[Tp-1],SIGNAL(RichtungChanged(double)),k1,SLOT(RichtungSlot(double)));
        connect (k1,SIGNAL(RichtungChanged(double)),fw[Tp-1],SLOT(RichtungSlot(double)));
        connect (fw[Tp-1],SIGNAL(BenzinChanged(int)),k1,SLOT(BenzinSlot(int)));
        connect (fw[Tp-1],SIGNAL(WasserChanged(int)),k1,SLOT(WasserSlot(int)));
        connect (fw[Tp-1],SIGNAL(WillLoeschenChanged(bool)),k1,SLOT(LoeschenSlot(bool)));
        connect (k1,SIGNAL(LoeschenChanged(bool)),fw[Tp-1],SLOT(WillLoeschenSlot(bool)));
        int x;//x-Position des Kontrollfensters
        int y;//y-Position des Kontrollfensters
        if (xPos>z-140/g-1)
                x=xPos*g-130-g;
        else
                x=xPos*g+g;
        if (yPos>s-48/(g-1)-1)
                y=yPos*(g-1)-48-(g-1);
        else
                y=yPos*(g-1)+(g-1);
        k1->move(x,y);
	k1->init(Tp,Richtung,Speed,Benzin,Wasser,Loeschen);
        k1->show();
}
void kwa::FWsuchen(int xPos, int yPos, int Herkunft)
{
                for (int i=-1; i<2;i++)
                  for (int j=-1; j<2;j++)
                  {
                        if (xPos+i<0 || xPos+i>z-1 || yPos+j<0 || yPos+j>s-1)
                                continue;
                        int Tp=ss[xPos+i][yPos+j]->getType();
                        if (Tp!=0 && Herkunft==1)//Herkunft: RichtungSetzen
                        {
                                int Tp=ss[xPos+i][yPos+j]->getType();
                                FWRichtungSetzen(Tp, xPos+i, yPos+j);
                        }
                  }

}

void kwa::FWsuchen(bool L, int xPos, int yPos, int Herkunft)
//zum Setzen von willLoeschen per Doppelklick
{
return;//Stillgelegt
                for (int i=-1; i<2;i++)
                  for (int j=-1; j<2;j++)
                  {
                        if (xPos+i<0 || xPos+i>z-1 || yPos+j<0 || yPos+j>s-1)
                                continue;
                        if (ss[xPos+i][yPos+j]->getType()!=0 && Herkunft==3)
                        {
                                int Tp=ss[xPos+i][yPos+j]->getType();
                                FWSetWillLoeschen(Tp,L ,xPos+i, yPos+j);
                        }
                  }

}
void kwa::FWSetWillLoeschen(int Tp, bool L, int x, int y)
{
/*        if (Tp==0)
        {
                FWsuchen(L,x,y,3);
                return;
        }
        //printf("FWSet W L\n");
        fw[Tp-1]->setWillLoeschen(L);
        fw[Tp-1]->setSelected(false);
        ss[x][y]->setWillLoeschen(L);
        ss[x][y]->setSelected(false);
        FWselected=false;
*/}
void kwa::FWSetWillLoeschen2(int Tp, bool L)
{
        fw[Tp-1]->setWillLoeschen(L);
        int x=int(fw[Tp-1]->getXPos());
        int y=int(fw[Tp-1]->getYPos());
        ss[x][y]->setWillLoeschen(L);
}

void kwa::KontrollClose()
{
        k1->close();
}

void kwa::FW_k1_hidden(int Tp)
{
        //printf("k1_hidden signal received %1d \n", Tp);
        int x=int(fw[Tp-1]->getXPos());
        int y=int(fw[Tp-1]->getYPos());
        ss[x][y]->setSelected(false);
        fw[Tp-1]->setSelected(false);
        FWselected=false;
        SFinitialisiert=false;
}
void kwa::FW_k1_moved()
{
        GitterZeichnen();
}

void kwa::GitterZeichnen()
{
        for (int i=0; i<z; i++)
            for (int j=0; j<s; j++)
            {
                ss[i][j]->RahmenZeichnen();
            }
        SFinitialisiert=true;
}

void kwa::MenuOff()
{
        if (menueBar->isVisible()==true)
        {
        //printf("MenueOff\n");
        menueBar->hide();
        GitterZeichnen();
        }
        else
        {
        //printf("MenueOn\n");
        menueBar->show();
        }
}
void kwa::OpenGame()
{
        killTimers();
        timerOn=false;
        switch(QMessageBox::information( this, "KWA - Kanadische Waldbrand Austreter",
                "Das Spiel ist im gegenwrtigen Stand nicht gespeichert\n"
                "Mchten Sie speichern bevor das neue Spiel gestartet wird?",
                "&Speichern...", "&Nicht speichern", "&Abbruch",
                0,      // Enter == button 0
                2 ) ) { // Escape == button 2
        case 0: // Save clicked, Alt-S or Enter pressed.
                if (SaveGame()==true) SpielLaden();
                break;
        case 1: // Don't Save clicked or Alt-D pressed
                // don't save but exit
                SpielLaden();
                break;
        case 2: // Cancel clicked, Alt-C or Escape pressed
                // don't exit
                break;
        }
        startTimer(200);
        timerOn=true;
}
void kwa::SpielLaden()
{
        QString IFileName=QFileDialog::getOpenFileName(0, "*.kwa", this);
        if (!IFileName.isNull())
        {
                FILE *Datei_p=NULL;
                Datei_p=fopen(IFileName, "r");
                if (Datei_p==NULL)
                {
                        QMessageBox::information( this, "KWA - Kanadische Waldbrand Austreter",
                        "Fehler beim ffnen der Datei\n", 0 );
                        return;
                }
                       int    itmp;
                       float  ftmp;
                //Felder pro Zeile
                       fscanf(Datei_p, "%f\n", &ftmp); z=ftmp;
                //Felder pro Spalte
                       fscanf(Datei_p, "%f\n", &ftmp); s=ftmp;
                //Zahl der gelegten Feuer
                       fscanf(Datei_p, "%d\n", &itmp); FeuerLegenCounter=itmp;
                //verstrichene Zeit
                       fscanf(Datei_p, "%d\n\n", &itmp); timercount=itmp;
                //Feuerstatus der Felder
                for (int i=0; i<z; i++)
                    for (int j=0; j<s; j++)
                    {
                        fscanf(Datei_p, "%f\n", &ftmp);
                        ss[i][j]->init(i, j);
                        ss[i][j]->setFeuerStatus(ftmp);
                    }
                    //printf("SpielSteine geladen\n");

                //Feuerwehr: Nummer, xPos, yPos, Wasser, Benzin, Fahrt, Lschauftrag, Richtung
                for (int n=0; n<9; n++)
                {
                       fscanf(Datei_p, "%d\n", &itmp);
                       fscanf(Datei_p, "%f\n", &ftmp); fw[n]->setXPos(ftmp);
                       fscanf(Datei_p, "%f\n", &ftmp); fw[n]->setYPos(ftmp);
                       fscanf(Datei_p, "%f\n", &ftmp); fw[n]->setRichtung(ftmp);
                       fscanf(Datei_p, "%f\n", &ftmp); fw[n]->setFahrt(ftmp);
                       fscanf(Datei_p, "%d\n", &itmp); fw[n]->setBenzin(itmp);
                       fscanf(Datei_p, "%f\n", &ftmp); fw[n]->setWasser(ftmp);
                       fscanf(Datei_p, "%d\n", &itmp); fw[n]->setWillLoeschen(itmp);
                       fscanf(Datei_p, "%d\n", &itmp); fw[n]->setAbgebrannt(itmp);
                    //printf("FW %d geladen\n", n);
                }
                    //printf("FW geladen\n");
                // Hauser
                for (int m=0; m<11; m++)
                {
                       fscanf(Datei_p, "%d\n", &itmp);
                       fscanf(Datei_p, "%d\n", &itmp); DorfX[m]=itmp;
                       fscanf(Datei_p, "%d\n", &itmp); DorfY[m]=itmp;
                       ss[int(DorfX[m])][int(DorfY[m])]->setHaus(true);

                }
                //printf("Dorf geladen\n");
                fclose(Datei_p);
                startTimer(200);
                timerOn=true;
       }

}
bool kwa::SaveGame()
{
        killTimers();
        timerOn=false;

        QString OFileName=QFileDialog::getSaveFileName(0, "*.kwa", this);
        if (!OFileName.isNull())
        {
                //Brandflche ermitteln
                FILE *Datei_p=NULL;
                Datei_p=fopen(OFileName, "w");
                if (Datei_p==NULL)
                {
                        QMessageBox::information( this, "KWA - Kanadische Waldbrand Austreter",
                        "Fehler beim ffnen der Datei\n", 0 );
                        return false;
                }
                //Felder pro Zeile
                       fprintf(Datei_p, "%3.0f\n", z);
                //Felder pro Spalte
                       fprintf(Datei_p, "%3.0f\n\n", s);
                //Zahl der gelegten Feuer
                       fprintf(Datei_p, "%d\n", FeuerLegenCounter);
                //verstrichene Zeit
                       fprintf(Datei_p, "%d\n\n", timercount);
                //Feuerstatus der Felder
                for (int i=0; i<z; i++)
                    for (int j=0; j<s; j++)
                    {
                        fprintf(Datei_p, "%3.2f\n", ss[i][j]->getFeuerStatus());
                    }
                    //printf("SpielSteine gesichert\n");
                //Feuerwehr: Nummer, xPos, yPos, Wasser, Benzin, Fahrt, Lschauftrag, Richtung
                for (int n=0; n<9; n++)
                {
                       fprintf(Datei_p, "%d\n", n);
                       fprintf(Datei_p, "%3.2f\n", fw[n]->getXPos());
                       fprintf(Datei_p, "%3.2f\n", fw[n]->getYPos());
                       fprintf(Datei_p, "%3.2f\n", fw[n]->getRichtung());
                       fprintf(Datei_p, "%3.2f\n", fw[n]->getFahrt());
                       fprintf(Datei_p, "%d\n", fw[n]->getBenzin());
                       fprintf(Datei_p, "%5.0f\n", fw[n]->getWasser());
                       fprintf(Datei_p, "%d\n", fw[n]->getWillLoeschen());
                       fprintf(Datei_p, "%d\n", fw[n]->getAbgebrannt());
                //printf("FW %d gesichert\n", n);
                }
                //printf("FW gesichert\n");
                // Hauser
                for (int m=0; m<11; m++)
                {
                       fprintf(Datei_p, "%d\n", m);
                       fprintf(Datei_p, "%d\n", DorfX[m]);
                       fprintf(Datei_p, "%d\n", DorfY[m]);
                }
                //printf("Dorf gesichert\n");
                fclose(Datei_p);
                startTimer(200);
                timerOn=true;
                return true;
        }
        else
        {
                return false;
                startTimer(200);
                timerOn=true;
        }

}
void kwa::PauseGame()
{
        if (timerOn==true)
                {
                killTimers();
                timerOn=false;
                }
        else
                {
                startTimer(200);
                timerOn=true;
                }

}
void kwa::NewGame()
{
        killTimers();
        timerOn=false;
        switch(QMessageBox::information( this, "KWA - Kanadische Waldbrand Austreter",
                "Das Spiel ist im gegenwrtigen Stand nicht gespeichert\n"
                "Mchten Sie speichern bevor das neue Spiel gestartet wird?",
                "&Speichern...", "&Nicht speichern", "&Abbruch",
                0,      // Enter == button 0
                2 ) ) { // Escape == button 2
        case 0: // Save clicked, Alt-S or Enter pressed.
                if (SaveGame()==true) init();
                break;
        case 1: // Don't Save clicked or Alt-D pressed
                // don't save but exit
                init();
                break;
        case 2: // Cancel clicked, Alt-C or Escape pressed
                // don't exit
                break;
}
        startTimer(200);
        timerOn=true;
}

void kwa::QuitGame()
{
        killTimers();
        timerOn=false;
        switch(QMessageBox::information( this, "KWA - Kanadische Waldbrand Austreter",
                "Das Spiel ist im gegenwrtigen Stand nicht gespeichert\n"
                "Mchten Sie speichern bevor KWA beendet wird?",
                "&Speichern...", "&Nicht speichern", "&Abbruch",
                0,      // Enter == button 0
                2 ) ) { // Escape == button 2
        case 0: // Save clicked, Alt-S or Enter pressed.
                if (SaveGame()==true) qApp->quit();
                break;
        case 1: // Don't Save clicked or Alt-D pressed
                // don't save but exit
                qApp->quit();
                break;
        case 2: // Cancel clicked, Alt-C or Escape pressed
                // don't exit
                startTimer(200);
                timerOn=true;
                break;
        }
}
void kwa::Auswertung()
{
                killTimers();
                timerOn=false;

                int SchadenCounter=0;
                for (int i=0; i<z; i++)
                {
                        for (int j=0; j<s; j++)
                        {
                                if (ss[i][j]->getFeuerStatus()>5)
                                {
                                        if (timercount>=MaxSpielDauer) ss[i][j]->setFeuerStatus(200);
                                        SchadenCounter++;
                                }
                        }
                }
                /*printf("schaden: %d\n",SchadenCounter);
                printf("verstrichene Zeit (min) %ld\n",timercount);
                printf("gelegte Feuer: %d\n", FeuerLegenCounter);*/
                QString s0;
                QString s1;
                QString s2;
                QString s3;
                QString s4;
                QString s5;
                QString s6;
                QString s7;
                QString s8;
                QString s9;
                QString s10;
                //printf("Dorfbrennt= %d\n", DorfBrennt);
                if (timercount>=MaxSpielDauer)
                        s0="Ein groer Regen hat die Feuer zum Verlschen gebracht!\n\n";
                else
                {
                        if (DorfBrennt==false)
                                s0="Zwischenergebnis:\n\n";
                        else //(DorfBrennt==true)
                                s0="Die ersten Huser sind den Flammen zum Opfer gefallen - das wird Sie Ihren Job kosten!\n\n";
                }
                s1="In ";
                s2.setNum(float(timercount)/5.0/60.0, 'f', 1);
                s3=" Minuten Spielzeit sind ";
                s4.setNum(FeuerLegenCounter);
                s5=" Feuer gelegt worden.\n";
                s6="Pro Brandstiftung sind ";
                s7.setNum(float(SchadenCounter)/float(FeuerLegenCounter), 'f', 1);
                s8=" Felder Wald vernichtet worden.\n\n";
                if (s0=="Zwischenergebnis:\n\n")
                {
                        if (float(SchadenCounter)/float(FeuerLegenCounter)<5)
                                s9="Die Dorfbewohner verfolgen Ihre Bemhungen mit freundlichem Interesse.";
                        else if(float(SchadenCounter)/float(FeuerLegenCounter)<20)
                                s9="Die Dorfbewohner verfolgen Ihre Bemhungen mit Interesse.";
                        else if (float(SchadenCounter)/float(FeuerLegenCounter)<40)
                                s9="Die Dorfbewohner verfolgen Ihre Bemhungen mit Besorgnis.";
                        else if (float(SchadenCounter)/float(FeuerLegenCounter)>=40)
                                s9="Die Dorfbewohner verfolgen Ihre Bemhungen mit blankem Entsetzen!";
                }
                else if (s0=="Die ersten Huser sind den Flammen zum Opfer gefallen - das wird Sie Ihren Job kosten!\n\n")
                {
                        if (float(SchadenCounter)/float(FeuerLegenCounter)<5)
                                s9="...schade, dabei ist alles so gut gelaufen!";
                        else if (float(SchadenCounter)/float(FeuerLegenCounter)<20)
                                s9="...schade, dabei ist alles ganz normal gelaufen!";
                        else if (float(SchadenCounter)/float(FeuerLegenCounter)<40)
                                s9="...aber das hat sich ja schon abgezeichnet!";
                        else if (float(SchadenCounter)/float(FeuerLegenCounter)>=40)
                                s9="...aber das mute ja so kommen!";
                }
                else if(s0=="Ein groer Regen hat die Feuer zum Verlschen gebracht!\n\n")
                {
                        if (FeuerLegenCounter<10)
                                s9="Das gibt wohl eine Umorganisation bei der Feuerwehr...";
                        else if (FeuerLegenCounter<14)
                                s9="Ob Ihnen dafr wohl jemand auf die Schulter klopft?";
                        else if (FeuerLegenCounter<18)
                                s9="Sie haben sich wacker geschlagen - auf dem nchsten Schtznefest gibt es fr Sie Freibier!";
                        else if (FeuerLegenCounter>=18)
                                s9="Sie haben sich beeindruckend geschlagen - am Ende werden Sie noch Brgermeister!";
                }

                s10=s0+s1+s2+s3+s4+s5+s6+s7+s8+s9;
                QMessageBox::information( this, "KWA - Kanadische Waldbrand Austreter",
                s10, "OK", 0);

                if(timercount<MaxSpielDauer)
                {
                        startTimer(200);
                        timerOn=true;
                }
}

void kwa::help()
{
        //printf("help1\n");
        kapp->invokeHTMLHelp("", "");
        //printf("help2\n");
}
#include "kwa.moc"
