#ifndef _SolTopLevelWidget_
#define _SolTopLevelWidget_

#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kmenubar.h>
#include <qpopmenu.h>
#include <kiconloader.h>
#include "SolTable.h"

#define DEF_WIDTH 620
#define DEF_HEIGHT 530

class SolTopLevelWidget : public KTopLevelWidget {
  Q_OBJECT;
public:
  SolTopLevelWidget( const char *name = NULL );
  ~SolTopLevelWidget();

private:
  SolTable *sol;
  QPopupMenu *filemenu, *gamemenu, *helpmenu;
  KMenuBar *menubar;
  KStatusBar *statusbar;
  KToolBar *toolbar;
  int deal_id,undo_id;

private slots:
  void score(int);
  void newGameStarted(SolTable::GameStyle);
  void gameWon();
  void undoable(bool);
  void about();
  void help();
  void options();
  void newgame();
  void _exit();
};
#endif




