/*
 * puz_app.cpp -- Copyright (C) 1998 by M. G"otze
 */

#include <iostream.h>

#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qstring.h>

#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <ktopwidget.h>

#include "icons.h"
#include "puzzle.moc.cpp"
#include "puz_app.moc.cpp"

const char *appName = "KSlide";
const char *appVersion = "0.5.1";
const char *appDate = "08/15/98";

KSlideApp::KSlideApp()
  : KTopLevelWidget(), mBar(0), puzzle(0)
{
  QPixmap *icons[9];
  for (int i = 0; i < 9; i++)
    icons[i] = new QPixmap(xpmIcons[i]);

  setCaption(appName);
  locale = kapp->getLocale();

  puzzle = new KSlidePuzzle(this, 0, kapp->kde_datadir() + "/kslide");
  setView(puzzle, FALSE);

  QPopupMenu *game = new QPopupMenu();
  mIDs.scramble = game->insertItem(locale->translate("&Scramble"), puzzle,
    SLOT(scramble()), Key_F2);
  mIDs.order = game->insertItem(locale->translate("&Order"), puzzle,
    SLOT(order()));
  game->insertSeparator();
  game->insertItem(locale->translate("&Exit"), qApp, SLOT(quit()), CTRL+Key_X);
  // game modes sorted by supposed difficulty
  QPopupMenu *mode1 = new QPopupMenu();
  mIDs.modes[0] = mode1->insertItem(*icons[0], locale->translate("&Tiny"),
    this, SLOT(setModeCl3()));
  mIDs.modes[1] = mode1->insertItem(*icons[1], locale->translate("&Normal"),
    this, SLOT(setModeCl4()));
  mIDs.modes[2] = mode1->insertItem(*icons[2], locale->translate("&Large"),
    this, SLOT(setModeCl5()));
  mIDs.modes[3] = mode1->insertItem(*icons[3], locale->translate("&Giant"),
    this, SLOT(setModeCl6()));
  mode1->setCheckable(TRUE);
  QPopupMenu *mode2 = new QPopupMenu();
  mIDs.modes[5] = mode2->insertItem(*icons[6], locale->translate("&Cross"),
    this, SLOT(setModeCr()));
  mIDs.modes[4] = mode2->insertItem(*icons[5], locale->translate("C&orners"),
    this, SLOT(setModeCo()));
  mIDs.modes[6] = mode2->insertItem(*icons[4], locale->translate("&Diamond"),
    this, SLOT(setModeDi()));
  mIDs.modes[8] = mode2->insertItem(*icons[8], locale->translate("&Triangle"),
    this, SLOT(setModeTr()));
  mIDs.modes[7] = mode2->insertItem(*icons[7], locale->translate("&Isles"),
    this, SLOT(setModeIs()));
  mode2->setCheckable(TRUE);
  for (int i = 0; i < 9; i++)
    delete icons[i];
  QPopupMenu *prefs = new QPopupMenu();
  mIDs.mode1 = prefs->insertItem(locale->translate("&Classical Game"), mode1);
  mIDs.mode2 = prefs->insertItem(locale->translate("&Tricky Game"), mode2);
  mIDs.loadImg = prefs->insertItem(locale->translate("&Load image..."), this,
    SLOT(loadImage()));
  mIDs.defImg = prefs->insertItem(locale->translate("&Default image"), this,
    SLOT(defaultImage()));
  prefs->insertSeparator();
  mIDs.mTile = prefs->insertItem(locale->translate("&Random missing tile"),
    this, SLOT(toggleMissingTile()));
  mIDs.sound = prefs->insertItem(locale->translate("&Sound"), this,
    SLOT(toggleSound()));
  prefs->setCheckable(TRUE);
  prefs->setItemChecked(mIDs.mTile, puzzle->randomMissingTile());
  prefs->setItemChecked(mIDs.sound, puzzle->soundOn());
  if (!puzzle->soundOn())            // find out whether sound can be turned on
    if (!puzzle->toggleSound()) {
      prefs->setItemEnabled(mIDs.sound, FALSE);         // disable sound option
      cerr << locale->translate("Sound initialization failed, sound disabled.")
        << endl;
    } else
      puzzle->toggleSound();
  QPopupMenu *help = new QPopupMenu();
  help->insertItem(locale->translate("&Help..."), this, SLOT(help()), Key_F1);
  help->insertSeparator();
  help->insertItem(locale->translate("&About..."), this, SLOT(about()), 0);
  mBar = new KMenuBar(this, "mBar");
  mBar->insertItem(locale->translate("&Game"), game);
  mBar->insertItem(locale->translate("&Settings"), prefs);
  mBar->insertItem(locale->translate("&Help"), help);
  mIDs.mGame = game;
  mIDs.mPrefs = prefs;
  mBar->show();
  connect(puzzle, SIGNAL(sigStartedScrambling()), this,
    SLOT(scramblingStarted()));
  connect(puzzle, SIGNAL(sigStoppedScrambling()), this,
    SLOT(scramblingStopped()));
  connect(puzzle, SIGNAL(sigStartedOrdering()), this,
    SLOT(orderingStarted()));
  connect(puzzle, SIGNAL(sigStoppedOrdering()), this,
    SLOT(orderingStopped()));
  connect(puzzle, SIGNAL(sigPuzzleSolved()), this, SLOT(orderingStopped()));
  setMenu(mBar);
  setModeCl4();
  puzzle->show();
}

KSlideApp::~KSlideApp()
{
  delete puzzle;
  delete mBar;
}

void KSlideApp::setMode(unsigned char mode)
{
  if (!puzzle->loadImage(tOpt(mode)))
    return;
  for (int i = 0; i < 9; i++)
    mBar->setItemChecked(mIDs.modes[i], FALSE);
  mBar->setItemChecked(mIDs.modes[mode], TRUE);
}

void KSlideApp::setModeCl3() { setMode(0); };
void KSlideApp::setModeCl4() { setMode(1); };
void KSlideApp::setModeCl5() { setMode(2); };
void KSlideApp::setModeCl6() { setMode(3); };
void KSlideApp::setModeCo()  { setMode(4); };
void KSlideApp::setModeCr()  { setMode(5); };
void KSlideApp::setModeDi()  { setMode(6); };
void KSlideApp::setModeIs()  { setMode(7); };
void KSlideApp::setModeTr()  { setMode(8); };

void KSlideApp::scramblingStarted()
{
  mBar->setItemEnabled(mIDs.order, FALSE);
  enableModeChange(FALSE);
  mIDs.mGame->changeItem(locale->translate("&Stop scrambling"), mIDs.scramble);
}

void KSlideApp::scramblingStopped()
{
  mBar->setItemEnabled(mIDs.order, TRUE);
  enableModeChange(TRUE);
  mIDs.mGame->changeItem(locale->translate("&Scramble"), mIDs.scramble);
}

void KSlideApp::orderingStarted()
{
  mBar->setItemEnabled(mIDs.scramble, FALSE);
  mBar->setItemEnabled(mIDs.order, FALSE);
  enableModeChange(FALSE);
}

void KSlideApp::orderingStopped()
{
  mBar->setItemEnabled(mIDs.scramble, TRUE);
  mBar->setItemEnabled(mIDs.order, FALSE);
  enableModeChange(TRUE);
}

void KSlideApp::toggleSound()
{
  mBar->setItemChecked(mIDs.sound, puzzle->toggleSound());
}

void KSlideApp::toggleMissingTile()
{
  mBar->setItemChecked(mIDs.mTile, puzzle->toggleRandomMissingTile());
}

void KSlideApp::help()
{
  kapp->invokeHTMLHelp("", "");
}

void KSlideApp::about()
{
  KMsgBox::message(this, QString(locale->translate("About ")) +
      appName + "...",
    QString(appName) + " v" + appVersion + " (" + appDate + ")\n\n" +
    locale->translate("Copyright (C) 1998 by Marco G\"otze,\n"
      "distributed under the terms of the GPL2.\n\n"
      "Send bug reports, comments, donations, or\n"
      "flames to <gomar@mindless.com>."), KMsgBox::INFORMATION, "&OK");
}

void KSlideApp::enableModeChange(const bool enable)
{
  for (int i = 0; i < 9; i++)
    mBar->setItemEnabled(mIDs.modes[i], enable);
  mIDs.mPrefs->setItemEnabled(mIDs.mode1, enable);
  mIDs.mPrefs->setItemEnabled(mIDs.mode2, enable);
  mBar->setItemEnabled(mIDs.loadImg, enable);
  mBar->setItemEnabled(mIDs.defImg, enable);
}

void KSlideApp::defaultImage()
{
  if (!puzzle->isIdle())
    return;
  puzzle->loadImage(moKeepMode | moLoadDefImage);
}

void KSlideApp::loadImage()
{
  if (!puzzle->isIdle())
    return;
  QString s = QFileDialog::getOpenFileName(0, "*.gif", this,
    locale->translate("Load Image..."));
  if (!s.length())
    return;
  if (!puzzle->loadImage(moKeepMode, s.data()))
    KMsgBox::message(this, locale->translate("Oops..."), locale->translate(
      "An error occurred while trying to load the image.\n"
      "Please check whether the image is of a valid type\n"
      "and has a suitable size. See the help for more\n"
      "information on this."), KMsgBox::EXCLAMATION, "&OK");
}

