/*
 * pack.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 */

#include "rogue.h"
#include "dun.h"

char *curse_message = _T("you can't, it appears to be cursed");
extern short levitate;

object *
add_to_pack(obj, pack, condense)
object *obj, *pack;
{
	object *op;

	if (condense) {
		if (op = check_duplicate(obj, pack)) {
			free_object(obj);
			return(op);
		} else {
			obj->ichar = next_avail_ichar();
		}
	}
	if (pack->next_object == 0) {
		pack->next_object = obj;
		obj->next_object = 0;
	} else {
		short w;
		op = pack;

		while (op->next_object && 
		    ((w = op->next_object->what_is) == FOOD ? 0 : w) <= 
		    ((w = obj->what_is) == FOOD ? 0 : w)) {
			op = op->next_object;
		}
		obj->next_object = op->next_object;
		op->next_object = obj;
	}
	return(obj);
}

take_from_pack(obj, pack)
object *obj, *pack;
{
	while (pack->next_object != obj) {
		pack = pack->next_object;
	}
	pack->next_object = pack->next_object->next_object;
}

object *
pick_up(row, col, status)
short *status;
{
	object *obj;

	obj = object_at(&level_objects, row, col);
	*status = 1;

	if (levitate)
	{
		message(_i18n("you're floating in the air!"));
		return(0);
	}

	if ((obj->what_is == SCROLL) && (obj->which_kind == SCARE_MONSTER) &&
		obj->picked_up) {
		message(_i18n("the scroll turns to dust as you pick it up"), 0);
		dungeon[row][col] &= (~OBJECT);
		vanish(obj, 0, &level_objects);
		*status = 0;
		if (id_scrolls[SCARE_MONSTER].id_status == UNIDENTIFIED) {
			id_scrolls[SCARE_MONSTER].id_status = IDENTIFIED;
		}
		return(0);
	}
	if (obj->what_is == GOLD) {
		rogue.gold += obj->quantity;
		dungeon[row][col] &= ~(OBJECT);
		take_from_pack(obj, &level_objects);
		print_stats(STAT_GOLD);
		return(obj);	/* obj will be free_object()ed in one_move_rogue() */
	}
	if (pack_count(obj) >= MAX_PACK_COUNT) {
		message(_i18n("pack too full"), 1);
		return(0);
	}
	dungeon[row][col] &= ~(OBJECT);
	take_from_pack(obj, &level_objects);
	obj = add_to_pack(obj, &rogue.pack, 1);
	obj->picked_up = 1;
	return(obj);
}

drop()
{
	object *obj, *new;
	short ch;
	char msg[MSGLEN], desc[MSGLEN];

	if (dungeon[rogue.row][rogue.col] & (OBJECT | STAIRS | TRAP)) {
		message(_i18n("there's already something there"), 0);
		return;
	}
	ch=item; 
	obj=item_o;
	if (obj->in_use_flags & BEING_WIELDED) {
		if (obj->is_cursed) {
			message(transl(curse_message), 0);
			return;
		}
		unwield(rogue.weapon);
	} else if (obj->in_use_flags & BEING_WORN) {
		if (obj->is_cursed) {
			message(transl(curse_message), 0);
			return;
		}
		mv_aquatars();
		unwear(rogue.armor);
		print_stats(STAT_ARMOR);
	} else if (obj->in_use_flags & ON_EITHER_HAND) {
		if (obj->is_cursed) {
			message(transl(curse_message), 0);
			return;
		}
		un_put_on(obj);
	}
	obj->row = rogue.row;
	obj->col = rogue.col;

	if ((obj->quantity > 1) && (obj->what_is != WEAPON)) {
		obj->quantity--;
		new = alloc_object();
		*new = *obj;
		new->quantity = 1;
		obj = new;
	} else {
		obj->ichar = 'L';
		take_from_pack(obj, &rogue.pack);
	}
	place_at(obj, rogue.row, rogue.col);
	(void) strcpy(msg, _i18n("dropped "));
	get_desc(obj, desc);
	APPEND(msg, desc, MSGLEN);
	message(msg, 0);
	(void) reg_move();
}

object *
check_duplicate(obj, pack)
object *obj, *pack;
{
	object *op;

	if (!(obj->what_is & (WEAPON | FOOD | SCROLL | POTION))) {
		return(0);
	}
	if ((obj->what_is == FOOD) && (obj->which_kind == FRUIT)) {
		return(0);
	}
	op = pack->next_object;

	while (op) {
		if ((op->what_is == obj->what_is) && 
			(op->which_kind == obj->which_kind)) {

			if ((obj->what_is != WEAPON) ||
			((obj->what_is == WEAPON) &&
			((obj->which_kind == ARROW) ||
			(obj->which_kind == DAGGER) ||
			(obj->which_kind == DART) ||
			(obj->which_kind == SHURIKEN)) &&
			(obj->quiver == op->quiver))) {
				op->quantity += obj->quantity;
				return(op);
			}
		}
		op = op->next_object;
	}
	return(0);
}

next_avail_ichar()
{
	register object *obj;
	register i;
	boolean ichars[26];

	for (i = 0; i < 26; i++) {
		ichars[i] = 0;
	}
	obj = rogue.pack.next_object;
	while (obj) {
		ichars[(obj->ichar - 'a')] = 1;
		obj = obj->next_object;
	}
	for (i = 0; i < 26; i++) {
		if (!ichars[i]) {
			return(i + 'a');
		}
	}
	return('?');
}

take_off()
{
	char msg[MSGLEN], desc[MSGLEN];
	object *obj;

	if (rogue.armor) {
		if (rogue.armor->is_cursed) {
			message(transl(curse_message), 0);
		} else {
			mv_aquatars();
			obj = rogue.armor;
			unwear(rogue.armor);
			(void) strcpy(msg, _i18n("was wearing "));
			get_desc(obj, desc);
			APPEND(msg, desc, MSGLEN);
			message(msg, 0);
			print_stats(STAT_ARMOR);
			(void) reg_move();
		}
	} else {
		message(_i18n("not wearing any"), 0);
	}
}

wear()
{
	short ch;
	register object *obj;
	char msg[MSGLEN], desc[MSGLEN];

	if (rogue.armor) {
		message(_i18n("your already wearing some"), 0);
		return;
	}
	ch = item;
	obj=item_o;
	obj->identified = 1;
	(void) strcpy(msg, _i18n("wearing "));
	get_desc(obj, desc);
	APPEND(msg, desc, MSGLEN);
	message(msg, 0);
	do_wear(obj);
	print_stats(STAT_ARMOR);
	(void) reg_move();	
}

unwear(obj)
object *obj;
{
	if (obj) {
		obj->in_use_flags &= (~BEING_WORN);
	}
	rogue.armor = (object *) 0;	
}

do_wear(obj)
object *obj;
{
	rogue.armor = obj;
	obj->in_use_flags |= BEING_WORN;
	obj->identified = 1;
}

wield()
{
	short ch;
	register object *obj;
	char msg[MSGLEN], desc[MSGLEN];

	if (rogue.weapon && rogue.weapon->is_cursed) {
		message(transl(curse_message), 0);
		return;
	}
	ch=item;
	obj=item_o;
	if (obj->in_use_flags & BEING_WIELDED) {
		message(_i18n("in use"), 0);
	} else {
		unwield(rogue.weapon);
		(void) strcpy(msg, _i18n("wielding "));
		get_desc(obj, desc);
		APPEND(msg, desc, MSGLEN);
		message(msg, 0);
		do_wield(obj);
		(void) reg_move();
	}
}

do_wield(obj)
object *obj;
{
	rogue.weapon = obj;
	obj->in_use_flags |= BEING_WIELDED;
}

unwield(obj)
object *obj;
{
	if (obj) {
		obj->in_use_flags &= (~BEING_WIELDED);
	}
	rogue.weapon = (object *) 0;
}

call_it(ch, name)
int ch;
char *name;
{
	register object *obj;
	struct id *id_table;
	
	if (!(obj = get_letter_object(ch))) {
		message(_i18n("no such item."), 0);
		return;
	}
	if (!(obj->what_is & (SCROLL | POTION | WAND | RING))) {
		message(_i18n("surely you already know what that's called"), 0);
		return;
	}
	id_table = get_id_table(obj);

	id_table[obj->which_kind].id_status = CALLED;
	(void) strcpy(id_table[obj->which_kind].title, name);
}

pack_count(new_obj)
object *new_obj;
{
	object *obj;
	short count = 0;

	obj = rogue.pack.next_object;

	while (obj) {
		if (obj->what_is != WEAPON) {
			count += obj->quantity;
		} else if (!new_obj) {
			count++;
		} else if ((new_obj->what_is != WEAPON) ||
			((obj->which_kind != ARROW) &&
			(obj->which_kind != DAGGER) &&
			(obj->which_kind != DART) &&
			(obj->which_kind != SHURIKEN)) ||
			(new_obj->which_kind != obj->which_kind) ||
			(obj->quiver != new_obj->quiver)) {
			count++;
		}
		obj = obj->next_object;
	}
	return(count);
}

boolean
mask_pack(pack, mask)
object *pack;
unsigned short mask;
{
	while (pack->next_object) {
		pack = pack->next_object;
		if (pack->what_is & mask) {
			return(1);
		}
	}
	return(0);
}

is_pack_letter(c, mask)
short *c;
unsigned short *mask;
{
	if (((*c == '?') || (*c == '!') || (*c == ':') || (*c == '=') ||
		(*c == ')') || (*c == ']') || (*c == '/') || (*c == ','))) {
		switch(*c) {
		case '?':
			*mask = SCROLL;
			break;
		case '!':
			*mask = POTION;
			break;
		case ':':
			*mask = FOOD;
			break;
		case ')':
			*mask = WEAPON;
			break;
		case ']':
			*mask = ARMOR;
			break;
		case '/':
			*mask = WAND;
			break;
		case '=':
			*mask = RING;
			break;
		case ',':
			*mask = AMULET;
			break;
		}
		*c = LIST;
		return(1);
	}
	return(((*c >= 'a') && (*c <= 'z')) || (*c == CANCEL) || (*c == LIST));
}

has_amulet()
{
	return(mask_pack(&rogue.pack, AMULET));
}

kick_into_pack()
{
    object *obj;
    char desc[MSGLEN+3];
    short n, stat;

    if (!(dungeon[rogue.row][rogue.col] & OBJECT)) {
        message(_i18n("nothing here"), 0);
    } else {
        if (obj = pick_up(rogue.row, rogue.col, &stat)) {
            get_desc(obj, desc);
            if (obj->what_is == GOLD) {
                message(desc, 0);
                free_object(obj);
            } else {
                n = strlen(desc);
                desc[n] = '(';
                desc[n+1] = obj->ichar;
                desc[n+2] = ')';
                desc[n+3] = 0;
                message(desc, 0);
            }
        }
        if (obj || (!stat)) {
            (void) reg_move();
        }
    }
}

