#ifndef KROGUE_H
#define KROGUE_H
#include <ktopwidget.h>
#include <kapp.h>

class KInvPopup;
class KToolBar;

class KRogueWnd:public KTopLevelWidget
{
  Q_OBJECT
public:
  KRogueWnd(void);
  virtual void initToolBar();
  virtual void initMenuBar();
  virtual void initStatusBar();
  virtual void initMsgBar();
  virtual void initGame();
  virtual void show();
  virtual void writeCfg();
  char *statusStr(int id, char *str);
  void printStats(int i);
  KToolBar *tl;
  KMenuBar *mb;
  KStatusBar *s;
  bool initFailed;
  int restoresg;
public slots:
  virtual void options();
  virtual void takeoffbt();
  virtual void wearbt();
  virtual void lputbt();
  virtual void lrembt(struct obj *);
  virtual void rputbt();
  virtual void rrembt(struct obj *);
  virtual void stairbt(bool);
  virtual void setRunning(bool);
  virtual void newTitle();
  virtual void wizard();
  virtual void enableButtons(bool enable);
  virtual void help();
  virtual void kdeHomepage();
  virtual void krHomepage();
protected:
  virtual void closeEvent(QCloseEvent *e);
  virtual void writeMenuBar(KMenuBar *, const char *);
  virtual void writeToolBar(KToolBar *, const char *);
  virtual void readMenuBar(KMenuBar *, const char *);
  virtual void readToolBar(KToolBar *, const char *);
  virtual void saveProperties(KConfig *);
  virtual void readProperties(KConfig *);
  KInvPopup *wear, *lrings, *rrings;
  int enab[20];
  int tlButtons;
};

extern KApplication *app;
extern KRogueWnd *top;
extern KLocale *loc;
extern KConfig *cfg;
extern int saved_uid, true_uid;

extern "C" {
void print_stats(int);
}
#endif