#ifndef _INTPUIS_H_
#define _INTPUIS_H_

#include <qstack.h>
#include <qstring.h>
#include <qarray.h>
#include "strategie.h"

class InternalPuissance
{
public:
	InternalPuissance(int ncol, int nrow, int npuis);

	void init();
	int humanPlay(int player, int col);
	int computerPlay(int player, int level, int& col);
	int check(int player);
	int undo();
	int numCols() { return NumCols;}
	int numRows() { return NumRows;}
	int numPuis() { return NumPuis;}
	int state(int r, int c) { return Table[r][c];}
	int player() { return Player;}
	QArray<int> winner() { return Winner;}

	void save(const char *filename);
	void load(const char *filename);

protected:
	QStack<int>	Stack;
	int		NumCols, NumRows, NumPuis;
	int		Table[20][20];
	strategie	Strat;
	int		Player;
	QArray<int>	Winner;
};

#endif