#include <fstream.h>
#include "intpuis.h"

InternalPuissance::InternalPuissance(int ncol, int nrow, int npuis)
	: NumCols(ncol), NumRows(nrow), NumPuis(npuis)
{
	Stack.setAutoDelete(true);
	init();
}

void InternalPuissance::init()
{
	Stack.clear();
	Winner.resize(NumPuis);
	for (int i=0;i<NumRows;i++)
	   for (int j=0;j<NumCols;j++)
		Table[i][j] = 0;
}

void InternalPuissance::resize(int nc, int nr)
{
	NumCols = nc;
	NumRows = nr;
	init();
}

void InternalPuissance::setPuissance(int np)
{
	NumPuis = np;
	Winner.resize(NumPuis);
}

int InternalPuissance::humanPlay(int player, int col)
{
	int case_number;
	int index = NumRows-1;
	if(Table[0][col] != 0) return -1;
	else {
		while (Table[index][col] != 0) index--;
		Table[index][col] = player;
	}
	case_number = index*NumCols + col;
	Stack.push(new int(col));
	return case_number;
}

int InternalPuissance::computerPlay(int player, int level, int& col)
{
	int profondeur;
	int k = 0;
	for (int i = 0;i < NumCols;i++)
		if (Table[0][i] != 0) k = k + 2;
	profondeur = 5 + k;
	if (Stack.count() < 2) {
		col = NumCols / 2;
		Stack.push(new int(col));
	}
	else {
		if (level == 0) col = Strat.hazard(Table,NumRows,NumCols);
		else if (level == 1) col = Strat.run(Table,player,1,NumRows,NumCols);
		else col = Strat.run(Table,player,profondeur,NumRows,NumCols);
		Stack.push(new int(col));
	}
	int index = NumRows-1;
	bool b =true;
	if(Table[0][col] != 0)
		return -1;
	else {
		while (b==true) {
			if(index < 0) {
				if (level == 0) col = Strat.hazard(Table,NumRows,NumCols);
				else if (level == 1) col = Strat.run(Table,player,1,NumRows,NumCols);
				else col = Strat.run(Table,player,profondeur,NumRows,NumCols);
				Stack.push(new int(col));
			}
			else {
				if(Table[index][col] == 0) {
					Table[index][col] = player;
					b = false;
				}
				else index--;
			}
		}
		return index*NumCols + col;
	}
}

int InternalPuissance::check(int player)
{
	int a =0;

	// Verification Horizontale
	for (int i=0;i<NumRows;i++) {
	   for (int j=0;j<NumCols;j++) {
		if (Table[i][j] == player) {
			Winner[a] = i*NumCols+j;
			a++;
			if (a == NumPuis) return player;
		}
		else a=0;
	   }
	   a=0;
	}

	// Verification verticale
	for(int i=0;i<NumCols;i++) {
	   for(int j=0;j<NumRows;j++) {
		if (Table[j][i] == player) {
			Winner[a] = j*NumCols+i;
			a++;
			if(a == NumPuis) return player;
		}
		else a=0;
	   }
	   a=0;
	}

	// Verification diagonale
	int e,f;
	for (int i=0;i<(NumRows-(NumPuis-1));i++) {
	   for (int j=0;j<(NumCols-(NumPuis-1));j++) {
		e = i;
		f = j;
		for (int k=0;k<NumPuis;k++) {
			if (Table[e][f] == player) {
				Winner[a] = e*NumCols+f;
				a++;
				e++;
				f++;
			}
			else {
				a = 0;
				k = NumPuis;
			}
		}
		if (a == NumPuis) return player;
	   }
	}
	int q,s;
	for (int i=0;i<(NumRows-(NumPuis-1));i++) {
	   for (int j=(NumPuis-1);j<NumCols;j++) {
		q = i;
		s = j;
		for (int k=0;k<NumPuis;k++) {
			if (Table[q][s] == player) {
				Winner[a] = q*NumCols+s;
				a++;
				q++;
				s--;
			}
			else {
				a = 0;
				k = NumPuis;
			}
		}
		if (a == NumPuis) return player;
	   }
	}
	return 0;
}

void InternalPuissance::save(const char *filename)
{
	ofstream	fd;
	fd.open(filename,666);
	fd << NumCols << endl << NumRows << endl << NumPuis << endl;
	while (!Stack.isEmpty()) {
		int	*a = Stack.pop();
		fd << *a << endl;
		delete a;
	}
	fd.close();
}

void InternalPuissance::load(const char *filename)
{
	QStack<int>	pile;
	pile.setAutoDelete(true);
	ifstream	fd;
	fd.open(filename);
	int	nc, nl, np;
	fd >> nc >> nl >> np;
	NumRows = nl;
	NumCols = nc;
	NumPuis = np;
	bool	done(false);
	int	q;
	while (!done) {
		fd >> q;
		if (fd.eof() != 0) done = true;
		else pile.push(new int(q));
	}
	fd.close();

	Player = 0;
	int	*a;
	init();
	while (!pile.isEmpty()) {
		a = pile.pop();
		humanPlay(Player+1,*a);
		Player = 1-Player;
		delete a;
	}
}

int InternalPuissance::undo()
{
	if (!Stack.isEmpty()) {
		int	*a = Stack.pop();
		int	index = NumRows-1;
		int	case_number;
		while (index >= 0 && Table[index][*a] != 0) index--;
		if (index < 0) return (-1);
		index++;
		Table[index][*a] = 0;
		case_number = index*NumCols+(*a);
		delete a;
		return case_number;
	}
	else return (-1);
}
