#include "serveroptions.h"
#include <kapp.h>
#include <kiconloader.h>
#include <kfiledialog.h>

ServerOptions::ServerOptions(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	NumColsLabel = new QLabel(i18n("Columns"),this);
	NumRowsLabel = new QLabel(i18n("Rows"),this);
	NumPuisLabel = new QLabel(i18n("Puissance"),this);
	ServerProgramLabel = new QLabel(i18n("Server program"),this);
	HostLabel = new QLabel(i18n("Host"),this);
	PortLabel = new QLabel(i18n("Port"),this);

	NumCols = new QLineEdit(this);
	NumRows = new QLineEdit(this);
	NumPuis = new QLineEdit(this);
	ServerProgram = new QLineEdit(this);
	Host = new QLineEdit(this);
	Port = new QLineEdit(this);
	ServerProgramButton = new QPushButton(this);
	ServerProgramButton->setPixmap(kapp->getIconLoader()->loadIcon("fileopen.xpm"));
	LocalMode = new QCheckBox(i18n("Local mode"),this);
	SocketName = new QLineEdit(this);
	connect(ServerProgramButton,SIGNAL(clicked()),SLOT(buttonPressed()));
}

ServerOptions::~ServerOptions()
{
}

void ServerOptions::resizeEvent(QResizeEvent *e)
{
	int	size = (width()-4*10)/3;
	int	space = (height()-7*25)/5;
	NumColsLabel->setGeometry(10,space,size,25);
	NumRowsLabel->setGeometry(20+size,space,size,25);
	NumPuisLabel->setGeometry(30+2*size,space,size,25);
	NumCols->setGeometry(10,space+25,size,25);
	NumRows->setGeometry(20+size,space+25,size,25);
	NumPuis->setGeometry(30+2*size,space+25,size,25);
	size = width()-30-25;
	ServerProgramLabel->setGeometry(10,2*space+50,size,25);
	ServerProgram->setGeometry(10,2*space+75,size,25);
	ServerProgramButton->setGeometry(20+size,2*space+75,25,25);
	size = (width()-3*10)*3/4;
	HostLabel->setGeometry(10,3*space+100,size,25);
	PortLabel->setGeometry(20+size,3*space+100,size/3,25);
	Host->setGeometry(10,3*space+125,size,25);
	Port->setGeometry(20+size,3*space+125,size/3,25);
	size = (width()-30)/2;
	LocalMode->setGeometry(10,4*space+150,size,25);
	SocketName->setGeometry(20+size,4*space+150,size,25);
}

void ServerOptions::buttonPressed()
{
	QString		filename = KFileDialog::getOpenFileName(0,0,this,0);
	if (!filename.isNull()) ServerProgram->setText(filename.data());
}
