#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <kapp.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <kpopmenu.h>
#include <qframe.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlcdnumber.h>
#include <qdatetime.h>
#include <qcolor.h>
#include <qbitmap.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qdatetime.h>
#include <qdialog.h>
#include <qlistbox.h>
#include <stdlib.h>

#include "feldWidget.h"
#include "feldDaten.h"
#include "spielerWidget.h"
#include "spieler.h"
#include "feld.h"

class MyMainWidget : public KTopLevelWidget {
  Q_OBJECT
  public:
    MyMainWidget (const char *name = 0);
    
  public slots:
    void spielen ( spielerReturn );
    void aleaJactaEst (); 
    void wuerfelRollen ();
    void feldKaufen ();
    void feldBebauen ();
    void weiterGehts ();
    void quitProg ();
    void bauenPressed ();
    void bauenHighlighted (int Nr);

  private:
  
    void drawPosition (QString spieler, int feldNr);
    void movePosition (QString spieler, int schritte);
    int  bexec ();
    
    KMenuBar*           menuBar;
    KPopupMenu*         fileMenu;
    FeldWidget*		feldWidget[41];
    SpielerWidget*	spielerWidget;
    QLabel*		tL;
    QLabel*		spielerName[5];
    QLabel*		geld[5];
    QLabel*		info;
    QLabel*		sp[5][41];
    QLabel*             lhaus[6][41];
    QFrame*		wFrame;
    QPushButton*	kaufen;
    QPushButton*        wuerfeln;
    QPushButton*        weiter;
    QPushButton*	bauen;
    QLCDNumber*         wLCD1;
    QLCDNumber*         wLCD2;
    QBitmap		figur;
    QBitmap		bhaus;
    QBitmap		bhotel;
    QPixmap		phaus;
    QPixmap             photel;
    QPixmap		pfigur;
    QTime               zeit;
    QDialog*		bDialog;
    QColor		f;
    Spieler*		mySpieler;
    Feld*		myFeld;
    int			i, j, k, l, m, di, dii, wuerfel1, wuerfel2;
    int			aktFeld;
    int			aktSpielerNummer;
    int                 tAktSpielerNummer;
    QString		aktSpieler;
    QString             tString;
    bool		fertig;
};    
#endif