/***************************************************************************
                          dlgmapinfo.cpp  -  description
                             -------------------
    begin                : Fri Sep 22 2000
    copyright            : (C) 2000 by John-Paul Stanford
    email                : john-paul.stanford@virgin.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgmapinfo.h"

DlgMapInfo::DlgMapInfo(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
	
	setCaption("Mapper Information");
	
	connect( cmdClose, SIGNAL(clicked()), SLOT(accept()) );

}

DlgMapInfo::~DlgMapInfo()
{
}

void DlgMapInfo::setStart(int x,int y, int lvl)
{
	QString xpos,ypos,lpos;
	
	xpos.setNum(x);
	ypos.setNum(y);
	lpos.setNum(lvl);
	
	txtX->setText(xpos);
	txtY->setText(ypos);
	txtLvl->setText(lpos);
	
}

void DlgMapInfo::setGeneral(QString mud,QString chr)
{
	txtMud->setText(mud);
	txtChar->setText(chr);
}

void DlgMapInfo::setTotals(int level,int room,int text,int path)
{
	QString l,r,t,p;
	
	l.setNum(level);
	r.setNum(room);
	t.setNum(text);
	p.setNum(path);
	txtLvls->setText(l);
	txtRooms->setText(r);
	txtText->setText(t);
	txtPaths->setText(p);
}


