/***************************************************************************
                          cmudprofile.h
                      -------------------
    description          : Mud Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMUDPROFILE_H
#define CMUDPROFILE_H

#include <qstring.h>
#include <qdir.h>
#include <ksimpleconfig.h>

struct directions
{
	QString north;
	QString northeast;
	QString east;
	QString southeast;
	QString south;
	QString southwest;
	QString west;
	QString northwest;
	QString up;
	QString down;
};

/**
  * Mud Profile Class
  *@author Stephan Uhlmann
  */

class CMudProfile {
public:
	/** constructor */
	CMudProfile();
	/** destructor */
	~CMudProfile();

	/** returns the filename where the data are stored */
	QString getFileName();
	/** sets the filename where the data are stored */
	void setFileName(QString);

	/** returns the title */
	QString getTitle();
	/** sets the title */
	void setTitle(QString);

	/** returns the hostname */
	QString getHostName();
	/** sets the hostname */
	void setHostName(QString);

	/** returns the port */
	unsigned int getPort();
	/** sets the port */
	void setPort(unsigned int p);
	
	/** returns the NamePrompt */
	QString getNamePrompt();
	/** sets the NamePrompt */
	void setNamePrompt(QString);
	
	/** returns the PasswordPrompt */
	QString getPasswordPrompt();
	/** sets the PasswordPrompt */
	void setPasswordPrompt(QString);

	/** returns the directions */
	directions *getDirections();		
	/** sets the directions */
	void setDirections(directions *d);

	/** reads the data of the class from its file */
	void readData();
	/** writes the data to the class to its file */
	void writeData();

	/** returns iType (the interpretation type) */
	int getInterpretationType();
	/** sets the interpretation type */
	void setInterpretationType(int i);
	/** Activate create mode for mapper */
	void setCreateMode(bool create);
	/** Activate follow mode for mapper */
	void setFollowMode(bool create);
	/** get create mode on/off state for the mapper */
	bool getCreateMode(void);
	/** get follow mode on/off state for the mapper */
	bool getFollowMode(void);
	/** Get the string used to detect when a character can't move */
	QString getNoMoveStr(void);
	/** Set the string used to detect when a character can't move */
	void setNoMoveStr(QString str);
	/** Set the string used to detect a valid room */
	QString getCanMoveStr(void);
	/** Store if the valid move check is to be done */
	bool getDoMoveCheck(void);
	/** Set the valid room sting */
	void setCanMoveStr(QString str);
	/** Set if the valid room check should be done */
	void setDoMoveCheck(bool set);

private:
	bool doMove;
	QString canMove;
	QString noMove;
	QString filename;
	QString title;
	QString hostname;
	unsigned int port;
	QString nameprompt;
	QString passwordprompt;
	directions *map_directions;
	bool bFollowMode,bCreateMode;
	/** The interpretation type */
	int iType;

};

#endif
