/***************************************************************************
                          kinsectizid.h  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KINSECTIZID_H
#define KINSECTIZID_H

#include <kapp.h>

#include <qwidget.h>
#include <qpalette.h>
#include <qlabel.h>
#include <qcursor.h>
#include <qlcdnumber.h>
#include <qkeycode.h>
#include <qmessagebox.h>
#include <qtimer.h>

#include "gamefield.h"
#include "bulletwidg.h"
#include "gametimer.h"
#include "hiscoredialog.h"

class KInsectizid : public QWidget
{
  Q_OBJECT 
  public:
    /** construtor */
    KInsectizid(QWidget* parent=0, const char *name=0, WFlags f=0);
    /** destructor */
    ~KInsectizid();

	void mouseMoveEvent( QMouseEvent *);
	void keyPressEvent(QKeyEvent *);
	GameField *gamefield;
	
	bool sound;

private:
	BulletWidg *bulletWidg;
	GameTimer *gameTimer;
	HiScoreDialog *hiScoreDialog;

	QWidget *countWidg;
	QwSpriteFieldView *hiView;
	QwSpriteField *hiField;
	QwTextSprite *hiscore, *hiNames[16], *hiScores[16];
	QLCDNumber *hitLcd, *missLcd, *timerLcd, *pointLcd, *levLcd;
	QTimer *timer, *blTimer;
	void initGameField(int);
	void removeGameField();
	void chiefHide(bool);
	void newHiScore(int);
	void closeEvent(QCloseEvent *);
	void timerEvent(QTimerEvent *);

	int hits, miss, level, points, MUST_HITS, hiY;
	bool paused, gameover, hiShow, blocked;

private slots:
	void addPoint(bool hit);
	void addMagPoint(bool hit);
	void addTuxPoint(bool hit);
	void reloadGun();
	void displayTime(QString);
	void timeOut();
	void startGame();
	void showHiscores();
	void unblockIt();
	void saveNewHi(QString);

signals:
	void status(int);
};

#endif