/***************************************************************************
                          hiscoredialog.cpp  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "hiscoredialog.h"

const char *keyS[57] = {
			"A", "B", "C", "D", "E", "F", "G", "H", "I",
			"J", "K", "L", "M", "N", "O", "P", "Q", "R",
			"S", "T", "U", "V", "W", "X", "Y", "Z", "0",
			"1", "2", "3", "4", "5", "6", "7", "8", "9",
			",", ".", "-", "+", "-", "?", "=", ")", "(",
			"/", "&", "%", "$", "", "!", ";", ":", "#",
			"[SPC]", "[<--]"
			};

HiScoreDialog::HiScoreDialog(QWidget *parent, const char *name )
			 : QDialog(parent,name,TRUE)
{
	curSig = 1;
	lnum=1;
	pressedBut = 0;
	cnt = 0;
	cnt2 = 0;
	block = false;

    QColorGroup grp( darkBlue, black, QColor( 0, 255, 0 ),
	    QColor( 64, 64, 64 ), black, green, black );
    QPalette pal( grp, grp, grp );
	
	hiField = new QwSpriteField(600, 400, 16, 100);

	hiView = new MyQwSpriteFieldView(hiField,this,0,0);
	connect(hiView, SIGNAL(fire(int,int)), this, SLOT(checkBut(int,int)));

	hiView->setGeometry(0,0,600,400);
	hiView->setPalette(pal);
	hiView->setBackgroundColor(black);

	QFont fnt ("helvetica", 26, QFont::Bold);
	fnt.setUnderline(true);

	QLabel *lab = new QLabel(i18n("You have reached a new HiScore !!!"), hiView);
	lab->setGeometry(50,10,500,30);
	lab->setAlignment(AlignCenter);
	lab->setBackgroundColor(black);
	lab->setFont(fnt);
	
	QLabel *lab2 = new QLabel(i18n("Please enter your name"), hiView);
	lab2->setGeometry(200,45,200,20);
	lab2->setAlignment(AlignCenter);
	lab2->setBackgroundColor(black);
	lab2->setFont(QFont("helvetica", 14, QFont::Bold));

	fnt.setUnderline(false);
	QPushButton *ok = new QPushButton("OK",hiView);
	ok->setGeometry(550,350,45,45);
	ok->setFont(fnt);
	connect(ok, SIGNAL(clicked()), this, SLOT(submitName()));

	for ( int i=1; i <=10; i++ ) {
		s[i] = new QLabel(hiView);
		s[i]->setGeometry(i*50,320,30,40);
		s[i]->setFrameStyle(QFrame::Panel | QFrame::Raised);
		s[i]->setAlignment(AlignCenter);
		s[i]->setFont(QFont("helvetica", 24, QFont::Bold));
		s[i]->setBackgroundColor(black);
		s[i]->hide();
	}
	s[1]->setBackgroundColor(white);

	setButtons();
}

HiScoreDialog::~HiScoreDialog()
{
}

void HiScoreDialog::setButtons()
{
	int x,y;

	for ( int i=0 ; i <= 56 ; i++) {
		if ( i == 56 ) {
			x = 8;
			y = 270;
		} else if ( i == 55 ) {
			x = 5;
			y = 270;
		} else if ( i > 51  ) {
			x = i-52;
			y = 270;
		} else if ( i > 38 ) {
			x = i-39;
			y = 240;
		} else if ( i > 25 ) {
			x = i-26;
			y = 210;
		} else if ( i > 12 ) {
			x=i-13;
			y = 180;
		} else {
			x = i;
			y = 150;
		}
		butsh[i] = new QwTextSprite(keyS[i], QFont("helvetica",26, QFont::Bold));
		butsh[i]->moveTo( ((x*30)+98), y-2);
		butsh[i]->setColor( darkGray );
		butsh[i]->show();
		but[i] = new QwTextSprite(keyS[i], QFont("helvetica",26, QFont::Bold));
		but[i]->moveTo( ((x*30)+100), y);
		but[i]->setColor( yellow );
		but[i]->show();
	}
	hiField->update();
}

void HiScoreDialog::closeEvent(QCloseEvent *ce)
{
}

void HiScoreDialog::keyPressEvent(QKeyEvent *ke)
{
}

void HiScoreDialog::checkBut(int x, int y)
{
	if ( !block ) {
		for ( int i=0; i <= 56 ; i++ ) {
			if ( i < 54 ) {
			if (( x >= but[i]->x() && x <= but[i]->x()+30 )&&
			   ( y >= but[i]->y() && y <= but[i]->y()+30 ) ) {
			   	pressedBut = i;
			   	oldX = but[i]->x();
			   	oldY = but[i]->y();
			   	startTimer(10);
				// Set the Text
			   	if ( curSig <= 10 ) {
				   	s[curSig]->setText(keyS[i]);
				   	s[curSig]->setBackgroundColor(black);
			   		s[curSig]->show();
 				   	curSig++;
			   	}
			   	if ( curSig < 10 ) {
				   	s[curSig]->setBackgroundColor(white);
			   	}
			   	this->repaint();

			   	break;
			  }
			} else {
			if (( x >= but[i]->x() && x <= but[i]->x()+60 )&&
			   ( y >= but[i]->y() && y <= but[i]->y()+30 ) ) {
			   	pressedBut = i;
			   	oldX = but[i]->x();
			   	oldY = but[i]->y();
			   	startTimer(10);
			   	
			   	if ( i == 55 ) {
			   		if ( curSig <= 10)
				   		s[curSig]->setBackgroundColor(black);
					if ( curSig > 1 )
			   			curSig--;
			   		s[curSig]->setText("");
			   		s[curSig]->setBackgroundColor(white);
			   		s[curSig]->hide();
			   	}
			   	if ( i == 54 ) {
				   	if ( curSig <= 10 ) {
					   	s[curSig]->setText("");
				   		s[curSig]->setBackgroundColor(black);
				   		s[curSig]->show();
 					   	curSig++;
				   	}
				   	if ( curSig < 10 ) {
					   	s[curSig]->setBackgroundColor(white);
				   	}
			   	}
			   	break;
			  }
			}
		}
	}
}

void HiScoreDialog::timerEvent(QTimerEvent *te)
{
	cnt++;
	if ( cnt < 21 ) {
		block=true;
		if ( cnt <= 10 ) {
			butsh[pressedBut]->moveBy(-2,-2);
			but[pressedBut]->moveBy(2,2);
		} else if ( cnt > 10 && cnt < 21 ) {
			butsh[pressedBut]->moveBy(2,2);
			but[pressedBut]->moveBy(-2,-2);
		} else {
			cnt = 0;
		}
	} else {
		killTimers();
		block=false;
		cnt = 0;
		butsh[pressedBut]->moveTo(oldX-2,oldY-2);
		but[pressedBut]->moveTo(oldX,oldY);
	}
	hiField->update();
}

void HiScoreDialog::submitName()
{
	QString name;
	name = "";
	for ( int i=1; i <= curSig; i++) {
		name += s[i]->text();
	}
	emit newName(name);
}