/***************************************************************************
                          bulletwidg.cpp  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          bulletwidg.cpp  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bulletwidg.h"

#define PREFIX kapp->kde_datadir() + "/kinsectizid/"

#define BULLET_IMAGE    "sprites/bullets/bullet-%d.ppm"
#define BULLET_MASK     "sprites/bullets/bullet-%d.pbm"
#define BULLET_FRAMES   24

BulletWidg::BulletWidg(QWidget *parent, const char *name )
		  : QWidget(parent,name)
{
	bulletField = new QwSpriteField(300,50);
	bulletView = new QwSpriteFieldView(bulletField, this);

    bulletImg = new QwSpritePixmapSequence( PREFIX + BULLET_IMAGE, PREFIX + BULLET_MASK, BULLET_FRAMES );
    ready = true;
}

BulletWidg::~BulletWidg()
{
}

void BulletWidg::addBullets( int num )
{
    int i;
    double x;

	Bullet *bullet;

    for ( i = 0; i < num; i++ )
    {
    	x = (( i*25 )+(kapp->desktop()->width() - 500) );
		bullet = new Bullet( bulletImg );
		
		bullet->setBoundsAction( QwRealMobileSprite::Wrap );
		bullet->setVelocity( -1,0 );
		bullet->moveTo( x, 0, 0 );
		bullets.append( bullet );
    }
}

void BulletWidg::timerEvent(QTimerEvent *te)
{
	ready = false;
	killTimers();
    startTimer( 0.5 );

    QwRealMobileSprite *bullet;

    bullet = bullets.first();
	bullet->forward( 5 );
	bullet->frame( ( bullet->frame()+1 ) % BULLET_FRAMES );

	if ( bullet->x() <= 1 ) {
		bullet->hide();
		bullets.removeRef(bullet);
		killTimers();
		ready = true;
	}
	bulletField->update();
}

void BulletWidg::removeBullets( int num )
{
    QwRealMobileSprite *bullet;

    bullet = bullets.first();
//	bullet->forward( 5 );
//	bullet->frame( ( bullet->frame()+1 ) % BULLET_FRAMES );

	bullet->hide();
	bullets.removeRef(bullet);
	bulletField->update();
}