#ifndef KGREDITWIDGET_H 
#define KGREDITWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 


#include <kapp.h>
#include <qevent.h>
#include <qimage.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <kiconloader.h>

#include "kgreditfield.h"

const int FILE_DONT_EXISTS = -1;
const int FILE_NOT_TO_READ = -2;

class kgreditWidget : public QWidget
{
  Q_OBJECT
 public:
  kgreditWidget(QWidget *parent = 0, const char *name = 0);
  virtual ~kgreditWidget();
  void setActiveObject(unsigned char o); // setzt das aktuelle Objekt
  void clearBoard();
  void setchanged(bool);

 public slots:
    void sendPressedStatus(int field);
    void sendActiveObject(int field);
    void sendActivePixmap(int field);
    void setMousePressed(bool pressed);
    void setObject(unsigned char o,int x,int y);
    void load(QFile &);
    void save(QFile &);
    //    void saveAs(QFile &);
 signals:
    void changed();

 private:
  bool mouse_pressed; // ist die Maus gedrckt ?
  unsigned char activeObject; // von kgredit wird das grad gewhlte
                              // Objekt bermittelt.
  bool change;
  QPixmap hero_pix,enemy_pix,nugget_pix,pole_pix;
  QPixmap ladder_pix,hladder_pix,hgbrick_pix;
  QPixmap brick_pix,fbrick_pix,beton_pix;
  QPixmap activePixmap;
  kgreditField *board[28][20]; // das Spielfeld
};

#endif // KGREDITWIDGET_H 
