/* view_2player.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef VIEW_2PLAYER_H
#define VIEW_2PLAYER_H

#include "includes.h"
#include "go_board.h"
#include "go_view.h"
#include "go_player.h"
#include "v2p_player.h"

/**
 * This class simulates 2 players.
 **/
class KView2Player : public KGoView
{
	Q_OBJECT

public:
	KView2Player( KGoBoard *b, QWidget *parent=0,
		const char *name = 0 );
 	~KView2Player();

public slots:
	void resizeEvent( QResizeEvent * ) ;

	void pass() ;
	void generateMove( int, int ) ;

	void receiveMove( int, int, int ) ;
	void receiveIllegalMove( int, int ) ;

	KGoPlayer* getWhitePlayer() ; 
	KGoPlayer* getBlackPlayer() ; 

private slots:
	void info( const char *s ) ;

private:
	int playerToMove() ;

	KV2P_Player *white ;
	KV2P_Player *black ;

	QLabel *inf ;
	QPushButton *passb ;

} ;

#endif
