/* knetobject.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef KNETOBJECT_H
#define KNETOBJECT_H

#include <qobject.h>
#include <qsignal.h>

#include <ksock.h>

#define BUFFER_SIZE 5 
#define MAX_MESSAGE_SIZE 30 

/**
 * This class can be used to make a connection over the Internet.
 * The class enables the user to send and receive simple
 * messages (of type char *, with a maximum size of MAX_MESSAGE_SIZE). 
 *
 */
class KNetObject : public QObject
{
	Q_OBJECT

public:
	KNetObject( KSocket* ) ;
 	~KNetObject();

public slots:
	/**
	 * Send a message. The method returns false if the
	 * message buffer was full.
	 */
	bool sendMessage( char * ); 
	char * getMessage() ;

	/**
	 * @return true if there are messages to be read
	 */
	bool isMessageWaiting() ;

private slots:
	void receiveReadEvent( KSocket* ) ;
	void receiveWriteEvent( KSocket* ) ;
	void receiveCloseEvent( KSocket* ) ;
signals:
	void messageArrived() ;
	void connectionBroken() ;

private:
	bool inBufferFull() ;
	bool outBufferFull() ;

	bool inBufferEmpty() ;
	bool outBufferEmpty() ;

	KSocket *ksocket ;
	int fd ;

	char in_buf[BUFFER_SIZE][MAX_MESSAGE_SIZE] ;
	char out_buf[BUFFER_SIZE][MAX_MESSAGE_SIZE] ;

	int in_message_begin ;
	int in_message_end ;
	int out_message_begin ;
	int out_message_end ;
} ;

#endif
