/*
 * kchess.cpp
 *
 * Copyright (C) 1999 Arun Sharma <adsharma@home.com>
 */
#include "kchess.h"

#include <qkeycode.h>

#include <kfm.h>
#include <kiconloader.h>

KChess::KChess()
	: view(new KChessWidget(this))
{
	// tell the KTMainWindow that this is indeed the main widget
	setView(view);

	// create a DropZone over the entire window and connect it
	// to the slotDropEvent
	connect(new KDNDDropZone(this, DndURL), 
	        SIGNAL(dropAction(KDNDDropZone *)), 
	        SLOT(slotDropEvent(KDNDDropZone *)));


	// create a popup menu -- in this case, the File menu
	QPopupMenu* p = new QPopupMenu;
	p->insertItem(i18n("&Reset Game"), kapp, SLOT(quit()), CTRL+Key_Q);
	p->insertSeparator();
	p->insertItem(i18n("&Load Game"), kapp, SLOT(quit()));
	p->insertItem(i18n("Load Next Game"), kapp, SLOT(quit()));
	p->insertItem(i18n("Load Previous Game"), kapp, SLOT(quit()));
	p->insertItem(i18n("Reload Same Game"), kapp, SLOT(quit()));
	p->insertItem(i18n("&Save Game"), kapp, SLOT(quit()));
	p->insertSeparator();
	p->insertItem(i18n("Load Position"), kapp, SLOT(quit()));
	p->insertItem(i18n("Load Next Position"), kapp, SLOT(quit()));
	p->insertItem(i18n("Load Previous Position"), kapp, SLOT(quit()));
	p->insertItem(i18n("Reload Position"), kapp, SLOT(quit()));
	p->insertItem(i18n("Save Position"), kapp, SLOT(quit()));
	p->insertSeparator();
	p->insertItem(i18n("&Mail Move"), kapp, SLOT(quit()));
	p->insertItem(i18n("Reload CMail Message"), kapp, SLOT(quit()));
	p->insertSeparator();
	p->insertItem(i18n("&Quit"), kapp, SLOT(quit()));

	// put our newly created menu into the main menu bar
	menuBar()->insertItem(i18n("&File"), p);

	// create a popup menu -- in this case, the File menu
	p = new QPopupMenu;
	p->insertItem(i18n("Machine &White"), kapp, SLOT(quit()));
	p->insertItem(i18n("Machine &Black"), kapp, SLOT(quit()));
	p->insertItem(i18n("TWo Machine"), kapp, SLOT(quit()));
	p->insertItem(i18n("Analysis Mode"), kapp, SLOT(quit()));
	p->insertItem(i18n("Analyze File"), kapp, SLOT(quit()));
	p->insertItem(i18n("ICS Client"), kapp, SLOT(quit()));
	p->insertItem(i18n("Edit Game"), kapp, SLOT(quit()));
	p->insertItem(i18n("Edit Position"), kapp, SLOT(quit()));

	p->insertSeparator();
	p->insertItem(i18n("Show Game List"), kapp, SLOT(quit()));
	p->insertItem(i18n("Edit Tags"), kapp, SLOT(quit()));
	p->insertItem(i18n("Edit Comment"), kapp, SLOT(quit()));
	p->insertItem(i18n("ICS Input Box"), kapp, SLOT(quit()));
	p->insertItem(i18n("Pause"), kapp, SLOT(quit()));

	menuBar()->insertItem(i18n("&Mode"), p);

	p = new QPopupMenu;
	p->insertItem(i18n("Accept"), kapp, SLOT(quit()));
	p->insertItem(i18n("Decline"), kapp, SLOT(quit()));
	p->insertItem(i18n("Rematch"), kapp, SLOT(quit()));
	p->insertSeparator();
	p->insertItem(i18n("Call Flag"), kapp, SLOT(quit()));
	p->insertItem(i18n("Draw"), kapp, SLOT(quit()));
	p->insertItem(i18n("Adjourn"), kapp, SLOT(quit()));
	p->insertItem(i18n("Abort"), kapp, SLOT(quit()));
	p->insertItem(i18n("Resign"), kapp, SLOT(quit()));
	p->insertSeparator();
	p->insertItem(i18n("Stop Observing"), kapp, SLOT(quit()));
	p->insertItem(i18n("Stop Examining"), kapp, SLOT(quit()));

	menuBar()->insertItem(i18n("&Action"), p);

	p = new QPopupMenu;
	p->insertItem(i18n("Backward"), kapp, SLOT(quit()));
	p->insertItem(i18n("Forward"), kapp, SLOT(quit()));
	p->insertItem(i18n("Back To Start"), kapp, SLOT(quit()));
	p->insertItem(i18n("Forward To End"), kapp, SLOT(quit()));
	p->insertItem(i18n("Revert"), kapp, SLOT(quit()));
	p->insertItem(i18n("Truncate Game"), kapp, SLOT(quit()));

	p->insertSeparator();
	p->insertItem(i18n("Move Now"), kapp, SLOT(quit()));
	p->insertItem(i18n("Retract Game"), kapp, SLOT(quit()));

	menuBar()->insertItem(i18n("&Step"), p);

	p = new QPopupMenu;
	// Long list here
	p->insertItem(i18n("Always Queen"), kapp, SLOT(quit()));

	menuBar()->insertItem(i18n("&Options"), p);

	menuBar()->insertSeparator();


	// KDE will generate a short help menu automagically
	p = kapp->getHelpMenu(true, 
						  i18n("KChess --- Short Description\n\n"
							   "(c) 1999 Arun Sharma \n"
							   "Long Description"));
	menuBar()->insertItem(i18n("&Help"), p);

	// insert a quit button.  the icon is the standard one in KDE
	toolBar()->insertButton(Icon("exit.xpm"),   // icon
	                        0,                  // button id
							SIGNAL(clicked()),  // action
							kapp, SLOT(quit()), // result
							i18n("Exit"));      // tooltip text

	setFixedSize(650, 720);
	// we do want a status bar
	enableStatusBar();
}

KChess::~KChess()
{
}

void KChess::slotDropEvent(KDNDDropZone *zone)
{
	// the user dropped something on our window.
	QString url, temp_file;

	// get the URL pointing to the dropped file
	url = zone->getURLList().first();

	// let KFM grab the file
	if (KFM::download(url, temp_file))
	{
		// 'temp_file' now contains the absolute path to a temp file
		// with the contents of the the dropped file.  You would presumably
		// handle it right now.

		// after you are done handling it, let KFM delete the temp file
		KFM::removeTempFile(temp_file);
	}
}

void KChess::saveProperties(KConfig *config)
{
	// the 'config' object points to the session managed
	// config file.  anything you write here will be available
	// later when this app is restored
	
	// e.g., config->writeEntry("key", var); 
}

void KChess::readProperties(KConfig *config)
{
	// the 'config' object points to the session managed
	// config file.  this function is automatically called whenever
	// the app is being restored.  read in here whatever you wrote
	// in 'saveProperties'

	// e.g., var = config->readEntry("key"); 
}
