/***************************************************************************
                          bubble.cpp  -  description
                             -------------------
    begin                : Sat Jan 8 2000
    copyright            : (C) 2000 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bubble.h"

// KDE

// QT

// OTHER
#include "kbubbles.h"
#include <stdlib.h>
#include <iostream.h>

#define yDist 28
#define xDist 32

int convert[6] = { 3, 4, 5, 0, 1, 2 };

bubbleList *Bubble::bubList = NULL;
int Bubble::lowestBubble = 0;
int Bubble::colorLeft[6] = {0,0,0,0,0,0};
int Bubble::convertColor[6] = {0,0,0,0,0,0};
int Bubble::numCol=0;

Bubble::Bubble(Kbubbles *par,QwSpritePixmapSequence *KbPixSeq,int col,int x,int y)
	:	QObject(0,0),
		QwRealMobileSprite(KbPixSeq)
{
  this->frame(col);
  this->moveTo(x * xDist + (y%2 * xDist/2),5 + y*yDist);
	if (par != NULL)
		this->bounds(0,0,par->width()-xDist,par->height()-yDist);
  this->setBoundsAction(QwRealMobileSprite::Bounce);
  this->setVelocity(0.0,0.0);
  this->color = col;
  this->parent = par;
  this->haveWall = 0;
	this->gotWall = 0;
	this->friendB = -1;
	this->locked = 0;
	this->remove = 0;
	this->z(1);
	for (int i = 0; i < 6; i++)
		con[i] = NULL;
}
Bubble::~Bubble()
{
}

int Bubble::bubbleCollide()
{
	this->setVelocity(0.0,0.0);
	Bubble *tmp = new Bubble(this->parent, this->parent->KbPixSeq, this->color);
	tmp->frame(tmp->color);
	tmp->haveWall = tmp->getCorrectPos(this->x(),this->y() );
	
	this->color = convertColor[rand()%this->numCol];
	
	if (tmp->checkForFriends()) {
		tmp->markBubblesRemove();
		delete tmp;
		if (this->removeBubbles())
			return 1;	
	} else {
		tmp->lowestBubble = tmp->y() > tmp->lowestBubble ? tmp->y() : tmp->lowestBubble;
		if (tmp->lowestBubble > (parent->arr->y() - 16)) {
			return -1;
		}
		bubbleList *tmpList;
		tmpList = tmp->bubList->getNext(); // First always empty
		while (tmpList->getNext() != NULL)
			tmpList = tmpList->getNext();
		tmpList->add(tmp);
		tmp->colorLeft[tmp->color]++;
//		cout << "Color left: " << tmp->color << '\t' << tmp->colorLeft[tmp->color] << '\n';
	}
	this->frame(this->color);
	this->moveTo(parent->arr->x()+16,parent->arr->y()+16);
	if (this->moveDown)
		emit moveDownView();
	this->moveDown = 0;
	return 0;
}

int Bubble::getCorrectPos(int x, int y)
{
  int dx,dy;
  if ( (dy = ((y - 5) % yDist)) < (yDist / 2) ) {
  	y -= dy;
  } else {
  	y += (yDist - dy);
  }
  if ( ((y - 5) / yDist) % 2 == 0) {
   	// x starts from 0
  	if ( (dx = (x % xDist)) < (xDist / 2) ) {
	  	x -= dx;
		} else {
	  	x += (xDist - dx);
		}
	} else {
		// x starts from ball_r
		if ( ( (dx = ( (x - xDist/2) % xDist) ) < xDist/2 )  ||
      			(x >= (9 * xDist)) ) {
    	// Ball must fit inside visual area
	  	x -= dx;
		} else {
	  	x += (xDist - dx);
		}
  }
  this->moveTo(x,y);
  if (y == 5) {
//  	cout << "y == 5";
    return 1; // sitter mot taket
  }
  else
	return 0;
}
void Bubble::checkInitFriend()
{
	int offset[6][2] =  {	{-32, 0},{ -16, -28},
												{16, -28},{32, 0},
												{16, 28},{-16, 28}
											};
	int i,koll = 0;
	bubbleList *tmpList;
	tmpList = this->bubList->getNext(); // First always empty
	while (tmpList != NULL)	{
		koll = 0;
		for (i = 0;i < 6; i++) {
			if (this->con[i] != NULL)
				continue;
			if ( 	(tmpList->bub->x() == this->x() + offset[i][0]) &&
						(tmpList->bub->y() == this->y() + offset[i][1]) ) {
				koll++;
				break;
			}
		}
		if (koll) {	
			this->con[i] = tmpList->bub;
			tmpList->bub->con[(convert[i])] = this;
			if (this->color == this->con[i]->color) {
				this->friendB = i;
				this->con[i]->friendB = convert[i];
			}
		}	
		tmpList = tmpList->getNext();
	}
}

int Bubble::checkForFriends()
{
	int offset[6][2] =  {	{-32, 0},{ -16, -28},
												{16, -28},{32, 0},
												{16, 28},{-16, 28}
											};
	int i,koll = 0,del = 0;
//	Bubble *tmp;
	bubbleList *tmpList;
	tmpList = this->bubList->getNext(); // First always empty
	while (tmpList != NULL)	{
		koll = 0;
//		cout << tmpList->bub->x() << '\t' << tmpList->bub->y() << '\n';
		for (i = 0;i < 6; i++) {
			if ( 	(tmpList->bub->x() == this->x() + offset[i][0]) &&
						(tmpList->bub->y() == this->y() + offset[i][1]) ) {
				koll++;
				break;
			}
		}
		if (koll) {	
//			cout << i << '\t' << tmpList->bub->x() << '\t' << tmpList->bub->y() << '\n';
			this->con[i] = tmpList->bub;
			tmpList->bub->con[(convert[i])] = this;
			if (this->color == this->con[i]->color) {
				if (this->friendB >= 0 || this->con[i]->friendB >= 0) {
					del = 1;
				} else {
					this->friendB = i;
					this->con[i]->friendB = convert[i];
				}
			}	
		}
		tmpList = tmpList->getNext();
	}
	if (!del) {
		return 0;
	}			
	this->unLinkBubbles();
	return 1;
}

void Bubble::unLinkBubbles()
{
	int i;
	for (i = 0; i < 6; i++)
		if (this->con[i] != NULL)
			this->con[i]->con[(convert[i])] = NULL;
	for (i = 0; i < 6; i++)
		if (this->con[i] != NULL && this->color == this->con[i]->color)
			this->con[i]->unLinkBubbles();
	this->gotWall = 0;
	this->locked = 1;	
}	

int Bubble::markBubblesRemove()
{
//	cout << "Har brjat deleta\n";
	int i,retVal = 1;
	Bubble *tmp;
	bubbleList *tmpList;
	tmpList = this->bubList->getNext();  // First always empty
	while (tmpList != NULL)	{
		tmp = tmpList->bub;
		if (!tmp->locked && tmp->haveWall) {
			tmp->gotWall = 1;
			for (i = 0; i < 6; i++)
				if (tmp->con[i] != NULL)
					tmp->con[i]->giveWall();
		}
		tmpList = tmpList->getNext();
	}
		
	tmpList = this->bubList->getNext(); // First always empty
	while (tmpList != NULL)	{
		tmp = tmpList->bub;
		if (tmp->gotWall == 0) {
			tmp->remove = 1;
//			cout << "REMOVING "<< tmp->x() << '\t' << tmp->y() << "\n";
		} else {
			retVal = 0;
		}
		tmp->gotWall = tmp->locked = 0;
		tmpList = tmpList->getNext();
	}		
	return retVal;
}

void Bubble::giveWall()
{
	if ( !(this->locked) && !(this->haveWall) ) {
 		this->gotWall = this->locked = 1;
 		for (int i = 0;i < 6; i++)
      if (this->con[i] != NULL)
	  		this->con[i]->giveWall();
	}
}
int Bubble::removeBubbles()
{
	int nrb=1; // number removed bubbles
	bubbleList *tmpList;
	tmpList = this->bubList->getNext(); // First always empty
	this->lowestBubble = 0;
	while (tmpList != NULL)	{
		if (tmpList->bub->remove) {
			if (!(--tmpList->bub->colorLeft[tmpList->bub->color]))
				this->setupColors();				
			tmpList = tmpList->remove();
			nrb++;
		}
		else {
			this->lowestBubble = tmpList->bub->y() > this->lowestBubble ? tmpList->bub->y() : this->lowestBubble;
			tmpList = tmpList->getNext();
		}
	}
	emit deletedBubbles(nrb);
	if (this->bubList->getNext() == NULL) // First always empty
		return 1;
	return 0;
}
void Bubble::setupColors()
{
	int i;
	numCol = 0;
	for (i = 0; i < 5; i++)
		if (this->colorLeft[i] || this->color == i)
			convertColor[numCol++] = i;
}

bubbleList::bubbleList()
{
	this->bub = NULL;
	this->next = this->prev = NULL;
}

bubbleList::bubbleList(Bubble *b)
{
	this->bub = b;
	this->next = this->prev = NULL;
}

bubbleList::~bubbleList()
{
}

bubbleList *bubbleList::getNext()
{
	return this->next;
}

void bubbleList::setNext(bubbleList *bL)
{
	this->next = bL;
}

bubbleList *bubbleList::getPrev()
{
	return this->prev;
}

void bubbleList::setPrev(bubbleList *bL)
{
	this->prev = bL;
}

bubbleList *bubbleList::add(Bubble *b)
{
	this->next = new bubbleList(b);
	this->next->setNext(NULL);
	this->next->setPrev(this);
	return this->next;
}

bubbleList *bubbleList::remove()
{
	bubbleList *tmp;
	tmp = this;
	if (this->next == NULL && this->prev == NULL) {
		this->bub->bubList = NULL;
	}
	if (this->prev != NULL) {
		this->prev->setNext(this->next);
	}	else {
		this->bub->bubList = this->next;
	}
	if (this->next != NULL)
		this->next->setPrev(this->prev);
	delete this->bub;
	tmp = this->next;
	delete this;
	return tmp;	
}
