#include "user_input.h"
#include <qframe.h>


UserInput::
UserInput(float min_bet, float max_bet, float bet_inc, QWidget *parent, 
          const char *name) : QWidget( parent, name ) {
   _split_p = new QPushButton("Split", this, "split_button");
   connect (_split_p, SIGNAL(released()), parent, SLOT(split()));

   _double_down_p = new QPushButton("Double Down", this, "double_button");
   connect (_double_down_p, SIGNAL(released()), parent, SLOT(doubleDown()));

   _hit_p = new QPushButton("Hit", this, "hit_button");
   connect (_hit_p, SIGNAL(released()), parent, SLOT(hit()));

   _stand_p = new QPushButton("Stand", this, "stand_button");
   connect (_stand_p, SIGNAL(released()), parent, SLOT(stand()));

   _bet_p = new QPushButton("Place Bet", this, "bet_button");
   connect (_bet_p, SIGNAL(released()), parent, SLOT(bet()));

   _bet_sb_p = new QtedDollarScrollBar("Bet = ", min_bet, max_bet, bet_inc, 
                                       this);
   setMinimumSize(100, 200);

   resizeEvent(NULL);
}


void UserInput::
resizeEvent(QResizeEvent *) {
   _split_p->setGeometry(0, height() * 3/10, width(), height()/10);
   _double_down_p->setGeometry(0, height() * 4/10, width(), height()/10);
   _hit_p->setGeometry(0, height() * 5/10, width(), height()/10);
   _stand_p->setGeometry(0, height() * 6/10, width(), height()/10);
   _bet_p->setGeometry(0, height() * 7/10, width(), height()/10);
   _bet_sb_p->setGeometry(0, height() * 8/10, width(), height()/5);
}


void UserInput::
makeValid(int flags) {
   if (flags & Stand)
      _stand_p->setEnabled(TRUE);
   if (flags & Hit)
      _hit_p->setEnabled(TRUE);
   if (flags & Double)
      _double_down_p->setEnabled(TRUE);
   if (flags & Split)
      _split_p->setEnabled(TRUE);
   if (flags & Bet) {
      _bet_sb_p->setEnabled(TRUE);
      _bet_p->setEnabled(TRUE);
   }
}


void UserInput::
makeInvalid(int flags) {
   if (flags & Stand && ! _stand_p->isDown())
      _stand_p->setEnabled(FALSE);
   if (flags & Hit && ! _hit_p->isDown())
      _hit_p->setEnabled(FALSE);
   if (flags & Double && ! _double_down_p->isDown())
      _double_down_p->setEnabled(FALSE);
   if (flags & Split && ! _split_p->isDown())
      _split_p->setEnabled(FALSE);
   if (flags & Bet) {
      _bet_sb_p->setEnabled(FALSE);
      _bet_p->setEnabled(FALSE);
   }
}

