/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qkeycode.h>
#include <qdir.h>
#include <qfileinf.h> 
#include <kapp.h>
#include <kconfig.h> 
#include <kmsgbox.h> 

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kalaxGame.h"
#include "config.h"
#include "DebugInfo.h"
#include "optionsDialog.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/
#define BG_IMGAGE "/bg.ppm"
#define BG_IMAGE_WIDTH  FIELD_WIDTH
#define BG_IMAGE_HEIGHT FIELD_HEIGHT


// Gamestates
#define GAME_NO_GAME 0
#define GAME_RUNNING 1
#define GAME_PAUSED  2



/*-----------------------------------------------------------------------------
-- GLOBAL-VARIABLES
-----------------------------------------------------------------------------*/
static unsigned char cb_bits[] = {    // cursor bitmap
  0x00};
static unsigned char cm_bits[] = {    // cursor bitmask
  0x00};


//
//      Name:  kalaxGame
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
kalaxGame::kalaxGame( QWidget * parent, const char * name )
:QWidget( parent, name )
{
  dprintf( "START::()\n");

  // variables initialisation 
  statusDisplaySprite=NULL;
  defaultPlan=NULL;
  player=NULL;
  backGroundField=NULL;
  backGroundFieldView=NULL;
  destroySequence=NULL;
  playerDestr=NULL;
  playSound=NULL;
  locale=NULL;
  level=NULL;
  gameState = GAME_NO_GAME;
  updateTimerId = 0;
  levelNr = 0;
  keybGame = false;
  gameScore = 0;
  player = NULL;
  playerDestr = NULL;


  locale = kapp->getLocale();
  kalaxOptions = new KalaxConfigDialog( this );
  kalaxOptions->readConfig();
  kalaxOptions->writeConfig();

  //64, 100
  backGroundField = new QwImageSpriteField( kalaxOptions->spritesPath+BG_IMGAGE, 
                                            BG_IMAGE_WIDTH, BG_IMAGE_HEIGHT, 50, 200 );// 16,100
  backGroundField->resize( BG_IMAGE_WIDTH ,BG_IMAGE_HEIGHT );

  backGroundFieldView = new QwSpriteFieldView( backGroundField, this );
  backGroundFieldView->resize( BG_IMAGE_WIDTH ,BG_IMAGE_HEIGHT );
  resize( BG_IMAGE_WIDTH ,BG_IMAGE_HEIGHT );

  destroySequence = new QwSpritePixmapSequence( kalaxOptions->spritesPath+DESTROY_SPRITE_DATA,kalaxOptions->spritesPath+DESTROY_SPRITE_MASK,
                                                DESTROY_SPRITE_COUNT );

  playerShotsList.setAutoDelete( true );
  enemyShotsList.setAutoDelete( true );
  enemyList.setAutoDelete( true );
  enemyDestrList.setAutoDelete( true ); 
  playerShipsList.setAutoDelete( true );  
  flightPlanList.setAutoDelete( true );

  // Initialize EnemyTypes
  enemyTypesList.setAutoDelete( true );
  enemyTypesList.append( new EnemyType( kalaxOptions->spritesPath+ENEMY_1_SPRITE_DATA,
                                        kalaxOptions->spritesPath+ENEMY_1_SPRITE_MASK,
                                        ENEMY_1_SPRITE_COUNT ));
  enemyTypesList.append( new EnemyType( kalaxOptions->spritesPath+ENEMY_2_SPRITE_DATA,
                                        kalaxOptions->spritesPath+ENEMY_2_SPRITE_MASK,
                                        ENEMY_2_SPRITE_COUNT ));
  enemyTypesList.append( new EnemyType( kalaxOptions->spritesPath+ENEMY_3_SPRITE_DATA,
                                        kalaxOptions->spritesPath+ENEMY_3_SPRITE_MASK,
                                        ENEMY_3_SPRITE_COUNT ));
  enemyTypesList.append( new EnemyType( kalaxOptions->spritesPath+ENEMY_4_SPRITE_DATA,
                                        kalaxOptions->spritesPath+ENEMY_4_SPRITE_MASK,
                                        ENEMY_4_SPRITE_COUNT ));


  // Initialize Soundfilenames
  soundEshoot = kalaxOptions->soundPath + "/" +  ESHOOT_SOUNDNAME;
  soundRshoot = kalaxOptions->soundPath + "/" +  PSHOOT_SOUNDNAME;
  soundEdestroy = kalaxOptions->soundPath + "/" + EDESTROY_SOUNDNAME;
  soundRdestroy  = kalaxOptions->soundPath + "/" +  PDESTROY_SOUNDNAME;
 



  // Read the level filenames
  //-------------------------
  QDir levelDir( kalaxOptions->levelPath, "level_*.lev" );
  QFileInfoList *filesList = levelDir.entryInfoList();
  QFileInfo *fi;
  QFileInfoListIterator it( *filesList );
  while ( (fi=it.current()) )
  {
    dprintf( "getLevelFilename:>%s<\n", (const char *)fi->absFilePath() );
    levelFileNames.append( fi->absFilePath() );
    ++it;
  }
  dprintf( "read %d level filenames\n",levelFileNames.count() );

  if ( levelFileNames.count() < 1 )
  {
    KMsgBox dialog( this, locale->translate("Error"), 
                    locale->translate( "No level files (level_*.lev) found in\ndirectory:" ) + kalaxOptions->levelPath +
                    locale->translate( "\n\n You can't play !"),
                    KMsgBox::EXCLAMATION, "OK" );
    dialog.show();
  }


  // Read the flightplan filenames and fill the flightplanlist
  //----------------------------------------------------------
  QDir flightDir( kalaxOptions->flightPlanPath, "flight_*.plan" );
  filesList = flightDir.entryInfoList();
  QFileInfoListIterator itfl( *filesList );
  while ( (fi=itfl.current()) )
  {
    FILE *fp;
    if ( ( fp = fopen ( fi->absFilePath(), "r" ) ) == NULL )
    {
      fprintf( stderr, "Error opening flightplan file: %s\n",(const char *)fi->absFilePath()); 
    }
    else
    {
      int xflp, yflp, frameflp;
      char line[256];
      int nrFlightPlanEntrys = 0;
      flightPlan *flplan = new flightPlan();
      while ( (fgets( line, 255, fp )) != NULL )
      {
        if ( sscanf( line, "%d %d %d", &xflp, &yflp, &frameflp ) == 3 )
        {
          flplan->addPlanEntry( QPoint( xflp, yflp ), frameflp );
          nrFlightPlanEntrys++;
        }
        else
        {
          fprintf( stderr, "invalid flightplan line >%s< in file >%s<", line, (const char *)fi->absFilePath()); 
          fprintf( stderr, "flightplan entry not added. ( Syntax: > x y f < )\n");
        }
      }
      fclose( fp );
      if ( nrFlightPlanEntrys == 0 )
      {
        fprintf( stderr, "no valid flightplan in file >%s<", (const char *)fi->absFilePath());
        delete flplan;
        flplan = NULL;
      }
      else
      {
        dprintf( " added flightplan >%s< whith >%d< entries\n", (const char *)fi->absFilePath(), nrFlightPlanEntrys );
        flightPlanList.append( flplan );
      }

    } // else ...if ( ( fp = fopen ( fi->absFilePath(), "r" ) ) == NULL )
    dprintf( "getLevelFilename:>%s<\n", (const char *)fi->absFilePath() );
    ++itfl;
  } // while ( (fi=itfl.current()) )
  dprintf( "create %d flightplans\n",flightPlanList.count() );

  if ( flightPlanList.count() < 1 )
  {
    KMsgBox dialog( this, locale->translate("Warning"), 
                    locale->translate( "No flight plan files (flight_*.plan) found in\ndirectory:" ) + kalaxOptions->flightPlanPath,
                    KMsgBox::INFORMATION, "OK" );
    dialog.show();
  }

  // Create default flightPlan
  defaultPlan=new flightPlan();
#if 0  
  defaultPlan->addPlanEntry( QPoint( 1, 1 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, 1 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 1 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 1 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, -1 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, -1 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, -1 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, -1 ), 18 );
#endif 
  defaultPlan->addPlanEntry( QPoint( 1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( 1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 0 ), 18 );
  defaultPlan->addPlanEntry( QPoint( -1, 0 ), 18 );


  // make sound available
  playSound = new KAudio();
  if ( playSound->serverStatus() != 0 )
  {
    KMsgBox dialog( this, locale->translate("Warning"),
                    locale->translate( "Can't initialize Sound" ),
                    KMsgBox::INFORMATION, "OK" );
    dialog.show();
  }

  // Create the Statusdisplayline
  statusDisplaySprite = new statLine();
  connect( this, SIGNAL( putShips( char * ) ),
           statusDisplaySprite, SLOT( setShips( char * ) ) );
  connect( this, SIGNAL( putScore( char * ) ),
           statusDisplaySprite, SLOT( setScore( char * ) ) );

  // Create Gamefield-Cursor  
  QBitmap cb( 1, 1, cb_bits, TRUE );
  QBitmap cm( 1, 1, cm_bits, TRUE );
  QCursor custom( cb, cm );     // create bitmap cursor
  this->setCursor( custom );

  // Accept user input
  setFocusPolicy ( StrongFocus );

  emitGameValues( );  

  show();

  dprintf( "END::()\n");
}

//
//      Name:  kalaxGame
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
kalaxGame::~kalaxGame( )
{
  dprintf( "START::()\n");
  playerShipsList.clear();
  enemyTypesList.clear();
  flightPlanList.clear();

  if ( statusDisplaySprite != NULL )
  {
    delete statusDisplaySprite;    
  }

  if ( kalaxOptions != NULL )
  {
    delete kalaxOptions;
  }
  playerShotsList.clear();
  enemyShotsList.clear();
  enemyList.clear();
  enemyDestrList.clear();

  dprintf( "END::()\n");
}



//
//      Name:  newGame
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::newGame()
{
  dprintf( "START::()\n");

  // if the game not run then initialze it
  if ( gameState != GAME_RUNNING )
  {
    gameScore = 0;
    levelNr = 1;
    emitGameValues( );

    playerShotsList.clear();
    enemyShotsList.clear();
    enemyList.clear();

    // create the player ships
    playerShipsList.clear();
    for ( unsigned int i = 0; i < kalaxOptions->playerShipCount; i++ )
    {
      playerShipsList.append( new playerShip( kalaxOptions->spritesPath ) );
    }
    player=playerShipsList.first();
    player->movePlayer( Bottom );

    // create the enemys
    startLevel( levelNr );

    if ( keybGame == false )
    {
      setMouseTracking ( true );         // grabMouse() but aware grabbing is difficult
      grabMouse();
    }
    else
    {
      setFocus();                                  // set focus to game-widget
      setMouseTracking ( false );
      releaseMouse();
    }

    if ( updateTimerId == 0 )
    {
      updateTimerId = startTimer( kalaxOptions->timerInterval );
    }

    if ( updateTimerId == 0 )
    {
      killTimers();
      updateTimerId = 0;
      fprintf( stderr, "Class kalaxGame: Can't create timer\n");
    }
    else
    {
      gameState = GAME_RUNNING;
    }
  }
  else
  {
    // game already running
  }

  dprintf( "END::()\n");
}

//
//      Name:  pauseGame()
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::pauseGame()
{
  dprintf( "START::()\n");

  if ( gameState == GAME_RUNNING )
  {
    killTimers();
    updateTimerId = 0;
    gameState = GAME_PAUSED;
    if ( keybGame == false )
    {
      setMouseTracking ( false );
      releaseMouse();
    }
  }
  else
  {
    // Start Timers and set gameState
    if ( gameState == GAME_PAUSED )
    {

      if ( updateTimerId == 0 )
      {
        updateTimerId = startTimer( kalaxOptions->timerInterval );
      }

      if ( updateTimerId == 0 )
      {
        killTimers();
        updateTimerId = 0;
        fprintf( stderr, "Class kalaxGame: Can't create timer\n");
      }
      else
      {
        gameState = GAME_RUNNING;         
        if ( keybGame == false )
        {
          setMouseTracking ( true );
          grabMouse();
        }
      }
    }
  }

  emitGameValues( STATE );

  dprintf( "END::()\n");
}


//
//      Name:  endGame
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::endGame()
{
  dprintf( "START::()\n");

  killTimers();
  updateTimerId = 0;

  ///////////////////////////////////////////////////////////////////////////
  /// Part from destructor, put together in fct
  playerShipsList.clear();
  enemyShotsList.clear();
  enemyList.clear();
  enemyDestrList.clear();
  enemyTypesList.clear();
  flightPlanList.clear();
  playerShotsList.clear();

  /////////////////////////////////////////////////////////////////////////// 

  if ( keybGame == false )
  {
    setMouseTracking ( false );
    releaseMouse();
  }
  gameState = GAME_NO_GAME;
  emitGameValues( STATE );

  backGroundField->update();
  kapp->syncX(); 


  dprintf( "END::()\n");
}



//
//      Name:  kalaxGame::mouseGame
//
//   Comment:  switches the Game from Keyboardgame to Mousegame
//
//    Extern:
//
void kalaxGame::mouseGame()
{
  dprintf( "START::()\n");
  if ( gameState == GAME_RUNNING )
  {
    setMouseTracking ( true );         // grabMouse() but aware grabbing is difficult
    grabMouse();
  }
  keybGame = false;

  dprintf( "END::()\n");
}

//
//      Name:  kalaxGame::keyboardGame
//
//   Comment:  switches the Game from Mousegame to Keyboardgame
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::keyboardGame()
{
  dprintf( "START::()\n");

  setMouseTracking ( false );
  releaseMouse();
  keybGame = true;

  dprintf( "END::()\n");
}




//
//      Name:  kalaxGame
//
//   Comment:  step enemy-shots, player-shots, enemys
//             check collision enemy - player shot
//                             enemyshot - player
//                             playershot - enemy
//
// Parameter:  QTimerEvent *te
//
void kalaxGame::timerEvent( QTimerEvent *te )
{
  int timerid;

  static unsigned int moveEnemy=0;               // should enemey moved ?

  static int startShotRnd=0;
  static int startShotRndQuest = 100;

  static int startEnemyFlightRnd=0;
  static int startEnemyFlightQuest = 1000;

  // Next Level
  static int timerWaitTicks = 0;
  static int NEXTLEVELWAIT = 75;
  static QwTextSprite *levelTextDisplay=NULL;
  static QwTextSprite *gameOverTextDisplay=NULL;

  // Collision detection
  QwSpriteFieldGraphic *playerFieldHit, *pShotFieldHit;
  Pix nhPix;

  bool emitState = false;

  static int intState = 0;    // the timer will be started outside this function.
                              // inside this fct. we will need to know what to do
                              // Normal Game Play --> intState = 0
                              // NextLevelAnimation --> intState = 1
                              // GameOverAnimation --> intState = 2

  dprintf( "START::()\n");


  timerid = te->timerId();

  // Normal Game Mode --> move enemies, player, colision detect ...
  //---------------------------------------------------------------------------
  if ( timerid == updateTimerId && intState == 0 ){   // normal game mode
    playerShot *ps;
    enemyShot *es;

    moveEnemy++;
    if ( moveEnemy >  kalaxOptions->moveEnemyEveryTick ){
       moveEnemy = 0;
    }

    // Move the enemys and start shot ( if random ) and start flying enemy  ( if random ) 
    //-----------------------------------------------------------------------------------
    Enemy *enemy;  
    QListIterator<Enemy> iterator( enemyList );
    for (  ; iterator.current(); ++iterator ) {
      enemy=iterator.current();
      if (  ( enemy->enemyFlys == TRUE ) || ( moveEnemy == kalaxOptions->moveEnemyEveryTick ) ){
        enemy->nextStep( );
      }

      startShotRnd++;
      if ( startShotRnd == startShotRndQuest ){
        startShotRnd = 0;
        // between (levels-level)*20 and 500 
        startShotRndQuest=((levelFileNames.count() - levelNr) * 10)+
                           (int) (500.0*rand()/(RAND_MAX+1.0));
        startEnemyShot( enemy );
      }

      startEnemyFlightRnd++;
      if ( startEnemyFlightRnd == startEnemyFlightQuest ) {
        static int flightPlanNr = 0;
        startEnemyFlightRnd = 0;
        // between (levels-level)*20 and 500 
        startEnemyFlightQuest=((levelFileNames.count() - levelNr) * 100)+
                              (int) (1000.0*rand()/(RAND_MAX+1.0));

        flightPlanNr=0+(int)( (flightPlanList.count() -1 ) *rand()/(RAND_MAX+1.0));
        enemy->specialFlightPlan( flightPlanList.at(flightPlanNr) );
      }
    }//for(  ; iterator.current(); ++iterator )

    // step enemy shots, check shot out of bounds
    //-------------------------------------------
    for ( es = enemyShotsList.first(); es != 0; es = enemyShotsList.next()){
      es->forward( 1 );      
      if ( es->outOfBounds() == true ){
        enemyShotsList.removeRef( es );      
      }
    }
   
    // step player shots, check shot out of bounds    
    //--------------------------------------------
    for ( ps = playerShotsList.first(); ps != 0; ps = playerShotsList.next()){
      ps->forward( 1 );

      if ( ps->outOfBounds() == true ){
        playerShotsList.removeRef( ps );      
      }
    }//for ( ps = playerShotsList.first(); ps != 0; ps = playerShotsList.next())

    // check collision player against enemies and enemyshots
    // -----------------------------------------------------
    if ( player!=0L ){
      bool playerDead = false;
      nhPix = player->neighbourhood( player->frame() );
      playerFieldHit = player->at( nhPix );
      while ( playerFieldHit != 0L ){
        if ( playerFieldHit->rtti() == RTTI_ENEMY ){
          if ( collision( player, (Enemy *)playerFieldHit ) == true ){
            // player hits enemy
            playerDead = true;
            QwMobileSprite *mSp= new QwMobileSprite( destroySequence );
            enemyDestrList.append( mSp );
            mSp->moveTo( ((const Enemy *)playerFieldHit)->x(), ((const Enemy *)playerFieldHit)->y());
            enemyHit( (Enemy *)playerFieldHit );
            break;                                             // BREAK BREAK
          } //if ( collision( player, (Enemy *)playerFieldHit ) == true )
        }else {
           if ( playerFieldHit->rtti() == RTTI_ENEMYSHOT ){
             if ( collision( player, (enemyShot *)playerFieldHit ) == true ){
               // enemyshot hits player
               playerDead = true;
               enemyShotsList.removeRef( (const enemyShot*)playerFieldHit );       
               break;                                             // BREAK BREAK           
             }
           }  //if ( playerFieldHit->rtti() == RTTI_ENEMY_SHOT ) 
        }//else  if  ( playerFieldHit->rtti() == RTTI_ENEMY ...         
        player->next( nhPix );
	      playerFieldHit = player->at( nhPix );
      } // while
      player->end( nhPix );

      if ( playerDead == true ){
        if ( playerDestr == NULL ){
           playerDestr = new QwMobileSprite( destroySequence );
           playerDestr->moveTo( player->x(),player->y());
        }
        playerHit( player );
        emitState = true;
      }
    }// if ( player!=0L )    
   
    // check collision playershot against enemies
    // ------------------------------------------
    for ( ps = playerShotsList.first(); ps != 0; ps = playerShotsList.next()){
      bool shotHit = false;

      nhPix = ps->neighbourhood( ps->frame() );
      pShotFieldHit = ps->at( nhPix );
      while ( pShotFieldHit != 0L ){
        if ( pShotFieldHit->rtti() == RTTI_ENEMY ){
          if ( collision( ps , (Enemy*)pShotFieldHit ) == true ){  // if ps->exact( nhPix ) 
            shotHit = true;
            QwMobileSprite *mSp= new QwMobileSprite( destroySequence );
            enemyDestrList.append( mSp );
            mSp->moveTo( ((Enemy*)pShotFieldHit)->x(), ((Enemy*)pShotFieldHit)->y());
            enemyHit( (Enemy *)pShotFieldHit );
            break;                                             // BREAK BREAK
          }
        }
        ps->next( nhPix );
	      pShotFieldHit = ps->at( nhPix );
      } // while
      ps->end( nhPix );

      if ( shotHit == true ){
        playerShotsList.removeRef( ps );
        emitState = true;
      }       
    }//for ( ps = playerShotsList.first(); ps != 0; ps = playerShotsList.next())  
   } //if ( timerid == updateTimerId  && intState == 0 )



  // Play DestroyAnimations
  // --------------------------------------------------------------------------
   QListIterator<QwMobileSprite> iteratorMS( enemyDestrList );
   QwMobileSprite *enemyDestr;
   for (  ; iteratorMS.current(); ++iteratorMS ){
     enemyDestr=iteratorMS.current();
     if ( enemyDestr->frame() < enemyDestr->frameCount() -1 ){
       enemyDestr->frame( enemyDestr->frame() +1 );
     }
     else{
       enemyDestrList.removeRef( enemyDestr );      
     }
   }
   if ( playerDestr != NULL ){
     if ( playerDestr->frame() < playerDestr->frameCount() - 1  ){
       playerDestr->frame( playerDestr->frame() + 1);
     }
     else{
       delete playerDestr;
       playerDestr = NULL;
     }
   }



  // Level finished ?
  //---------------------------------------------------------------------------
  if ( enemyList.isEmpty() == true ){
    intState = 1;
  }

  // Next Level Animation
  //---------------------------------------------------------------------------
  if ( timerid == updateTimerId  && intState == 1 ){
    if ( timerWaitTicks == 0 ){
      QString s;
      s.sprintf( "Level %d", levelNr+1 );
      if ( levelTextDisplay== NULL ){
        levelTextDisplay=new QwTextSprite( (const char*)s, QFont( "Helv", 24 ) );
      }
      levelTextDisplay->setText( s );
      levelTextDisplay->setColor ( QColor( 90,100,140 ));
      levelTextDisplay->moveTo( 280, 250 );
      levelTextDisplay->visible( true );
    }

    if ( levelTextDisplay != NULL ){
      levelTextDisplay->moveBy( 0, -3);
    }
    if ( timerWaitTicks < NEXTLEVELWAIT ){
      timerWaitTicks++;
    }
    else{
      timerWaitTicks = 0;
      // delete levelTextDisplay;     
      levelTextDisplay->visible( false );
      levelNr++;
      startLevel( levelNr );
      intState=0;
    }
  } // if ( timerid == updateTimerId  && intState == 1 )


  // Game Over ?
  //---------------------------------------------------------------------------
  if ( playerShipsList.isEmpty() || player == 0L ){
    intState = 2;
  }

  // Game Over Animation
  //---------------------------------------------------------------------------
  if ( timerid == updateTimerId  && intState == 2 ){
    if ( timerWaitTicks == 0 ){
      QString s="Game Over";
      if ( gameOverTextDisplay== NULL ){
        gameOverTextDisplay=new QwTextSprite( (const char*)s, QFont( "Helv", 24 ) );
      }
      gameOverTextDisplay->setText( s );
      gameOverTextDisplay->setColor ( QColor( 90,100,140 ));
      gameOverTextDisplay->moveTo( 280, 250 );
      gameOverTextDisplay->visible( true );
    }

    if ( gameOverTextDisplay != NULL ){
      gameOverTextDisplay->moveBy( 0, -3);
    }
    if ( timerWaitTicks < NEXTLEVELWAIT ){
      timerWaitTicks++;
    }
    else{
      timerWaitTicks = 0;
      // delete levelTextDisplay;     
      gameOverTextDisplay->visible( false );
      intState=0;
      endGame();
    }
  } // if ( timerid == updateTimerId  && intState == 2 )


  backGroundField->update();
  kapp->syncX(); 

  if ( emitState == true ){
    emitGameValues( );
  }
  
  dprintf( "END::()\n");
}



//
//      Name:  keyPressEvent
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::keyPressEvent(QKeyEvent *event)
{
  dprintf( "START::()\n");

  if ( gameState == GAME_RUNNING && keybGame == true )
  {
    switch ( event->key() )
    {
    case Key_Left:
      player->movePlayer( Left );
      event->accept();
      break;

    case Key_Right:
      player->movePlayer( Right );
      event->accept();
      break;

    case Key_Up:
      player->movePlayer( Top );
      event->accept();
      break;
    case Key_Down: 
      player->movePlayer( Bottom );
      event->accept();
      break;
    case Key_Space:
      startPlayerShot();
      break;
    default:
      event->ignore();
      break;
    }
  }
  else
  {
    event->ignore();
  }

  dprintf( "END::()\n");

}


//
//      Name:  keyReleaseEvent
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::keyReleaseEvent(QKeyEvent *event)
{
  dprintf( "START::()\n");
  event->ignore();
  dprintf( "END::()\n");
}

//                
//      Name:  kalaxGame::mouseMoveEvent
//
//   Comment: Set the player ship to the current mouse position
//            collision detection is done in fct. timerEvent
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::mouseMoveEvent( QMouseEvent *event )
{
  dprintf( "START::()\n");
  dprintf( "Mouse.x=>%d<\n", event->pos().x() );   
  dprintf( "Mouse.y=>%d<\n", event->pos().y() );

  if ( gameState == GAME_RUNNING && player != 0L )
  {
    if ( keybGame == false )
    {
      player->movePlayer( event->pos().x(), event->pos().y() );
    }
  }

  dprintf( "END::()\n");
}

//
//      Name:  kalaxGame::mousePressEvent
//
//   Comment: Eventhandler for pressed mousebuttons
//            Currently, only the left button takes action.
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
void kalaxGame::mousePressEvent( QMouseEvent *event )
{
  dprintf( "START::()\n");

  if ( keybGame == false && player != 0L )
  {
    switch ( event->button() )
    {
    case LeftButton:
      startPlayerShot();
      dprintf("LeftButton\n");
      break;
    case RightButton:
      dprintf("RightButton\n");
      break;
    case MidButton:  
      dprintf("MiddleButton\n");
      break;
    case NoButton:
    default:
      break;
    }
  }
  dprintf( "END::()\n");
}

//
//      Name:  kalaxGame::resizeEvent
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::resizeEvent( QResizeEvent *event )
{

  dprintf( "START::resizeEvent( event=>%x< )\n", event );

  //dprintf( "wo=%d ho=%d\n", event->oldSize().width(), event->oldSize().height() );
  //dprintf( "wn=%d hn=%d\n", event->size().width(), event->size().height()  );

  dprintf( "END::resizeEvent()=>void<\n");

}



//          
//      Name:  kalaxGame::startPlayerShot
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::startPlayerShot()
{

  static int toggle=0;
  static QwSpritePixmapSequence *shot=0L;
  dprintf( "START::()\n");

  if ( shot == 0L ){
    shot = new QwSpritePixmapSequence( kalaxOptions->spritesPath+PSHOOT_SPRITE_DATA, 
                                       kalaxOptions->spritesPath+PSHOOT_SPRITE_MASK,
                                       PSHOOT_SPRITE_COUNT );
  }

  if ( playerShotsList.count() < kalaxOptions->maxPlayerShots )
  {
    playerShot *ps;
    if ( toggle == 0)
    {
      ps = new playerShot( shot );
      ps->setVelocity( 0, -kalaxOptions->spriteStepPlayerShot );
      ps->startShot( player->exact_x()+7, player->exact_y() );
      playerShotsList.append( ps );
      toggle = 1;
    }
    else
    {
      ps = new playerShot( shot );
      ps->setVelocity( 0, -kalaxOptions->spriteStepPlayerShot );
      ps->startShot( player->exact_x()+23, player->exact_y() );
      playerShotsList.append( ps );
      toggle = 0;
    }
    doSound( RSHOOT_SOUND );  
  }

  dprintf( "END::()\n");
}

//          
//      Name:  kalaxGame::startEnemyShot
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::startEnemyShot( Enemy *enemy )
{ 
  int ydiff, xdiff, xvelo;
  static QwSpritePixmapSequence *shot=0L;

  dprintf( "START::()\n");

  if ( shot == 0L ){
    shot = new QwSpritePixmapSequence( kalaxOptions->spritesPath+ESHOOT_SPRITE_DATA, 
                                       kalaxOptions->spritesPath+ESHOOT_SPRITE_MASK,
                                       ESHOOT_SPRITE_COUNT );
  }

  if ( enemyShotsList.count() < kalaxOptions->maxEnemyShots ){
    enemyShot *es= new enemyShot( shot );
    es->startShot( enemy->x(), enemy->y() ); 
    xvelo = 0;
    // Calculate the X - velocity
    if ( player != 0L )
    {
      ydiff = player->y() - enemy->y();
      if ( ydiff != 0 )
      {
        xdiff = player->exact_x()+7 - enemy->x();
        if ( xdiff != 0 )
        { 
// ??????????????????????????????????????????????????????????????????????????????????????????????????????????
#if 0        
          xvelo= xdiff / ( ydiff / kalaxOptions->spriteStepEnemyShot  + 1 );
          fprintf( stdout, "xvelo=>%d<, xdiff=>%d< ydiff=>%d< sses=>%d<\n", xvelo, xdiff, ydiff, kalaxOptions->spriteStepEnemyShot );

fprintf printed the following
xvelo=>93368853<, xdiff=>-13< ydiff=>320< sses=>7<
how could this be  ????????????

i wrote a simple c programm with the same code
#include <stdio.h>
int main()
{
  int ydiff, xdiff, xvelo;

  xdiff = -128;
  ydiff = 222;
  xvelo= ( xdiff )  / ( ( ydiff / 7 ) + 1 );
  fprintf( stdout, "xvelo=>%d<, xdiff=>%d< ydiff=>%d<\n", xvelo, xdiff, ydiff );
}

which printed the following
xvelo=>-4<, xdiff=>-128< ydiff=>222<  --> thats right
#endif
// ??????????????????????????????????????????????????????????????????????????????????????????????????????????
          // work around
          if ( xdiff > 0 ){
            xvelo= xdiff / ( ydiff / kalaxOptions->spriteStepEnemyShot  + 1 );
          }else{
            xvelo= -xdiff / ( ydiff / kalaxOptions->spriteStepEnemyShot  + 1 );
            xvelo=-xvelo;
          }
        } // if ( ydiff != 0 ) 
      } // if ( player != 0L )
    }

    es->setVelocity( xvelo, kalaxOptions->spriteStepEnemyShot );
 
    enemyShotsList.append( es );    
    doSound( ESHOOT_SOUND );
  }

  dprintf( "END::()\n");
}



//  
//      Name:  kalaxGame::emitGameValues
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::emitGameValues( EmitGameValues egv )
{
  char scoreStr[12];
  char shipsStr[5];

  dprintf( "START::()\n");

  switch ( egv )
  {
  case ALL:
    sprintf( scoreStr, "%5ld", gameScore );
    sprintf( shipsStr, "%2d", playerShipsList.count() );
    emit putScore( scoreStr );
    emit putShips( shipsStr );
    emit putState( (gameState == GAME_NO_GAME)?"Not running":
                   (gameState == GAME_RUNNING)?"running":
                   (gameState == GAME_PAUSED)?"paused": " ");
    break;
  case SHIPS:
    sprintf( shipsStr, "%2d", playerShipsList.count() );
    emit putShips( shipsStr );
    break;
  case SCORE:
    sprintf( scoreStr, "%5ld", gameScore );
    emit putScore( scoreStr );
    break;
  case STATE:
    emit putState( (gameState == GAME_NO_GAME)?"Not running":
                   (gameState == GAME_RUNNING)?"running":
                   (gameState == GAME_PAUSED)?"paused": " ");
    break;
  } 
  dprintf( "END::()\n");
}


//           
//      Name:  kalaxGame::startLevel
//
//   Comment:  stop game timer; show level nr; build level; start game timer;
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::startLevel( unsigned int levelNr )
{
  QPoint startPos;
  unsigned int enemyType;
  int i, n;
  dprintf( "START::(%d)\n", levelNr );

  n=levelFileNames.count();
  printf( "read %d level filenames\n", n );

  // Stop the Game
  if ( gameState != GAME_PAUSED )
  {
    pauseGame();
  }

  if ( level != NULL )
  {
    delete level;
    level = NULL;
  }

  if (  levelFileNames.count() >= levelNr )
  {
    n=0;
    // Listrenage from 0..list.count()-1
    level = new Level( levelFileNames.at( levelNr-1 ));
    while ( (i=level->getEnemy( n, startPos, enemyType )) == 0 )
    {
      if ( enemyTypesList.count() >= enemyType )
      {
        if ( startPos.x() > FIELD_WIDTH || startPos.x() < 0 ||
             startPos.y() > FIELD_HEIGHT || startPos.y() < ENEMY_T_BOUND )
        {
          fprintf( stderr, "kalax:startLevel(%d): enemy position out of bounds\n", levelNr );  
        }
        else
        {
          Enemy *enemyIns= new Enemy( startPos, enemyTypesList.at( enemyType ) , defaultPlan );
          enemyIns->setVelocity( kalaxOptions->spriteStepEnemy );
          enemyList.append (enemyIns );
          n++;
        }
      }
      else
      {
        // unknown enemytype
      }
    }
  }


  // Start the Game
  if ( gameState == GAME_PAUSED )
  {
    pauseGame();
  }

  if ( level != NULL )
  {
    char levelNumber[12];
    sprintf( levelNumber, "%d", level->getLevelNr());
    statusDisplaySprite->setLevel( levelNumber );
    // show the level nr
    //   QwTextSprite levelNrSpr( levelNumber );
    //   levelNrSpr.setFont( QFont( "Courier", 16 ) );
    //   levelNrSpr.moveTo( 70, 400 );    
    //   QApplication::syncX ();
    //   sleep( 3 );
  }
  else
  {
    endGame();
  }
  dprintf( "END::()\n");
}


//
//      Name:  kalaxGame::collision
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
bool kalaxGame::collision(QwMobileSprite *sp1, QwMobileSprite *sp2)
{
  QRect s1,s2;
  bool retValue;
  dprintf( "START::()\n");
  if ( sp1 == NULL || sp2 == NULL )
  {
    retValue = false;
  }
  else
  {
    s1=QRect( sp1->x(), sp1->y(), sp1->width(), sp1->height() );
    s2=QRect( sp2->x(), sp2->y(), sp2->width(), sp2->height() );
    retValue = s1.intersects( s2 );
  }
  dprintf( "END::()=>%s<\n", ( retValue == true )?"TRUE":"FALSE" );
  return( retValue );
}



//    
//      Name:  kalaxGame::playerHit 
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::playerHit( playerShip *playerSp )
{
  dprintf( "START::()\n");
  playerShipsList.removeRef( playerSp );  
  if ( playerShipsList.isEmpty() )
  {
    player=0L;
   // endGame();
  }
  else
  {
    player=playerShipsList.first();
    player->movePlayer( 320, Bottom );
  }
  doSound( RDESTROY_SOUND );

  dprintf( "END::()\n");
}

//             
//      Name:  kalaxGame::enemyHit
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::enemyHit( QwMobileSprite *enemySp )
{
  dprintf( "START::()\n");
  if ( ((Enemy *)enemySp)->enemyFlys == true ) 
    gameScore += 80;
  else
    gameScore += 60;

  enemyList.removeRef( (const Enemy *)enemySp );      
  doSound( EDESTROY_SOUND );
  dprintf( "END::()\n");
}


//
//      Name:  kalaxGame::doSound
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxGame::doSound( int soundIdx )
{
  QString soundFile;

  dprintf( "START::()\n");
  if ( playSound->serverStatus() == 0 ){
    playSound->stop();
    switch ( soundIdx ){ 
        case EDESTROY_SOUND:  playSound->play( soundEdestroy ); break;
        case RDESTROY_SOUND:  playSound->play( soundRdestroy ); break;
        case ESHOOT_SOUND:  playSound->play( soundEshoot ); break;
        case RSHOOT_SOUND:  playSound->play( soundRshoot ); break;
        default:
           fprintf( stderr, "programming error: kalaxGame::doSound( %d ) with wrong param.\n", soundIdx );
        break;
    }
    //  playSound->sync();
  }

  dprintf( "END::()\n");
}

























