/*
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "config.h"
#include "enemy.h"
#include "DebugInfo.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

//
//      Name:  flightPlan::flightPlan
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
flightPlan::flightPlan()
{
  dprintf( "START::()\n");
  
  flightCoords = QPointArray(0);
  frameNumbers = QPointArray(0);
  dprintf( "END::()\n");
}

//
//      Name:  flightPlan::flightPlan
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
flightPlan::~flightPlan()
{
  dprintf( "START::()\n");
  
  dprintf( "END::()\n");
}

//    
//      Name:  flightPlan::addPlanEntry
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue: insert position
//
//    Extern:
//
int flightPlan::addPlanEntry( QPoint p, int frame)
{
  int retValue;
  int arrSize;
  dprintf( "START::()\n");
  
  arrSize =  flightCoords.size();
  flightCoords.resize( arrSize + 1 );
  flightCoords.setPoint ( arrSize, p );
    
  frameNumbers.resize( arrSize + 1 );
  frameNumbers.setPoint ( arrSize, QPoint( frame, 0 ) );
  
  retValue = arrSize;
  dprintf( "END::()=>%d<\n", retValue );
  return ( retValue );
}

//
//      Name:  flightPlan::getPlanEntry
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
int flightPlan::getPlanEntry( int planEntry, int &x, int &y, int &frame )
{
  int retValue=0;
  int arrSize;
  
  dprintf( "START::(>%d<, ...)\n", planEntry );
  arrSize = flightCoords.size();
  if (  arrSize <= planEntry )
  {
    x = flightCoords[0].x();
    y = flightCoords[0].y();   
    frame = frameNumbers[0].x();
    retValue = -1;
  }
  else
  {
    x = flightCoords[ planEntry ].x();
    y = flightCoords[ planEntry ].y();   
    frame = frameNumbers[ planEntry ].x();
    retValue = 0;
  }
  dprintf( "END::()=>%d< p.x>%d<, p.y=>%d< f=>%d<\n",retValue, x, y, frame );
  
  return( retValue );
}

    
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------


//
//      Name:  Enemy
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
Enemy::Enemy( QPoint startPos, EnemyType *enemyType, flightPlan *defaultFlightPlan )
      :QwMobileSprite( )
{
  dprintf( "START::()\n");
  //dassert( enemyType != NULL );
  //dassert( defaultFlightPlan != NULL );
  
  enemySpeed = 2;
   setSequence( enemyType );
  bounds( ENEMY_L_BOUND, ENEMY_T_BOUND, ENEMY_R_BOUND, ENEMY_B_BOUND );
  setBoundsAction( Ignore );
  
  defaultPlan = defaultFlightPlan;           
  defaultPos=startPos;  
  defaultPlanEntry = 0; 
  
  specFlightPlan = NULL; 
  flightPlanEntry = 0;

  enemyFlys = FALSE;

  moveTo( startPos.x(), startPos.y(), 0 );
  
  dprintf( "END::()\n");
}


//
//      Name:  Enemy
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
Enemy::~Enemy( )
{
  dprintf( "START::()\n");
  hide();
  dprintf( "END::()\n");
}


//
//      Name:  Enemy::setVelocity
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void Enemy::setVelocity( int velocity )
{
  dprintf( "START::()\n");
  enemySpeed = velocity;
  dprintf( "END::()\n");
}


//
//      Name:  Enemy::specialFlightPlan
//
//   Comment: set the plan, it will be steped once and then
//            it is automaticly dropped
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void Enemy::specialFlightPlan( flightPlan *flightThis )
{
  dprintf( "START::()\n");
  
  if ( specFlightPlan == NULL )
  {
    specFlightPlan = flightThis; 
    flightPlanEntry = 0;
    defaultPos=QPoint( x(), y() ); // save current position
    enemyFlys = TRUE;
  }
  dprintf( "END::()\n");
}


//
//      Name:  Enemy::nextStep
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void Enemy::nextStep( )
{
  int xp,yp,frame=0;
  int planEntryNr;
  dprintf( "START::()\n");
 
  
  if ( specFlightPlan != NULL )
  {
    if ( outOfBounds() == true )
    {
      specFlightPlan = NULL;
      moveTo( defaultPos.x(), defaultPos.y(), frame); // back to default position
    }
    else
    {
      planEntryNr = specFlightPlan->getPlanEntry( flightPlanEntry, xp, yp, frame );
      flightPlanEntry++;    
#if 0
      if ( planEntryNr < 0 )
      { // clear plan
        flightPlanEntry = 0;
        specFlightPlan = NULL;
        moveTo( defaultPos.x(), defaultPos.y(), frame); // back to default position
      }
#else           
      if ( planEntryNr < 0 )
      { // fly last entry untiol out of bounds
        flightPlanEntry -=2;
        planEntryNr = specFlightPlan->getPlanEntry( flightPlanEntry, xp, yp, frame );       
      }
#endif      
#if 0
      else
      {
#endif        
        QwMobileSprite::setVelocity( xp, yp );
        forward( enemySpeed,  frame ); 
#if 0
      }
#endif    
    }// else ... if ( outOfBounds() == true )
  }

  if ( specFlightPlan == NULL )
  { 
    enemyFlys = FALSE;
    planEntryNr = defaultPlan->getPlanEntry( defaultPlanEntry, xp, yp, frame );
    defaultPlanEntry++;
    
    if ( planEntryNr < 0 )
      defaultPlanEntry = 1;      // Entry 0 just got     
    defaultPos=QPoint( defaultPos.x()+xp, defaultPos.y()+yp ); 
    QwMobileSprite::setVelocity( xp, yp ); 
    forward( enemySpeed,  frame ); 
  }
  else
  { // get default-coords and save them
    int xx, yy, ff;
    planEntryNr = defaultPlan->getPlanEntry( defaultPlanEntry, xx, yy, ff );
    defaultPlanEntry++;
    if ( planEntryNr < 0 )
      defaultPlanEntry = 1; 
    defaultPos=QPoint( defaultPos.x()+xx, defaultPos.y()+yy );        
  }

    
  dprintf( "END::()\n");
}




