/***************************************************************************
                          cursor.h  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CURSOR_H
#define CURSOR_H

#include "globals.h"

#include <stdlib.h>

/** The cursor for gameplay.
  * Implements a 3x3 block with 8 digits and a boolean operator (and, or, xor, rnd).
  * rnd should be expanded to the other three operators.
  * @author Ralf-Christian Juergensen
  */
class Cursor
{
public:
    /** Constructor */
    Cursor (int xInit = 0, int yInit = 0)
    {
        set(xInit, yInit);
        init();
    }
		
    /** Generate new digits and a new operator. */
    void init(void)
    {
        // generate type (AND, OR, XOR, RND)
        type = Type(4.0 * rand() / (RAND_MAX + 1.0));
        
        // generate 8 digits (OFF, ON)
        for(int i = 0; i < 8; i++)
        {
            bits[i] = int(2.0 * rand() / (RAND_MAX + 1.0));
        }
    }

    /** Set to new position. */    		
    void set(int xSet = 0, int ySet = 0)
    {
        x = xSet;
        y = ySet;
    }
    		
    /** Get digit value 0-7. Throws an exception (char*) if the index is out of range. */
    bool getBit (int bitNo)
    {
        if((bitNo >= 0) && (bitNo <= 7))
        {
            return bits[bitNo];
        }
        else
        {
            throw "bool Cursor::getBit(int): Index out of range.";
        }
    }
    		
    Type getType (void)
    {
        return type;
    }
    		
    int getXPos (void)
    {
        return x;
    }
    		
    int getYPos (void)
    {
        return y;
    }
    		
    int goLeft (int steps = 1)
    {
        return x -= steps;
    }
    		
    int goRight (int steps = 1)
    {
        return x += steps;
    }
    		
    int goUp (int steps = 1)
    {
        return y -= steps;
    }
    		
    int goDown (int steps = 1)
    {
        return y += steps;
    }
               
private:
    bool bits[8];
    Type type;
    int x;
    int y;
};

#endif // CURSOR_H
