/* -*- C++ -*- */

#ifndef _PERFORMGAMEPLAY_H_
#define _PERFORMGAMEPLAY_H_

#include "Obstacle.h"

/** Moves and inserts the figures in the obstacle and accumulates points.
 */
class PerformGamePlay
{
public:
	PerformGamePlay();
	~PerformGamePlay();

	/** Returns the point since last newGame() and current time. */
	int getPoints() const { return points; };

	/** Returns true if game ended because figure couldn't be moved. */
	int hasGameEnded() const { return gameEnded; };

	/** Display obstacle and figure. */
	void draw();

	/** Starts a new game, clears points and cubes. */
	void newGame();
	
	/** Sets new obstacle. */
	void setObstacle (Obstacle *_obstacle);

	/** Reads figures from file, returns false if error on file read. */
	static bool readFiguresFromFile (const char *filename);

	/** Rotation around the x-axis. direction==1 means clock wise. returns true
	 * if successfull. */
	bool rotateX (const int direction);
	/** Rotation around the y-axis. direction==1 means clock wise. */
	bool rotateY (const int direction);
	/** Rotation around the z-axis. direction==1 means clock wise. */
	bool rotateZ (const int direction);

	/** Moves figure relative with rel. */
	bool moveRel (const Position& rel);

	/** Moves figure one level to bottom if possible. If not, insert it to
	 * obstacle and create new figure.
	 *
	 * May be user initiated or automatically after time ends.
	 *
	 * @return true if figure was lowered, else false
	 * (and games has ended then).
	 */
	bool lowerFigureOneLevel();

	/** For increasing points for higher levels. 1 or greater. */
	void setTimeLevel (int _level);

	int getTimeLevel() const { return level; };
	/** Return delay time in ms. */
	int getDelayTime() const;
protected:

	/** Creates a new figure, deletes old one. */
	void createNewFigure();

	/** Contains all figures read from file. */
	static Figure **allFigures;
	/** Contains the number of figures read from file. */
	static int countAllFigures;

	int points;
	bool gameEnded;
	int level;
	
	Obstacle *obstacle;
	Figure *currentFigure;
};

#endif _PERFORMGAMEPLAY_H_
