/***************************************************************************
                                 KPackageViewer.h
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPackageViewer_included
#define KPackageViewer_included

#include <kwizard.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qlistbox.h>
#include <qframe.h>
#include <qstring.h>

class KPackageViewer : public KDialog
{
	Q_OBJECT
	public:
	KPackageViewer(QWidget* parent = NULL, const char* name = NULL);
	virtual ~KPackageViewer();

	protected slots:
	void closeButtonClickedCB();
	void packageListClickedCB(int);
	void bodyEditButtonClickedCB();
	void declEditButtonClickedCB();

	protected:
	QLabel*		packageListLabel;
	QListBox*	packageList;
	QFrame*		baseFrame;
	QLabel*		packageDeclLabel;
	QMultiLineEdit*	packageDeclMultiText;
	QLabel*		packageBodyLabel;
	QMultiLineEdit*	packageBodyMultiText;
	QPushButton*	closeButton;
	QPushButton*	declEditButton;
	QPushButton*	bodyEditButton;

	QString		packageDeclResultRaw;
	QString		packageBodyResultRaw;
	QString		selPackageName;
	int		selPackageIndex;
};

#endif // KPackageViewer_included
