/***************************************************************************
                                 KPackageEditor.h
                             -------------------
    begin                : 09.08.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPackageEditor_included
#define KPackageEditor_included

#include <kwizard.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>

class KPackageEditor : public KDialog
{
    Q_OBJECT

public:

    KPackageEditor
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~KPackageEditor();
    void setTitle(const QString& title);
    void setText(const QString& text);
    void setPackageInfo(int index, const QString& type)
    {
        packageIndex = index; packageType = type;
    }

public slots:


protected slots:

    virtual void compileButtonClickedCB();
    virtual void returnButtonClickedCB();

protected:
    QLabel* packageLabel;
    QMultiLineEdit* packageMultiText;
    QLabel* outputLabel;
    QMultiLineEdit* outputMultiText;
    QPushButton* compileButton;
    QPushButton* returnButton;
    int packageIndex;
    QString packageType;


};

#endif // KPackageEditor_included
