#include <qstring.h>
#include <qlist.h>
#include <kmsgbox.h>
#include <kapp.h>
#include <qmessagebox.h>

#include "modifytable.h"
#include "tabledescr.h"
#include "mysqlw.h"
#include "globals.h"
#include "compoundkeydlg.h"

#ifndef rcsid
static const char rcsid[]="$Id: modifytable.cpp,v 2.2 1999/08/07 19:33:12 ral Exp $";
const char*modifytable_rcs(){return rcsid;}
#endif

#define Inherited CCreateTableData

CModifyTable::CModifyTable( QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    int count;
    for (count = 0; count < CMySql::FieldDescriptCounts(); count++) {
	TypeComboList->insertItem(CMySql::FieldDescript(count));
    }
    EnumList->setInsertionPolicy(QComboBox::NoInsertion);
    QString Caption = ProgName;
    Caption+=" - ";
    Caption+=i18n("Create Table");
    setCaption(Caption);
    SetTypeInt(0);
    stringlist*db_list;
    CurrentTables.resize(0);
    if (sql_server) {
	db_list = sql_server->get_db_list("%");
	if (db_list) {
	    stringlist::iterator iter;
	    for (iter = db_list->begin();iter != db_list->end();++iter) {
		DBList->insertItem(iter->c_str());
	    }
	} else {
	    DBList->insertItem(i18n("No DBs found"));
	}
    } else {
	DBList->insertItem(i18n("Not connected"));
    }

    AddButton->setEnabled(FALSE);
    CreateTableButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    DeleteButton->setEnabled(FALSE);
    CompoundKeyButton->setEnabled(FALSE);
    Key_Name_Edit->setEnabled(false);
    ColumnNameEdit->setEnabled(false);

    stringlist*c_tables = sql_server->get_table_list("%",DBList->currentText());
    if (c_tables)
	CurrentTables = *c_tables;
}


CModifyTable::~CModifyTable()
{

}

void CModifyTable::SetFloat(int i)
{
    FloatDisplay->display(i);
}

void CModifyTable::Set_KeySize(int i)
{
    K_Size_Display->display(i);
}

void CModifyTable::SetDec(int i)
{
    DecDisplay->display(i);
    int Item = TypeComboList->currentItem();
    if (Item > 6 && Item < 10) {
	KeySizeSlider->setRange(1,i);
	K_Size_Display->display(KeySizeSlider->value());
    }
}

void CModifyTable::Set_AutoInc(bool how)
{
    if (how) {
	Primary_Key->setChecked(how);
	Key_None->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	MultiKey->setChecked(FALSE);
	Key_Name_Edit->setEnabled(how);
    }
}

void CModifyTable::Set_KeyNone(bool how)
{
    if (how) {
	AutoInc->setChecked(FALSE);
	Key_Name_Edit->setEnabled(FALSE);
	KeySizeSlider->setEnabled(FALSE);
	UniqueKey->setChecked(FALSE);
	MultiKey->setChecked(FALSE);
	Primary_Key->setChecked(FALSE);
    }
}

void CModifyTable::SetKey(bool how)
{
    Key_Name_Edit->setEnabled(how);
    int Item = TypeComboList->currentItem();
    if (Item > 6 && Item < 10) {
	KeySizeSlider->setRange(1,DecBar->value());
	K_Size_Display->display(KeySizeSlider->value());
	KeySizeSlider->setEnabled(how);
    }
}

void CModifyTable::Set_UniqueKey(bool how)
{
    if (how) {
	MultiKey->setChecked(FALSE);
	Primary_Key->setChecked(FALSE);
	Key_None->setChecked(FALSE);
    }
    SetKey(how);
}

void CModifyTable::Set_Primary_Key(bool how)
{
    if (how) {
	MultiKey->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	Key_None->setChecked(FALSE);
    }
    SetKey(how);
}

void CModifyTable::Set_MultiKey(bool how)
{
    if (how) {
	Primary_Key->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	Key_None->setChecked(FALSE);
    }
    SetKey(how);
}

void CModifyTable::SetTypeInt(int DataType)
{
    switch (DataType) {
    case 0:
	DecBar->setRange(1,3);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 1:
	DecBar->setRange(1,5);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 2:
	DecBar->setRange(1,8);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 3:
	DecBar->setRange(1,10);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 4:
	DecBar->setRange(1,20);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 5:
	DecBar->setRange(1,20);
	FloatBar->setRange(0,4);
	FloatBar->setEnabled(TRUE);
	break;
    case 6:
    case 7:
	DecBar->setRange(1,20);
	FloatBar->setRange(0,8);
	FloatBar->setEnabled(TRUE);
	break;
    case 10:
    case 11:
    case 12:
    case 13:
    case 20:
	DecBar->setRange(2,2);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 14:
	DecBar->setRange(1,14);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 15:
    case 16:
	DecBar->setRange(0,0);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 17:
    case 18:
	DecBar->setRange(1,80);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 19:
	DecBar->setRange(14,14);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    case 8:
    case 9:
    default:
	DecBar->setRange(1,255);
	FloatBar->setEnabled(FALSE);
	FloatBar->setRange(0,0);
	break;
    }
    switch(DataType) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 17:
	DefaultValueEdit->setEnabled(TRUE);
	break;
    default:
	DefaultValueEdit->setEnabled(FALSE);
	break;
    }
    if (DataType < 8) {
	AutoInc->setEnabled(TRUE);
	ZeroFill->setEnabled(TRUE);
    } else {
	AutoInc->setEnabled(FALSE);
	AutoInc->setChecked(FALSE);
	ZeroFill->setEnabled(FALSE);
	ZeroFill->setChecked(FALSE);
    }
    if (DataType < 5)
	Unsigned->setEnabled(TRUE);
    else {
	Unsigned->setEnabled(FALSE);
	Unsigned->setChecked(FALSE);
    }
    if (DataType==20 || (DataType > 9 && DataType < 14) ) {
	Key_None->setChecked(TRUE);
	Primary_Key->setChecked(FALSE);
	UniqueKey->setChecked(FALSE);
	MultiKey->setChecked(FALSE);
	Key_None->setEnabled(FALSE);
	Primary_Key->setEnabled(FALSE);
	UniqueKey->setEnabled(FALSE);
	MultiKey->setEnabled(FALSE);
    }
    else {
	Key_None->setEnabled(TRUE);
	Primary_Key->setEnabled(TRUE);
	UniqueKey->setEnabled(TRUE);
	MultiKey->setEnabled(TRUE);
    }
    if (DataType > 6 && DataType < 10) {
	KeySizeSlider->setRange(DecBar->minValue(),DecBar->value());
	//	KeySizeSlider->setEnabled(TRUE);
    } else {
	KeySizeSlider->setEnabled(FALSE);
    }
    SetFloat(FloatBar->value());
    SetDec(DecBar->value());
}

void CModifyTable::TableTextChanged(const char*text)
{
    bool how =  (text &&
		 strlen(text) &&
		 (CurrentTables.find(text) == 0) );
    ColumnNameEdit->setEnabled(how);
    AddButton->setEnabled( how && strlen(ColumnNameEdit->text()) );
}
 
void CModifyTable::TableTextActivate()
{
}

void CModifyTable::NameChanged(const char*text)
{
    bool how = ( text && strlen(text) );
    AddButton->setEnabled(how);
}

void CModifyTable::SetDBString(const char*text)
{
}

int CModifyTable::ReadDescriptor(CColumnDescriptor*col_target,QString*str_target,CKeyDescriptor*target_key)
{
    QString Entry = ColumnNameEdit->text();
    QString Helper;

    if (!col_target || !str_target || !target_key)
	return 0;

    Entry+= " ";

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    Desc.set_FieldType(TypeComboList->currentItem());
    
    Entry+=CMySql::TypeDescript(TypeComboList->currentItem());
    
    if (DecBar->value()) {
	Entry+="(";
	Helper.setNum(DecBar->value());
	Entry+=Helper;
	if (FloatBar->value()) {
	    Helper.setNum(FloatBar->value());
	    Entry+=",";
	    Entry+=Helper;
	}
	Entry+=")";
    }
    if ( (TypeComboList->currentItem() > 9 && TypeComboList->currentItem() < 17) ||
	 TypeComboList->currentItem() == 19) {
	Desc.set_MaxLength(0);
    } else {
	Desc.set_MaxLength(DecBar->value());
    }
    Desc.set_MaxDecimals(FloatBar->value());
    if (Unsigned->isChecked() && Unsigned->isEnabled()) {
	Entry+=" UNSIGNED";
	Desc.set_Unsigned(Unsigned->isChecked());
    } else {
	Desc.set_Unsigned(0);
    }
    if (ValNotNull->isChecked()) {
	Entry+= " NOT NULL";
	Desc.set_NotNull(1);
	if (DefaultValueEdit->isEnabled() && strlen(DefaultValueEdit->text())) {
	    Entry+= " DEFAULT \"";
	    Entry+=DefaultValueEdit->text();
	    Entry+="\"";
	    Desc.set_default(DefaultValueEdit->text());
	}
    } else {
	Desc.set_NotNull(0);
    }
    // Autoincrement on?
    if (AutoInc->isEnabled() && AutoInc->isChecked()) {
	Entry+=" AUTO_INCREMENT";
	Desc.set_AutoIncrement(AutoInc->isChecked());
    } else {
	Desc.set_AutoIncrement(FALSE);
    }
    if (ZeroFill->isEnabled() && ZeroFill->isChecked()) {
	Entry+=" ZEROFILL";
	Desc.set_ZeroFill(true);
    } else {
	Desc.set_ZeroFill(false);
    }
    if (!Key_None->isChecked()) {
	CKeyDescriptor Key;
	Key.add_column_name(ColumnNameEdit->text());
	Helper=Key_Name_Edit->text();
	if (Helper.length() == 0) {
	    Helper = "Key_";
	    Helper+=ColumnNameEdit->text();
	}
	if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	    Helper="PRIMARY";
	    Entry+=" PRIMARY KEY";
	    Desc.set_KeyField(true);
	    Key.setType(CKeyDescriptor::PRIMARY);
	} else if (UniqueKey->isEnabled() && UniqueKey->isChecked()) {
	    Entry+=" UNIQUE";
	    Desc.set_KeyField(true);
	    Key.setType(CKeyDescriptor::UNIQUE);
	} else if (MultiKey->isEnabled() && MultiKey->isChecked()) {
	    Entry+=" MULTI";
	    Desc.set_KeyField(true);
	    Key.setType(CKeyDescriptor::INDEX);
	}
	Key.add_column_name(ColumnNameEdit->text());
	*target_key = Key;
	int Item = TypeComboList->currentItem();
	if (Item > 6 && Item < 10) {
	    Item = KeySizeSlider->value();
	    if (Item < DecBar->value()) {
		Helper.setNum(Item);
		Entry+="(";
		Entry+=Helper;
		Entry+=")";
	    }
	}
    }
    if (Desc.get_FieldType() == 17 || Desc.get_FieldType() == 18) {
	Desc.enum_list(enums);
    }
    *col_target = Desc;
    *str_target = Entry;
 
    return 1;
}

void CModifyTable::AddColumn()
{
    CKeyDescriptor Key;
    QString text;

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    if (desc_list.find(Desc)!=0) {
	QMessageBox::critical(this,i18n("Error inserting column"),
			      i18n("Enter another name for column!"));
	return;
    }
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	Key.set_name("PRIMARY");
	if (key_list.find(Key)) {
	    QMessageBox::critical(this,i18n("Error inserting column"),
				  i18n("There is already a primary key"));
	    return;
	}
    }
    if (!ReadDescriptor(&Desc,&text,&Key))
	return;

    ColumnsList->clearSelection();
    ColumnsList->insertItem(text,-1);
    DeleteButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    desc_list.push_back(Desc);
    CreateTableButton->setEnabled(TRUE);
    if (desc_list.size() > 1) {
	CompoundKeyButton->setEnabled(TRUE);
    }
    if (!Key_None->isChecked()) {
	key_list.push_back(Key);
    }
}

void CModifyTable::ColumnSelected(int Item)
{
    const char* ItemText = ColumnsList->text(Item);
    if (!ItemText)
	return;
    DeleteButton->setEnabled(TRUE);
    ModifyButton->setEnabled(TRUE);
    if (desc_list.size() <= (unsigned int)Item)
	return;
    ColumnNameEdit->setText(desc_list[Item].get_name());
    EnumList->clear();
    enums.clear();
    stringIlist e_list = desc_list[Item].enum_list();
    stringIlist::iterator iter = e_list.begin();
    enums = e_list;
    for (;iter!=e_list.end();++iter) {
	EnumList->insertItem(iter->c_str());
	if (iter == e_list.begin()) 
	    EnumList->setCurrentItem(0);
    }
    TypeComboList->setCurrentItem(desc_list[Item].get_FieldType());
    if (desc_list[Item].is_KeyField()) {
	
    }
}

void CModifyTable::Modify_Column()
{
    CKeyDescriptor Key;
    QString text;
    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());

    int i = ColumnsList->currentItem();
    if (i < 0)
	return;
    if (desc_list.size() <= (unsigned int)i)
	return;
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	Key.set_name("PRIMARY");
	KeyList_iterator iter = key_list.find(Key);
	if (iter) {
	    if (!iter->contains_column_name(desc_list[i].get_name())) {
		if (!iter->contains_column_name(desc_list[i].get_name())) {
		    QMessageBox::critical(this,i18n("Error modify column"),
					  i18n("There is already a primary key"));
		    return;
		}
	    }
	}
    }


    if (Desc != desc_list[i]) {
	// check for duplicates if name has changed
	if (desc_list.find(Desc)!=0) {
	    QMessageBox::critical(this,i18n("Error modify column"),
				  i18n("Enter another name for column!"));
	    return;
	}
	RemoveFromKey(desc_list[i].get_name(),true,Desc.get_name());
    }

    RemoveFromKey(desc_list[i].get_name());
    if (!ReadDescriptor(&Desc,&text,&Key))
	return;
    desc_list[i]=Desc;
    ColumnsList->changeItem(text,i);
    if (!Key_None->isChecked()) {
	key_list.push_back(Key);
    }
}

void CModifyTable::Delete_Column()
{
    int Index = ColumnsList->currentItem();
    int counter = 0;
    if (Index == -1) {
	debug("index -1");
	return;
    }
    CColumnDescriptor desc;
    desc = desc_list[Index];
    RemoveFromKey(desc.get_name());
    ColumnsList->removeItem(Index);
    counter = 0;
    for (ColumnList_iterator col_iter = desc_list.begin();col_iter != desc_list.end();++col_iter) {
	if (counter == Index) {
	    desc_list.erase(col_iter);
	    break;
	}
	++counter;
    }
    if (desc_list.size() < 2) {
	CompoundKeyButton->setEnabled(FALSE);
    }
    if (ColumnsList->count() == 0) {
	CreateTableButton->setEnabled(FALSE);
    }
    if (ColumnsList->currentItem() == -1 || ColumnsList->count() == 0) {
	DeleteButton->setEnabled(FALSE);
	ModifyButton->setEnabled(FALSE);
    }
}

void CModifyTable::Build_Compound()
{
    CCompoundKeyDlg dlg(this);
    dlg.set_Columns(&desc_list,&key_list);
    dlg.exec();
    RemoveFromKey(NULL,true);
}

void CModifyTable::AddEnum()
{
    if (enums.find(EnumList->currentText()))
	return;
    QString current = EnumList->currentText();
    EnumList->insertItem(current,0);
    enums.push_back(std::string(EnumList->currentText()));
}

void CModifyTable::DelEnum()
{
    if (EnumList->count() == 0)
	return;
    int i = EnumList->currentItem();
    stringIlist::iterator iter = enums.find(EnumList->currentText());
    if (iter)
	enums.erase(iter);
    if (i == -1)
	return;
    EnumList->removeItem(i);
}

void CModifyTable::RemoveFromKey(const char*col_name,bool compounds,const char*new_name)
{
    KeyList_iterator key_iterator;
    for (key_iterator = key_list.begin(); key_iterator != key_list.end();++key_iterator) {
	if (key_iterator->is_compound() == compounds) {
	    if (col_name) {
		key_iterator->remove_column_name(col_name);
		if (compounds && new_name) {
		    key_iterator->add_column_name(new_name);
		}
	    }
	    if (key_iterator->column_count() == 0) {
		key_iterator = key_list.erase(key_iterator);
		--key_iterator;
	    }
	}
    }
}
