/*
 * modify grants
 * this is realy mysql-stuff. other sql-servers have another
 * grant-table. Means - for another sql-server it should complete
 * rewritten.
 */ 

#include <qstring.h>
#include <qmsgbox.h>
#include <kwm.h>
#include <kapp.h>

#include "globals.h"
#include "granttable.h"
#include "grantedit.h"
#include "mysqlw.h"

#ifndef rcsid
static const char rcsid[]="$Id: granttable.cpp,v 2.5 1999/07/31 19:52:38 ral Exp $";
const char*granttable_rcs(){return rcsid;}
#endif

//strings, strings, strings....
const char* CGrantTable::DB_Name="mysql";
const char* CGrantTable::Host_Table="host";
const char* CGrantTable::User_Table="user";
const char* CGrantTable::DB_Table="db";
const char* CGrantTable::Pass_Entry="password";
const char* CGrantTable::Host_Title="Host:";

const char*CGrantTable::Se_Str="Select_priv";
const char*CGrantTable::In_Str="Insert_priv";
const char*CGrantTable::Up_Str="Update_priv";
const char*CGrantTable::De_Str="Delete_priv";
const char*CGrantTable::Cr_Str="Create_priv";
const char*CGrantTable::Dr_Str="Drop_priv";
const char*CGrantTable::Re_Str="Reload_priv";
const char*CGrantTable::Sh_Str="Shutdown_priv";
const char*CGrantTable::Pr_Str="Process_priv";
const char*CGrantTable::Fi_Str="File_priv";
const char*CGrantTable::No="N";

#define Inherited CGrantTableData

CGrantTable::CGrantTable(QWidget* parent,const char* name)
    :Inherited( parent, name )
{     
    QString caption;
	User_Title=i18n("User:");
	DB_Title=i18n("Database:");
	P_Title=i18n("Password:");
	P2_Title=i18n("Retype Pass:");

    caption = ProgName;
    caption += i18n(" - Edit grants");
    setCaption(caption);
    KWM::setIcon(winId(),kapp->getIcon());
    KWM::setMiniIcon(winId(),kapp->getMiniIcon());
    DisableButtons();
    ReadHostTable();
}

CGrantTable::~CGrantTable()
{
}

void CGrantTable::Refresh()
{
    ReadHostTable();
}

void CGrantTable::ReadHostTable()
{
    stringlist erg;
    int i = 0;
    HostList->clear();
    if (!sql_server)
	return;
    //    erg = new QStrList;
    //    erg->setAutoDelete(TRUE);
    erg.push_back(std::string(Host_Table));
    erg.push_back(std::string(DB_Table));
    i = sql_server->fetch_rows(DB_Name,Host_Table,Host_Table,&erg);
    if (erg.size() > 0 && i==0) {
	stringlist::iterator iter = erg.begin();
	for (;iter!=erg.end();++iter) {
	    HostList->insertItem(iter->c_str());
	}
	//	delete erg;
    }
    if (HostList->count() > 0 && i == 0)
	HostList->setCurrentItem(0);
    if (i == 0)
	AddHostButton->setEnabled(TRUE);
}

void CGrantTable::hosthilighted(int i)
{
    QString s = HostList->text(i);
    QString t;
    int j = s.find("\t");
    if (j > -1) {
	t = s.left(j);
	t = t.stripWhiteSpace();
	if (t == "%")
	    t = "%%";
    }
    else
	t = s;
    ReadUserTable(t);
    ModifyHostButton->setEnabled(TRUE);
    if (UserList->count() > 0)
	DelHostButton->setEnabled(FALSE);
    else
	DelHostButton->setEnabled(TRUE);
}

void CGrantTable::userhilighted(int i)
{
    QString s = UserList->text(i);
    QString t;
    int j = s.find("\t");
    if (j > -1) {
	t = s.left(j);
	s = s.mid(j+1,s.length());
	t = t.stripWhiteSpace();
	s = s.stripWhiteSpace();
	ReadDBTable(t,s);
    }
    ModifyUserButton->setEnabled(TRUE);
    if (DBList->count() == 0)
	DelUserButton->setEnabled(TRUE);
    else
	DelUserButton->setEnabled(FALSE);
}

void CGrantTable::show()
{
    QDialog::show();
}

void CGrantTable::ReadUserTable(const char*Host)
{
    stringlist erg ;
    PatternList Patterns;
    int i;

    UserList->clear();
    if (!Host || !sql_server)
	return;
    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    //    Patterns=new PatternList;
//    Patterns->setAutoDelete(TRUE);
    Patterns.push_back(CPatternPair(Host_Table,Host));
    i = sql_server->fetch_rows(DB_Name,User_Table,User_Table,&erg,0,0,&Patterns);

    if (erg.size()) {
	stringlist::iterator iter = erg.begin();
	for (;iter != erg.end();++iter) {
	    UserList->insertItem(iter->c_str());
	}
    }
    if (UserList->count()>0 && i == 0)
	UserList->setCurrentItem(0);
    else {
	ModifyUserButton->setEnabled(FALSE);
	DelUserButton->setEnabled(FALSE);
    }
    if (i == 0) 
	AddUserButton->setEnabled(TRUE);
    else
	AddUserButton->setEnabled(FALSE);
}

void CGrantTable::ReadDBTable(const char*Host,const char*User)
{
    stringlist erg;
    PatternList Patterns;
    
    int i;

    DBList->clear();
    if (!Host || !User || !sql_server)
	return;

    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    erg.push_back(DB_Table);

    Patterns.push_back(CPatternPair(Host_Table,Host));
    Patterns.push_back(CPatternPair(User_Table,User));

    i = sql_server->fetch_rows(DB_Name,DB_Table,DB_Table,&erg,0,0,&Patterns);
    if (erg.size()) {
	stringlist::iterator iter = erg.begin();
	for (;iter!=erg.end();++iter) {
	    DBList->insertItem(iter->c_str());
	}
	if (erg.size() > 0) {
	    DBList->setCurrentItem(0);
	}
	else {
	    ModifyDbButton->setEnabled(FALSE);
	    DelDbButton->setEnabled(FALSE);
	}
    }
    if (i == 0) 
	AddDbButton->setEnabled(TRUE);
    else
	AddDbButton->setEnabled(FALSE);
}

void CGrantTable::DisableButtons()
{
    AddUserButton->setEnabled(FALSE);
    ModifyUserButton->setEnabled(FALSE);
    DelUserButton->setEnabled(FALSE);
    AddHostButton->setEnabled(FALSE);
    ModifyHostButton->setEnabled(FALSE);
    DelHostButton->setEnabled(FALSE);
    AddDbButton->setEnabled(FALSE);
    ModifyDbButton->setEnabled(FALSE);
    DelDbButton->setEnabled(FALSE);
}

void CGrantTable::dbhighlighted(int)
{
    ModifyDbButton->setEnabled(TRUE);
    DelDbButton->setEnabled(TRUE);
}

void CGrantTable::ModifyHost()
{
    QString db = "";
    QString host = "";
    stringlist erg;
    PatternList*Patterns = 0;
    PatternList*modify = 0;
    
    CPatternPair pat2;
    CGrantEdit edit(this);
    edit.setCaption("Edit Host");
    int i = 0;

    append_Sel(&erg);

    Patterns = break_hoststring();
    if (Patterns == 0 || Patterns->size() < 2)
	return;

    pat2 = (*Patterns)[0];
    host = (*Patterns)[0].get_pattern();
    if (host == "%")
	(*Patterns)[0].set_pattern("%%");
    pat2 = (*Patterns)[1];
    db = (*Patterns)[1].get_pattern();
    if (db == "%")
	(*Patterns)[1].set_pattern("%%");
    
    i = sql_server->fetch_rows(DB_Name,Host_Table,0,&erg,0,0,Patterns);

    if (i == -1 || Patterns->size() == 0) {
	Error();
	delete Patterns;
	return;
    }
    Patterns->insert(Patterns->begin(),CPatternPair(DB_Table,db));
    Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,host));
    if (UserList->count() > 0)
	(*Patterns)[0].setIsNumeric(TRUE);
    erg.clear();
    erg.push_back(Host_Title);
    erg.push_back(DB_Title);
    edit.set_entries(Patterns,&erg);

    if (edit.exec()) {
	modify = edit.get_entries();
	if (modify && modify->size() > 0) {
	    Patterns->resize(0);
	    Patterns->push_back(CPatternPair(Host_Table,host));
	    Patterns->push_back(CPatternPair(DB_Table,db));
	    i = sql_server->update_row(DB_Name,Host_Table,modify,Patterns);
	    if (i < 0)
		Error();
	}
    }

    delete Patterns;
    if (modify)
	delete modify;
}

void CGrantTable::ModifyUser()
{
    QString Host = "";
    QString User = "";
    QString result;
    QString Old_Pass;
    QString p1,p2;
    stringlist erg;
    PatternList*Patterns = 0;
    PatternList*modify = 0;
    CPatternPair pat2;
    CGrantEdit edit(this);
    char*n_pass = 0;
    edit.setCaption(i18n("Edit User-Rights"));
    int i = 0;
    int j = 0;

    erg.push_back(Pass_Entry);

    append_Sel(&erg);
    erg.push_back(Re_Str);
    erg.push_back(Sh_Str);
    erg.push_back(Pr_Str);
    erg.push_back(Fi_Str);
    Patterns = break_userstring();
    if (Patterns == 0 || Patterns->size()<2)
	return;

    Host = (*Patterns)[0].get_pattern();
    User = (*Patterns)[1].get_pattern();

    i = sql_server->fetch_rows(DB_Name,User_Table,0,&erg,0,0,Patterns);
    if (i == -1 || Patterns->size() == 0) {
	Error();
	delete Patterns;
	return;
    }
    (*Patterns)[0].setIsPassword(TRUE);
    Old_Pass = (*Patterns)[0].get_pattern();
    std::string inhalt = (*Patterns)[0].get_pattern();
    Patterns->insert(Patterns->begin(),CPatternPair("pass2",inhalt));
    (*Patterns)[0].setIsPassword(TRUE);

    Patterns->insert(Patterns->begin(),CPatternPair(User_Table,User));
    (*Patterns)[0].setIsNumeric( (DBList->count() > 0) );
    
    Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,Host));
    (*Patterns)[0].setIsNumeric(TRUE);

    erg.clear();
    erg.push_back(Host_Title);
    erg.push_back(User_Title);
    erg.push_back(P_Title);
    erg.push_back(P2_Title);
    edit.set_entries(Patterns,&erg);
    erg.clear();
    j = DBList->count() > 0?0:1;
    if (edit.exec()) {
	modify = edit.get_entries();
	if (modify && modify->size()>0) {
	    p1 = (*modify)[j].get_pattern();
	    //	p1 = pat->get_pattern();
	    p2 = (*modify)[j+1].get_pattern();
	    //	p2 = pat->get_pattern();
	    if (p1 != p2) {
		pass_error();
	    } else {
		if (p1 == "")
		    Old_Pass = "";
		else if (p1 != Old_Pass) {
		    n_pass = sql_server->scramble_password(p1);
		    if (n_pass) {
			Old_Pass = n_pass;
			delete[]n_pass;
		    }
		}
		modify->erase(modify->begin());
		modify->erase(modify->begin());
		modify->insert(modify->begin(),CPatternPair(Pass_Entry,Old_Pass));
		Patterns->clear();
		Patterns->push_back(CPatternPair(Host_Table,Host));
		Patterns->push_back(CPatternPair(User_Table,User));
		i = sql_server->update_row(DB_Name,User_Table,modify,Patterns);
		if (i < 0)
		    Error();
	    }
	}
    }
    delete Patterns;
    if (modify)
	delete modify;
}

void CGrantTable::ModifyDb()
{
    QString hostentry = "";
    QString userentry = "";
    QString dbentry = "";

    stringlist erg;
    PatternList*Patterns = 0;
    PatternList*modify = 0;
    
    CGrantEdit edit(this);
    edit.setCaption(i18n("Edit DB-Rights"));
    
    int i = DBList->currentItem();
    int j = 0;
    if (i<0)
	return;
    dbentry = DBList->text(i);
    j = dbentry.find("\t");
    if (j < 0)
	return;

    append_Sel(&erg);

    Patterns = break_dbstring();
    if (Patterns == 0)
	return;

    /*    pat = Patterns->at(0);
	  hostentry = pat->get_pattern();*/
    hostentry = (*Patterns)[0].get_pattern();
    /*    pat = Patterns->at(1);
	  userentry = pat->get_pattern();*/
    userentry = (*Patterns)[1].get_pattern();
    /*    pat = Patterns->at(2);
	  dbentry = pat->get_pattern();*/
    dbentry = (*Patterns)[2].get_pattern();

    i = sql_server->fetch_rows(DB_Name,DB_Table,0,&erg,0,0,Patterns);

    if (i == -1 || Patterns->size() == 0) {
	Error();
	delete Patterns;
	return;
    }
    Patterns->insert(Patterns->begin(),CPatternPair(DB_Table,dbentry));
    Patterns->insert(Patterns->begin(),CPatternPair(User_Table,userentry));
    (*Patterns)[0].setIsNumeric(TRUE);
    Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,hostentry));
    (*Patterns)[0].setIsNumeric(TRUE);
    erg.clear();
    erg.push_back(Host_Title);
    erg.push_back(User_Title);
    erg.push_back(DB_Title);
    edit.set_entries(Patterns,&erg);

    if (edit.exec()) {
	modify = edit.get_entries();
	if (modify && modify->size() > 0) {
	    Patterns->clear();
	    Patterns->push_back(CPatternPair(Host_Table,hostentry));
	    Patterns->push_back(CPatternPair(User_Table,userentry));
	    Patterns->push_back(CPatternPair(DB_Table,dbentry));
	    i = sql_server->update_row(DB_Name,DB_Table,modify,Patterns);
	    if (i < 0)
		Error();
	}
    }
    delete Patterns;
    if (modify)
	delete modify;
}

void CGrantTable::append_Sel(stringlist*List)
{
    if (!List)
	return;
    List->push_back(Se_Str);
    List->push_back(In_Str);
    List->push_back(Up_Str);
    List->push_back(De_Str);
    List->push_back(Cr_Str);
    List->push_back(Dr_Str);
}

void CGrantTable::append_Add(PatternList*List)
{
    if (!List)
	return;
    List->push_back(CPatternPair(Se_Str,No));
    List->push_back(CPatternPair(In_Str,No));
    List->push_back(CPatternPair(Up_Str,No));
    List->push_back(CPatternPair(De_Str,No));
    List->push_back(CPatternPair(Cr_Str,No));
    List->push_back(CPatternPair(Dr_Str,No)); 
}

void CGrantTable::AddHost()
{
    PatternList*Patterns = 0;
    //    CPatternPair*pat = 0;
    stringlist erg;
    QString host = "";
    QString db = "";
    int i;
    CGrantEdit edit(this);
    Patterns=new PatternList;
    edit.setCaption(i18n("Add Host"));
    Patterns->push_back(CPatternPair(Host_Table,""));
    Patterns->push_back(CPatternPair(DB_Table,""));
    
    erg.push_back(Host_Title);
    erg.push_back(DB_Title);
    append_Add(Patterns);
    edit.set_entries(Patterns,&erg);
    delete Patterns; Patterns = 0;
    if (edit.exec()) {
	Patterns = edit.get_entries();
	//	pat = Patterns->first();
	host = Patterns->begin()->get_pattern();
	/*	pat = Patterns->at(1);
	db = pat->get_pattern();
	*/
	db = (*Patterns)[1].get_pattern();
	if (!db.isEmpty() && !host.isEmpty()) {
	    i = sql_server->insert_row(DB_Name,Host_Table,Patterns);
	    if (i < 0) {
		Error();
	    }
	    else {
		ReadHostTable();
	    }
	}
    }
    if (Patterns) {
	delete Patterns;
    }
}

void CGrantTable::AddUser()
{
    QString Host = "";
    char*n_pass = 0;
    PatternList*Patterns = 0;
    stringlist erg;

    CGrantEdit edit(this);
    QString p1, p2;
    int j = 0;
    int i = 0;
    edit.setCaption(i18n("Add User"));
    Patterns = break_hoststring();
    PatternList::iterator p_iter;
    if (Patterns == 0)
	return;
    (*Patterns)[0].setIsNumeric(TRUE);
    //    pat = Patterns->at(0);
    //    pat->setIsNumeric(TRUE);
    //    Host = pat->get_pattern();
    Host = (*Patterns)[0].get_pattern();
    p_iter = Patterns->begin();
    ++p_iter;
    Patterns->erase(p_iter);
    Patterns->push_back(CPatternPair(User_Table,""));
    /*
      pat = new CPatternPair("pass","");
      pat->setIsPassword(TRUE);
      Patterns->append(pat);
    */
    Patterns->push_back(CPatternPair("pass",""));
		PatternIterator p_iter2;
		p_iter2 = Patterns->end();
		--p_iter2;
    p_iter2->setIsPassword(TRUE);
    /*
      pat = new CPatternPair("pass2","");
      pat->setIsPassword(TRUE);
      Patterns->append(pat);
    */
    Patterns->push_back(CPatternPair("pass2",""));
		p_iter2 = Patterns->end();
		--p_iter2;
    p_iter2->setIsPassword(TRUE);

    append_Add(Patterns);
    Patterns->push_back(CPatternPair(Re_Str,No));
    Patterns->push_back(CPatternPair(Sh_Str,No));
    Patterns->push_back(CPatternPair(Pr_Str,No));
    Patterns->push_back(CPatternPair(Fi_Str,No)); 

    erg.push_back(Host_Title);
    erg.push_back(User_Title);
    erg.push_back(P_Title);
    erg.push_back(P2_Title);
    edit.set_entries(Patterns,&erg);
    erg.clear();
    delete Patterns; Patterns = 0;
    if (edit.exec()) {
	Patterns = edit.get_entries();
	//	pat = Patterns->at(0);
	p1 = (*Patterns)[0].get_pattern();
	if (p1.isEmpty()) {
	    user_error();
	} else {
	    //	pat = Patterns->at(1);
	    p1 = (*Patterns)[1].get_pattern();
	    //	pat = Patterns->at(2);
	    p2 = (*Patterns)[2].get_pattern();
	    if (p1 != p2) {
		pass_error();
	    } else {
		if (!p1.isEmpty()) {
		    n_pass = sql_server->scramble_password(p1);
		    p1 = n_pass;
		    delete [] n_pass;
		}
		p_iter = Patterns->begin();
		p_iter++;
		Patterns->erase(p_iter);
		p_iter = Patterns->begin();
		p_iter++;
		Patterns->erase(p_iter);
		Patterns->insert(Patterns->begin(),CPatternPair(Pass_Entry,p1));
		Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,Host));
		i = sql_server->insert_row(DB_Name,User_Table,Patterns);
		if (i < 0) {
		    Error();
		} else {
		    j = HostList->currentItem();
		    if (j > -1) {
			hosthilighted(j);
		    }
		}
	    }
	}
    }
    delete Patterns;
}

void CGrantTable::AddDb()
{
    int i = 0;
    int j = 0;
    QString Host = "";
    QString User = "";
    QString Title = i18n("Add Db to user ");
    stringlist titles;
    PatternList*Patterns;
    CGrantEdit edit(this);

    Patterns = break_userstring();
    if (Patterns == 0)
	return;

    /*
      pat = Patterns->at(0);
      Host = pat->get_pattern();
      pat->setIsNumeric(TRUE);
    */
    Host = (*Patterns)[0].get_pattern();
    (*Patterns)[0].setIsNumeric(TRUE);
    /*
      pat = Patterns->at(1);
      User = pat->get_pattern();
      pat->setIsNumeric(TRUE);
    */
    User = (*Patterns)[1].get_pattern();
    (*Patterns)[1].setIsNumeric(TRUE);
    Patterns->push_back(CPatternPair(DB_Table,""));
    append_Add(Patterns);
    Title+=User;
    edit.setCaption(Title);

    titles.push_back(Host_Title);
    titles.push_back(User_Title);
    titles.push_back(DB_Title);
    edit.set_entries(Patterns,&titles);
    
    delete Patterns; Patterns = 0;

    if (!edit.exec())
	return;
    Patterns = edit.get_entries();
    if (!Patterns)
	return;
    Patterns->insert(Patterns->begin(),CPatternPair(Host_Table,Host));
    Patterns->insert(Patterns->begin(),CPatternPair(User_Table,User));
    i = sql_server->insert_row(DB_Name,DB_Table,Patterns);
    if (i < 0) {
	Error();
    }
    else {
	j = UserList->currentItem();
	if (j > -1)
	    userhilighted(j);
    }
}

void CGrantTable::pass_error()
{
    QString msg = i18n("You had typed in different passwords");
    msg+=",\n";
    msg+=i18n("please try again");
    QMessageBox::warning(this,
			  i18n("Error with password"),
			  msg );
}

void CGrantTable::user_error()
{
    QMessageBox::warning(this,
			  i18n("Error with Username"),
			  i18n("You had not typed in a username"));
}

void CGrantTable::DeleteUser()
{
    if (DBList->count() != 0)
	return;
    PatternList*KeyList=0;

    int i = Ask_delete();
    if (i != QMessageBox::Yes)
	return;

    KeyList = break_userstring();
    if (!KeyList)
	return;

    i = sql_server->delete_row(DB_Name,User_Table,KeyList);

    delete KeyList;

    if (i < 0) {
	Error();
	return;
    }
    i = HostList->currentItem();
    if (i > -1)
	hosthilighted(i);
}

void CGrantTable::DeleteHost()
{
    if (UserList->count() != 0)
	return;
    PatternList*KeyList=0;
    int i = Ask_delete();
    if (i != QMessageBox::Yes)
	return;
    KeyList = break_hoststring();
    if (KeyList == 0)
	return;
    i = sql_server->delete_row(DB_Name, Host_Table, KeyList);
    delete KeyList;
    if (i < 0){
	Error();
	return;
    }
    ReadHostTable();
}

void CGrantTable::DeleteDb()
{
    int j = 0;
    PatternList*KeyList = 0;
    int i = Ask_delete();
    if (i != QMessageBox::Yes)
	return;
    KeyList = break_dbstring();
    if (KeyList == 0)
	return;
    i = sql_server->delete_row(DB_Name,DB_Table,KeyList);
    delete KeyList;
    if (i < 0) {
	Error();
	return;
    }
    j = UserList->currentItem();
    if (j > -1)
	userhilighted(j);
}

PatternList* CGrantTable::break_hoststring()
{
    PatternList*KeyList = 0;
    int j = HostList->currentItem();
    if (j < 0)
	return KeyList;
    QString db = HostList->text(j);
    j = db.find("\t");
    if (j < 0)
	return KeyList;
    QString Host = db.left(j);
    Host = Host.stripWhiteSpace();
    db = db.mid(j+1,db.length());
    db = db.stripWhiteSpace();
    
    KeyList = new PatternList;
    //    KeyList->setAutoDelete(TRUE);
    KeyList->push_back(CPatternPair(Host_Table,Host));
    KeyList->push_back(CPatternPair(DB_Table,db));
    
    return KeyList;
}

PatternList* CGrantTable::break_userstring()
{
    int j = UserList->currentItem();
    PatternList*KeyList = 0;
    if (j < 0)
	return KeyList;
    QString user = UserList->text(j);
    j = user.find("\t");
    if (j < 0)
	return KeyList;
    QString host = user.left(j);
    host = host.stripWhiteSpace();
    user = user.mid(j+1,user.length());
    user = user.stripWhiteSpace();

    KeyList = new PatternList;
    //    KeyList->setAutoDelete(TRUE);
    KeyList->push_back(CPatternPair(Host_Table,host));
    KeyList->push_back(CPatternPair(User_Table,user));

    return KeyList;
}

PatternList* CGrantTable::break_dbstring()
{
    int j = DBList->currentItem();
    PatternList*KeyList = 0;
    if (j < 0)
	return KeyList;
    QString db = DBList->text(j);
    j = db.find("\t");
    if (j < 0) 
	return KeyList;
    QString host = db.left(j);
    host = host.stripWhiteSpace();
    db = db.mid(j+1, db.length());
    j = db.find("\t");
    if (j < 0)
	return KeyList;
    QString user = db.left(j);
    user = user.stripWhiteSpace();
    db = db.mid(j+1, db.length());
    db = db.stripWhiteSpace();
    KeyList = new PatternList;
    //    KeyList->setAutoDelete(TRUE);
    KeyList->push_back(CPatternPair(Host_Table,host));
    KeyList->push_back(CPatternPair(User_Table,user));
    KeyList->push_back(CPatternPair(DB_Table,db));
    return KeyList;
}

int CGrantTable::Ask_delete()
{
    return QMessageBox::warning(this,"Delete Entry",
				"Do you realy want to delete this entry?",
				QMessageBox::Yes | QMessageBox::Default,
				QMessageBox::Abort | QMessageBox::Escape);
}

void CGrantTable::Error()
{
    display_error_box();
}

void CGrantTable::hostselected(int)
{
    ModifyHost();
}

void CGrantTable::userselected(int)
{
    ModifyUser();
}

void CGrantTable::dbselected(int)
{
    ModifyDb();
}
