//#define NO_CLIENT_LONG_LONG
#include "MySql.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <mysql_com.h>
#include <sys/time.h>
#include <unistd.h> 
#include <strstream>

#ifndef rcsid
static const char rcsid[]="$Id: MySql.cpp,v 2.8 1999/08/03 20:52:41 ral Exp $";
const char*mysql_rcs(){return rcsid;}
#endif

const char* CMySql::MessageArray[]={
    "row(s) affected",
    "row(s) found",
    "WHERE ",
    "No table given to work on"
};

int CMySql::MessageCount = 4;

const char* CMySql::DescriptArray[]={
    "TinyInt (1 Byte)",
    "SmallInt (2 Bytes)",
    "MediumInt (3 Bytes",
    "Int (4 Bytes)",
    "BigInt (8 Bytes)",
    "Float (4 Bytes)",
    "Double (8 Bytes)",
    "Decimal (lenght,dec)",
    "Char (1 <= num <=255",
    "Varchar (1 <= num <=255",
    "Tinyblob (num <= 255)",
    "Blob (num <= 65535)",
    "Mediumblob (num < 2^24)",
    "Longblob (num < 2^32)",
    "Timestamp (4 Bytes)",
    "Date (4 Bytes)",
    "Time (3 Bytes)",
    "Enum",
    "Set",
    "DateTime"
};

const char* CMySql::TypesArray[]= {
    "TINYINT",
    "SMALLINT",
    "MEDIUMINT",
    "INT",
    "BIGINT",
    "FLOAT",
    "REAL",
    "DECIMAL",
    "CHAR",
    "VARCHAR",
    "TINYBLOB",
    "BLOB",
    "MEDIUMBLOB",
    "LONGBLOB",
    "TIMESTAMP",
    "DATE",
    "TIME",
    "ENUM",
    "SET",
    "DATETIME"
};

    
int CMySql::FieldDescriptCounts()
{
    return 20;
}

const char* CMySql::FieldDescript(int i)
{
    if (i >= FieldDescriptCounts() || i < 0)
	return "";
    return DescriptArray[i];
}

const char* CMySql::TypeDescript(int i)
{
    if (i >= FieldDescriptCounts() || i < 0) 
	return "";
    return TypesArray[i];
}

void CMySql::sql_disconnect()
{
    nothing_else = 1;
    if (Sql_Connection) {
	mysql_close(Sql_Connection);
	delete Sql_Connection;
	Sql_Connection = 0L;
    }
    Server_MasterVersion = Server_MinorVersion = Server_PatchLevel = 0;
    nothing_else = 0;
}

CMySql::CMySql()
{
    Sql_Connection = 0L;
    nothing_else = 0;
    Server_MasterVersion = Server_MinorVersion = Server_PatchLevel = 0;
}

CMySql::~CMySql()
{
    sql_disconnect();
}

void CMySql::sql_connect(const char*host,const char*user,const char*pass,const char*port)
{
    int Port;
    nothing_else = 1;
    Port = atoi(port);
    sql_disconnect();
    char*s_version = NULL;
    char*help_ptr = NULL;
    Server_MasterVersion = Server_MinorVersion = Server_PatchLevel = 0;
    Sql_Connection = new MYSQL;
    if (!Sql_Connection)
	return;
#if MYSQL_VERSION_ID >= 32200
    Sql_Connection = mysql_init(Sql_Connection);
    Sql_Connection = mysql_real_connect(Sql_Connection,host,user,pass,(char*)0,(unsigned int)Port,(char*)0,0);
#else
    Sql_Connection = mysql_real_connect(Sql_Connection,host,user,pass,(unsigned int)Port,(char*)0,0);
#endif
    if (Sql_Connection) {
	do_message("Connected");
	s_version = mysql_get_server_info(Sql_Connection);
	if (s_version) {
	    Server_MasterVersion = atoi(s_version);
	    help_ptr = strstr(s_version,".");
	    if (help_ptr) {
		help_ptr = &help_ptr[1];
		Server_MinorVersion = atoi(help_ptr);
	    }
	    help_ptr = strstr(help_ptr,".");
	    if (help_ptr) {
		help_ptr = &help_ptr[1];
		Server_PatchLevel = atoi(help_ptr);
	    }
	}
    } else {
	do_message("Couldnt connect");
    }
    nothing_else = 0;
}

int CMySql::refresh_grants()
{
    return do_refresh(REFRESH_GRANT,"grants reloaded");
}

int CMySql::refresh_tables()
{
    return do_refresh(REFRESH_TABLES,"tables flushed");
}

int CMySql::refresh_cache()
{
    return do_refresh(REFRESH_HOSTS,"cache flushed");
}

int CMySql::refresh_log()
{
    return do_refresh(REFRESH_LOG,"new log started");
}

int CMySql::do_refresh(int What, const char*ok_msg)
{
    int i = 0;
    if (!Sql_Connection) {
	do_message("not connected");
	return -1;
    }
    i = mysql_refresh(Sql_Connection, What);
    if (i < 0)
	do_message(get_last_error());
    else
	do_message(ok_msg);
    return i;
}

char*CMySql::get_info()
{
    char*c_info;
    char*h_info;
    int p_info;
    char*s_info;
    char*all_info;
    char*t_1 = "Clientversion";
    if (nothing_else) {
	all_info = new char[1];
	strcpy(all_info,"");
    } else {
	if (Sql_Connection) {
	    c_info = mysql_get_client_info();
	    h_info = mysql_get_host_info(Sql_Connection);
	    p_info = mysql_get_proto_info(Sql_Connection);
	    s_info = mysql_get_server_info(Sql_Connection);
	    all_info = new char[strlen(c_info)+strlen(h_info)+strlen(s_info)+strlen(t_1)+50];
	    sprintf(all_info,
		    "%s\n%s %s\nProtokoll Version: %i\nServerversion: %s",
		    h_info,t_1,c_info,p_info,s_info);
	}
	else {
	    all_info = new char[19];
	    strcpy(all_info,"Couldn't get info");
	}
    }
    return all_info;
}

char*CMySql::get_status()
{
    char * Message;
    char * Fehler;
    if (nothing_else || !Sql_Connection)
	return 0;
    Message = mysql_stat(Sql_Connection);
    Fehler = get_last_error();
    if (Fehler[0] != 0)
	do_message(Fehler);
    return Message;
}

stringlist*CMySql::get_threads()
{
    stringlist*ResultList = 0;
    std::string result;
    MYSQL_RES*Res;
    MYSQL_ROW row;
    if (!Sql_Connection || nothing_else)
	return ResultList;
    Res=mysql_list_processes(Sql_Connection);
    const char*st;
    st = mysql_error(Sql_Connection);
    if (st[0] != 0) {
	do_message(st);
    }
    if (!Res)
	return ResultList;
    ResultList = new stringlist;
    result = "";
    while ((row=mysql_fetch_row(Res))) {
	for (unsigned int i = 0;i < mysql_num_fields(Res);++i) {
	    result+=row[i]?row[i]:"";
	    if(i < mysql_num_fields(Res) - 1)
		result+="\t";
	}
	ResultList->push_back(result);
	result = "";
    }
    mysql_free_result(Res);
    return ResultList;
}

/*
 * retrieves the list of databases in the current
 * connected server
 */
stringlist*CMySql::get_db_list(const char*pattern)
{
    stringlist*ResultList = 0;
    std::string result;
    
    MYSQL_RES*Res;
    MYSQL_ROW row;
    if (!Sql_Connection || nothing_else)
	return ResultList;
    Res=mysql_list_dbs(Sql_Connection,pattern);
    const char*st;
    st = mysql_error(Sql_Connection);
    if (st[0] != 0) {
	do_message(st);
    }
    if (!Res)
	return ResultList;
    ResultList = new stringlist;
    while ((row=mysql_fetch_row(Res))) {
	for (unsigned int i = 0;i < mysql_num_fields(Res);i++) {
	    result+=row[i]?row[i]:" ";
	    if(i < mysql_num_fields(Res) - 1)
		result+="\t";
	}
	ResultList->push_back(result);
	result = "";
    }
    mysql_free_result(Res);
    return ResultList;    
}

/*
 * fetches the tables of a database
 */
stringlist*CMySql::get_table_list(const char*pattern,const char*db)
{
    stringlist*ResultList = 0;
    string s;
    MYSQL_RES*Res;
    MYSQL_ROW row;
    if (!Sql_Connection || nothing_else || db==0)
	return ResultList;
    if (connect_db(db) < 0)
	return 0;
    const char*st;
    Res = mysql_list_tables(Sql_Connection,pattern);
    st = mysql_error(Sql_Connection);
    if (st[0] != 0) {
	do_message(st);
    }
    if (!Res)
	return ResultList;
    ResultList = new stringlist;
    while ((row=mysql_fetch_row(Res))) {
	for (unsigned int i = 0;i < mysql_num_fields(Res);i++) {
	    s+=row[i]?row[i]:"";
	    if(i < mysql_num_fields(Res) - 1)
		s+="\t";
	}
	ResultList->push_back(s);
	s = "";
    }
    mysql_free_result(Res);
    return ResultList;
}

/*
 * get the columns of a table
 */
ColumnList*CMySql::get_table_fields(const char*db,const char*table)
{
    ColumnList*ResultList;
    
    MYSQL_RES*Res;
    MYSQL_FIELD*Field;
    CColumnDescriptor entry;
    int j;
    Field = 0;
    ResultList = 0;
    if (!Sql_Connection || nothing_else || db==0 || table==0)
	return ResultList;
    j = connect_db(db);
    if (j < 0) {
	return 0;
    }
    Res = mysql_list_fields(Sql_Connection,table,"%");
    if (Res == 0) {
	do_message(get_last_error());
	return 0;
    }
    ResultList = new ColumnList;
    if (!ResultList) {
	do_message("Error allocating memory");
	return 0;
    }
    for (unsigned i=0;i<Res->field_count;i++) {
	Field = 0;
	Res->current_field = i;
	Field = mysql_fetch_field(Res);
	if (Field == 0) {
	    do_message(get_last_error());
	    return 0;
	}
	entry.set_name((const char*)Field->name);
	entry.set_table((const char*)Field->table);
	entry.set_default((const char*)Field->def);
	entry.set_Numeric(IS_NUM(Field->type));
	entry.set_AutoIncrement(Field->flags & AUTO_INCREMENT_FLAG);
	entry.set_KeyField(IS_PRI_KEY(Field->flags));
	//||
	//			     (Field->flags & UNIQUE_KEY_FLAG) );
	entry.set_Unique(Field->flags & UNIQUE_KEY_FLAG);
	entry.set_PartOfMultiKey(Field->flags & MULTIPLE_KEY_FLAG);
	entry.set_Binary(Field->flags & BINARY_FLAG);
	entry.set_TimeStamp(Field->flags & TIMESTAMP_FLAG);
	entry.set_ZeroFill(Field->flags & ZEROFILL_FLAG);
	entry.set_NotNull(IS_NOT_NULL(Field->flags));
	entry.set_Blob(IS_BLOB(Field->flags));
	ResultList->push_back(entry);
    }
    mysql_free_result(Res);
    return ResultList;
}

int CMySql::kill_thread(unsigned long pid)
{
    int i;
    if (!Sql_Connection)
	return -1;
    i = mysql_kill(Sql_Connection,pid);
    if (i < 0)
	do_message(get_last_error());
    return i;
}


char*CMySql::get_last_error()
{
    if (!Sql_Connection)
	return "No connection";
    return mysql_error(Sql_Connection);
}

/*
 * inserts a new database
 */
int CMySql::create_db(const char*db)
{
    int i = 0;
    const char*f;
    if (!db || !Sql_Connection || nothing_else)
	return -1;
    i = mysql_create_db(Sql_Connection,db);
    f = get_last_error();
    if (i != 0) {
	do_message(f);
	return i;
    }
    return i;
}

int CMySql::create_table(const char*db,const char*name,ColumnList*columns,KeyList*keys)
{
    std::string statement;
    ColumnList_iterator desc = NULL;
    KeyList_iterator key = NULL;
    unsigned int count = 0;
    std::string Type;
    char buffer[128];
    memset(buffer,0,128);
    if (!name || strlen(name) == 0) {
	do_message(MessageArray[3]);
	return -1;
    }
    if (!columns || columns->size() == 0){
	do_message("Wich columns should I create?");
	return -1;
    }
    if (!Sql_Connection) {
	do_message("Not connected");
	return -1;
    }
    if (connect_db(db)!=0) {
	do_message("Could not connect to database");
	return -1;
    }
    statement = "CREATE TABLE ";
    statement+= name;
    statement+=" (";
    for (desc = columns->begin(); desc != columns->end(); ++desc) {
	if (desc != columns->begin()) {
	    statement+=", ";
	}
	count++;
	statement+=desc->get_name();
	statement+=" ";
	Type = TypeDescript(desc->get_FieldType());
	if (Type.length() ==  0) {
	    do_message("Unknown fieldtype");
	    return -1;
	}
	//special cases for enums and sets
	
	if (desc->get_FieldType() == 17 || desc->get_FieldType() == 18) {
	    stringIlist current_enums;
	    current_enums = desc->enum_list();
	    if (current_enums.size() == 0) {
		do_message("Empty SETs/ENUMs are not allowed!");
		return -1;
	    }
	    unsigned int max_enum = 64;
	    if (desc->get_FieldType()==17) {
		max_enum = 65535;
	    }
	    if (current_enums.size() > max_enum) {
		sprintf(buffer,"More than %u %ss are not allowed",max_enum,max_enum==64?"SET":"ENUM");
		do_message(buffer);
		return -1;
	    }
	    Type+="(";
	    for (max_enum=0;max_enum<current_enums.size();++max_enum) {
		if (max_enum)
		    Type+=",";
		Type+="'";
		Type+=current_enums[max_enum];
		Type+="'";
	    }
	    Type+=")";
	}
	statement+=Type;
	statement+=" ";
	if (desc->get_MaxLength()>0 && desc->get_FieldType() != 17 && desc->get_FieldType() != 18) {
	    char buffer[10];
	    statement+="(";
	    sprintf(buffer,"%i",desc->get_MaxLength());
	    //	    Type = Type.setNum(desc->get_MaxLength());
	    statement+=buffer;
	    
	    if (desc->get_MaxDecimals() > 0) {
		sprintf(buffer,"%i",desc->get_MaxDecimals());
		statement+=", ";
		statement+=buffer;
	    }
	    statement+=") ";
	}
	if (desc->is_Unsigned())
	    statement+="UNSIGNED ";
	if (desc->is_ZeroFill())
	    statement+="ZEROFILL ";
	if (desc->is_NotNull()) {
	    statement+="NOT NULL ";
	    if (desc->get_default() && strlen(desc->get_default())>0) {
		statement+="DEFAULT '";
		statement+=desc->get_default();
		statement+="' ";
	    }
	}
	if (desc->is_AutoIncrement())
	    statement+="AUTO_INCREMENT ";
    }
    if (keys) {
	int already_prim = 0;
	stringIlist col_list;

	int f_count = 0;
	for (key = keys->begin(); key != keys->end(); ++key) {
	    f_count = 0;
	    statement+=", ";
	    switch(key->getType()) {
	    case CKeyDescriptor::PRIMARY:
		if (!already_prim) {
		    statement+="PRIMARY KEY ";
		    already_prim = 1;
		} else {
		    statement+="UNIQUE ";
		    key->setType(CKeyDescriptor::UNIQUE);
		}
		break;
	    case CKeyDescriptor::UNIQUE:
		statement+="UNIQUE ";
		break;
	    case CKeyDescriptor::INDEX:
		statement+="INDEX ";
		break;
	    default:
		continue;
	    }
	    if (key->getType() != CKeyDescriptor::PRIMARY) {
		statement+=key->get_name();
	    }
	    col_list = key->get_ColList();
	    if (col_list.size() == 0)
		continue;
	    statement+="( ";
	    stringIlist::iterator iter;
	    iter = col_list.begin();
	    for (;iter!=col_list.end();++iter) {
		if (f_count> 0)
		    statement+=",";
		++f_count;
		statement+=iter->c_str();
	    }
	    statement+=") ";
	}
    }
    statement+=" )";
    do_message(statement.c_str());
    int i = mysql_query(Sql_Connection,statement.c_str());
    if (i < 0) {//error??
	//why?
	do_message(get_last_error());
	return -1;
    }
    /*
    MYSQL_RES*Res = mysql_store_result(Sql_Connection);
    if (!Res) {
	//autch - this should never be...
	statement = mysql_error(Sql_Connection);
	if (!statement.isEmpty())
	    do_message(statement);
	else
	    do_message("Error fetch the result");
	return -1;
    }
    */
    return 0;
}

/*
 * Makes a simple search
 */
int CMySql::fetch_rows(const char*db,const char*table,const char*sort_by,
		       stringlist*which,unsigned int offset,unsigned int count,
		       PatternList*Pattern,stringlist*sizes)
{
    std::string query;
    std::string entry;
    MYSQL_RES*Res;
    MYSQL_ROW row;
    MYSQL_FIELD*Field;
    char buffer[512];
    //CPatternPair*patter;
    char*escaped;

    Field = 0;
    int i = 0;
    memset(buffer,0,512);
    unsigned int j;
    if (!which) {
	do_message("Which rows?");
	return -1;
    }
    if (!Sql_Connection) {
	do_message("Not connected");
	return -1;
    }
    if (!table || strlen(table) == 0) {
	do_message(MessageArray[3]);
	return -1;
    }
    i = connect_db(db);
    if (i < 0)
	return i;
    query = "";
    stringlist::iterator w_iter = which->begin();
    for (;w_iter!=which->end();++w_iter) {
	if (query.empty())
	    query = *w_iter;
	else {
	    query+=",";
	    query+=*w_iter;
	}
    }
    if (query.empty())
	query+="SELECT *";
    else
	query="SELECT " + query;
    query+=" FROM ";query+=table;query+=" ";
    PatternIterator p_iter;
    if (Pattern && Pattern->size()) {
	p_iter = Pattern->begin();
	//	patter = Pattern->first();
	query+=MessageArray[2];
	//	query+=" ";
	query+=p_iter->get_entry();query+=" LIKE \'";
	escaped = do_escape(p_iter->get_pattern());
	if (!escaped)
	    return -1;
	query+=escaped;
	delete[] escaped;
	query+="\' ";
	++p_iter;
	for (;p_iter != Pattern->end();++p_iter){
	    query+="AND ";query+=p_iter->get_entry();query+=" LIKE \'";
	    escaped = do_escape(p_iter->get_pattern());
	    if (!escaped)
		return -1;
	    query+=escaped;
	    delete[] escaped;
	    query+="\' ";
	}
    }
    if (sort_by) {
	query+="ORDER BY ";query+=sort_by;query+=" ";
    }
    if (count == 0)
	count = 99999;
    if (count > 0 || offset > 0) {
	std::string ls;
	std::string cs;
	if (offset > 0) {
	    sprintf(buffer,"LIMIT %u",offset);
	    ls = buffer;
	    memset(buffer,0,512);
	    if (count > 0) {
		ls+=",";
	    }
	    else
		ls+=",-1";
	}
	else {
	    ls = "LIMIT ";
	}
	if (count > 0) {
	    sprintf(buffer,"%u",count);
	    ls+=buffer;
	    memset(buffer,0,512);
	}
	query+=ls;
    }
    //we'll never need them again
    which->clear();
    if (Pattern) 
	Pattern->clear();
    //what is the resulting query?
    do_message(query.c_str());

    i = mysql_query(Sql_Connection,query.c_str());
    if (i < 0) {//error??
	//why?
	do_message(get_last_error());
	return -1;
    }

    Res = mysql_store_result(Sql_Connection);

    if (!Res) {
	//autch - this should never be...
	query = mysql_error(Sql_Connection);
	if (!query.empty())
	    do_message(query.c_str());
	else
	    do_message("Error fetch the result");
	return -1;
    }
    //what did the server found?
    
    unsigned long zaehler = Res->row_count;
    sprintf(buffer,"%lu %s",zaehler,MessageArray[1]);
    do_message(buffer);
    entry.resize(0);
    //    query.resize(0);
    //    bool first_run = true;
    while ((row=mysql_fetch_row(Res))) {
	for (j = 0;j < mysql_num_fields(Res);j++) {
	    query.resize(0);
	    query = row[j]?row[j]:"";
	    //how long is the longest?
	    Res->current_field = j;
	    Field = mysql_fetch_field(Res);
	    // we retrieve the first line splitted, for request, which will only need this line
	    // for instance a query to the user rights
	    if (which->size() == 0) {
		if (sizes) {
		    sprintf(buffer,"%i",Field->max_length);
		    sizes->push_back(std::string(buffer));
		}
		if ( Pattern ) {
		    Pattern->push_back(CPatternPair(Field->name,query));
		    // Field->max_length
		}
	    }
	    //ok - justify
	    
	    if (IS_NUM(Field->type)) {
		/*		int s_size = query.size();
		if (s_size < Field->max_length) {
		    query.insert(0,Field->max_length-s_size,' ');
		}
		*/
		while (query.size() < Field->max_length) {
		    query.insert(query.begin(),' ');
		}
	    }
	    /* else 
		if (j<mysql_num_fields(Res)-1)
		    query = query.leftJustify(Field->max_length,' ');
	    */
	    /*        //we don't like tabs...
		      query.replace(QRegExp("\\t"),"\\\\t");
	    */
	    if (query.size() == 0)
		query = " ";
	    if (j<mysql_num_fields(Res)-1)
		// its the simplest way to select datas - hope there is no tab in a field
		query+="\t";
	    entry+=query;
	    query = "";
	}
	//append to the list
	which->push_back(entry);
	entry = "";
    }
    mysql_free_result(Res);

    return 0;
}

/*
 * inserts a single row into a table
 */
int CMySql::insert_row(const char*db,const char*table, PatternList*Pattern)
{
    std::string query = "";
    std::string value_string = "";
    std::string row_string = "";
    char Buffer[256];
    //    CPatternPair*pat = 0;
    char*escaped;
    int i;
    if (!Sql_Connection) {
	do_message("Not connected");
	return -1;
    }
    if (Pattern == 0 || Pattern->empty()) {
	do_message("No data to insert");
	return -1;
    }
    if (table == 0 || strlen(table) == 0) {
	do_message(MessageArray[3]);
	return -1;
    }
    i = connect_db(db);
    if (i < 0)
	return i;
    //build the pattern-string
    PatternIterator p_iter;
    for (p_iter = Pattern->begin();p_iter!=Pattern->end();++p_iter){
	if (value_string.empty()) {
	    value_string = "\'";
	    escaped = do_escape(p_iter->get_pattern());
	    if (!escaped)
		return -1;
	    value_string += escaped;
	    delete[]escaped;
	    value_string+="\'";
	    row_string = p_iter->get_entry();
	}
	else {
	    value_string+=",\'";
	    escaped = do_escape(p_iter->get_pattern());
	    if (!escaped)
		return -1;
	    value_string+=escaped;
	    delete[]escaped;
	    value_string+="\'";
	    row_string+=",";row_string+=p_iter->get_entry();
	}
    }
    //build the complete query
    query = "INSERT INTO ";query+=table;query+=" (";query+=row_string;query+=") VALUES (";
    query+= value_string;query+=")";
    //send it to the protocoll
    do_message(query.c_str());
    //do it
    i = mysql_query(Sql_Connection,query.c_str());
    if (i == -1) {
	//if some goes wrong 
	query = mysql_error(Sql_Connection);
	do_message(query.c_str());
	return i;
    }
    //should be > 0 
    i = mysql_affected_rows(Sql_Connection);
    memset(Buffer,0,256);
    sprintf(Buffer,"%i %s",i,MessageArray[0]);
    //log it
    do_message(Buffer);
    return 0;
}

char*CMySql::do_escape(const char*what)
{
    char*of1;
    char*escaped = new char[strlen(what)*2+1];
    if (!what)
	return 0;
    if (!escaped) {
	do_message("Error allocating memory");
	return 0;
    }
    memset(escaped,'\0',strlen(what)*2+1);
    mysql_escape_string(escaped,what,strlen(what));
    of1 = strstr(escaped,"%%");
    while (of1) {
	of1[0] = '\\';
	//we don't hack "%%%" -> "\%\%" but -> "\%%"
	of1 = &of1[2];
	of1 = strstr(of1,"%%");
    }
    of1 = new char [strlen(escaped)+1];
    if (!of1) {
	do_message("Error allocating memory");
	return 0;
    }
    memset(of1,'\0',strlen(escaped)+1);
    strcpy(of1,escaped);
    delete[]escaped;
    return of1;
}

int CMySql::update_row(const char*db,const char*table,
		       PatternList*to_change,
		       PatternList*identifiers)
{
    std::string request;
    std::string clean;
    //    CPatternPair*pattern;
    int i;
    char Buffer[256];
    memset(Buffer,0,256);
    if (!Sql_Connection) {
	do_message("Not connected");
	return -1;
    }
    if (!table || strlen(table) == 0) {
	do_message(MessageArray[3]);
	return -1;
    }
    if (!to_change || to_change->size() == 0) {
	do_message("Nothing given to change");
	return -1;
    }
    i = connect_db(db);
    if (i < 0)
	return i;
    request = "UPDATE ";
    request += table;request+=" SET ";
    PatternIterator p_iter;
    for (p_iter = to_change->begin();p_iter != to_change->end();++p_iter) {
	if (p_iter != to_change->begin())
	    request+=",";
	request+=p_iter->get_entry();request+="=\'";
	clean = do_escape(p_iter->get_pattern());
	request+=clean;
	request+="\'";
    }
    request+=MessageArray[2];
    //    request+= " WHERE ";
    for (p_iter = identifiers->begin();p_iter != identifiers->end();++p_iter) {
	if (p_iter != identifiers->begin())
	    request += " AND ";
	request+=p_iter->get_entry();request+=" = \'";
	clean = do_escape(p_iter->get_pattern());
	request+=clean;
	request+="\'";
    }
    do_message(request.c_str());
    i = mysql_query(Sql_Connection,request.c_str());
    if (i == -1) {
	//if some goes wrong 
	do_message(get_last_error());
	return i;
    }
    //should be > 0 
    i = mysql_affected_rows(Sql_Connection);
    //    request.sprintf("%i row(s) affected",i);
    //log it
    sprintf(Buffer,"%i %s",i,MessageArray[0]);
    do_message(Buffer);
    return 0;
}

int CMySql::delete_row(const char*db,const char*table,
		       PatternList*identifiers=0)
{
    std::string query;
    char* clean;
    //    CPatternPair*pattern;
    int i;
    unsigned long zaehler;
    char buffer[512];
    memset(buffer,0,512);
    if (!Sql_Connection){
	do_message("not connected");
	return -1;
    }
    if (!table || strlen(table) == 0) {
	do_message(MessageArray[3]);
	return -1;
    }
    i = connect_db(db);
    if (i < 0)
	return i;
    query = "DELETE FROM ";
    query+= table;
    PatternIterator p_iter;
    if (identifiers && identifiers->size() > 0) {
	query+=" ";
	query+=MessageArray[2];
	for (p_iter=identifiers->begin();p_iter != identifiers->end();++p_iter) {
	    if (p_iter != identifiers->begin())
		query+=" AND ";
	    query+=p_iter->get_entry();query+=" = \'";
	    clean = do_escape(p_iter->get_pattern());
	    if (!clean) {
		do_message("error escaping strings");
		return -1;
	    }
	    query+=clean;
	    delete[]clean;
	    query+="\'";
	}    
    }
    do_message(query.c_str());
    i = mysql_query(Sql_Connection,query.c_str());
    if (i == -1) {
	//if some goes wrong 
	do_message(get_last_error());
	return i;
    }
    //should be > 0 
    zaehler = mysql_affected_rows(Sql_Connection);
    //log it
    sprintf(buffer,"%lu %s",zaehler,MessageArray[0]);
    do_message(buffer);
    return 0;
}

int CMySql::connect_db(const char*db)
{
    int i = 0;
    if (!Sql_Connection) {
	do_message("Not connected");
	return -1;
    }
    if (!db)
	return i;
    i = mysql_select_db(Sql_Connection,db);
    if (i < 0)
	do_message(get_last_error());
    return i;
}

char*CMySql::scramble_password(const char*pass)
{
    char*Buffer = new char[256];
    if (!Buffer)
	return Buffer;
    memset(Buffer,'\0',256);
    make_scrambled_password(Buffer,pass);
    return Buffer;
}

int CMySql::shutdown()
{
    int i;
    if (!Sql_Connection)
	return 0;
    i = mysql_shutdown(Sql_Connection);
    if (i < 0) {
	do_message(get_last_error());
    }
    return i;
}

int CMySql::delete_table(const char*db, const char*table)
{
    std::string query;
    char buffer[64];
    memset(buffer,0,64);
    if (!db || !table) {
	do_message("delete_table: To few parameters");
	return -1;
    }
    if (!Sql_Connection) {
	do_message("Not connected");
	return -1;
    }
    if (connect_db(db) < 0)
	return -1;
    query = "";
    query = "DROP TABLE ";
    query+= db;
    query+=".";
    query+= table;
    do_message(query.c_str());
    int i = mysql_query(Sql_Connection,query.c_str());
    if (i < 0) {
	do_message(get_last_error());
	return i;
    }
    unsigned long zaehler = mysql_affected_rows(Sql_Connection);
    sprintf(buffer,"%lu %s",zaehler,MessageArray[0]);
    //log it
    do_message(buffer);
    return 0;
}
