#include "MultiTextInput.h"
#include <qlabel.h>
#include <qstring.h>
#include <qkeycode.h>
#include <qmlined.h>

#ifndef rcsid
static const char rcsid[]="$Id: MultiTextInput.cpp,v 2.4 1999/07/30 00:30:34 ral Exp $";
const char*multitextinput_rcs(){return rcsid;}
#endif

#define Inherited CMultiTextInputData

CMultiTextInput::CMultiTextInput(QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    setCaption( "KMySQL - MultiWindow" );
    EditList = 0;
}


CMultiTextInput::~CMultiTextInput()
{
    if (EditList)
	delete EditList;
}

//horrible - but I did not found any other way
//as such long functions
void CMultiTextInput::build_widgets(PatternList*which)
{
    QString s,t;
    
    QLineEdit*dummy;
    QMultiLineEdit*d2;
    QLabel*d_label;
    QList<QLabel>*LabelList;
    QBoxLayout*d_layout;
    QSize hint;

    int x_label_size = 0;
    int y_label_size = 0;
    int x_size = 120;
    int MultiLineCount = 0;
    
    if (!which || which->size() == 0)
	return;
    EditList = new QList<QWidget>;
    LabelList = new QList<QLabel>;
    PatternIterator p_iterator;
    for (p_iterator = which->begin();p_iterator!=which->end();++p_iterator){
	s = p_iterator->get_entry();
	d_layout = new QBoxLayout(QBoxLayout::LeftToRight, 2, NULL);
	if (p_iterator->isLargeText())
	    EditLayout->addLayout(d_layout,1);
	else
	    EditLayout->addLayout(d_layout,0);
	d_label = new QLabel(this,s);
	d_label->setAlignment(AlignRight|AlignVCenter);
	t = s.copy();
	t +=": ";
	d_label->setText(t);
	hint=d_label->sizeHint();
	x_label_size = (hint.width() > x_label_size)?hint.width():x_label_size;
	y_label_size = hint.height();
	d_label->setMinimumSize(hint);
	d_label->setMaximumSize(hint);
	d_layout->addWidget(d_label);
	LabelList->append(d_label);
	if (p_iterator->isLargeText()) {
	    d2 = new QMultiLineEdit(this,s);
	    d2->resize(30,50);
	    MultiLineCount++;
	    d2->setText(p_iterator->get_pattern());
	    EditList->append(d2);
	    if (which->begin() == p_iterator)
		d2->setFocus();
	    d_layout->addWidget(d2,1);
	}
	else {
	    dummy = new QLineEdit(this,s);
	    dummy->resize(30,25);
	    dummy->setMinimumSize(10,25);
	    dummy->setMaximumSize(32767,25);
	    dummy->setText(p_iterator->get_pattern());
	    if (p_iterator->isNumeric()) {
		dummy->setMaxLength(29);
	    }
	    else 
		dummy->setMaxLength(255);
	    EditList->append(dummy);
	    d_layout->addWidget(dummy);
	    if (which->begin() == p_iterator)
		dummy->setFocus();
	    connect( dummy, SIGNAL(returnPressed()), SLOT(change_focus()) );
	}
    }
    for (d_label = LabelList->first();d_label;d_label = LabelList->next()) {
	d_label->setMinimumSize(x_label_size,y_label_size);
	d_label->setMaximumSize(x_label_size,y_label_size);
	d_label->resize(x_label_size,y_label_size);
    }
    x_label_size+=50;
    x_size = (x_size > x_label_size)?x_size:x_label_size;
    setMinimumSize(x_size,EditList->count()*28+( EditList->count()==1?2:EditList->count() )*5+25+MultiLineCount*25);
    adjustSize();
    delete LabelList;
}

PatternList*CMultiTextInput::get_entries(bool emptys_too)
{
    QWidget*currentEdit;
    PatternList*pattern_list;
    QString pat;
    QString name;

    pattern_list = new PatternList;
    for (currentEdit=EditList->first();currentEdit!=0;currentEdit=EditList->next()) {
	name = currentEdit->name();
	if (currentEdit->isA("QLineEdit"))
	    pat = ((QLineEdit*)currentEdit)->text();
	else
	    pat = ((QMultiLineEdit*)currentEdit)->text();
	if ( (pat.length() > 0) || emptys_too)
	    pattern_list->push_back(CPatternPair(name,pat));
    }
    return pattern_list;
}

void CMultiTextInput::change_focus()
{
    focusNextPrevChild(true);
}

void CMultiTextInput::keyPressEvent(QKeyEvent*e)
{
    if (e->key() == Key_Return && (OkButton->hasFocus()) ) {
	e->accept();
	OkButton->animateClick();
	return;
    }
    if (e->isAccepted())
	return;
    QDialog::keyPressEvent(e);
}
