// -*-Mode: C++;-*- 
/**
 * The main widget (top-level-widget) of the application
 *
 * @version $Id: MainWindow.h,v 2.1 1999/03/09 01:03:56 ral Exp $
 * @see KTopLevelWidget
 */
#ifndef CMainWindow_included
#define CMainWindow_included

#include "MainWindowData.h"
#include <ktopwidget.h>

class CMainWindow : public CMainWindowData
{
    Q_OBJECT

public:

    CMainWindow (QWidget* parent = NULL, const char* name = NULL );
    virtual ~CMainWindow();
    void append_message(const char*text);
    
private:
    QWidget*TableView;
    QWidget*StatusView;
    QWidget*ThreadView;
    QWidget*Grants;

protected slots:	
    void connectSql();
    void browseTables();
    void createTable();
    void createDB();
    void dispStatus();
    void view_threads();
    void accessControl();

public slots:
    void disconnectSql();
    void clearOutput();
    void reload_grants();
    void flush_cache();
    void close_tables();
    void new_log();
    void shutdown();
    void drop_table();
    void drop_db();

signals:
    void connected();
    void disconnected();
};
#endif // CMainWindow_included
