#include <kwm.h>
#include <kapp.h>
#include <qkeycode.h>

#include "Login.h"

#ifndef rcsid
static const char rcsid[]="$Id: Login.cpp,v 2.3 1999/07/04 22:30:42 ral Exp $";
const char*login_rcs(){return rcsid;}
#endif

#define Inherited LoginData

CLogin::CLogin( QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    setCaption( i18n("KMySQL - Connect") );
    KWM::setIcon(winId(),kapp->getIcon());
    KWM::setMiniIcon(winId(),kapp->getMiniIcon());
    
    PortEdit->setText("3306");
    HostEdit->setFocus();
}


CLogin::~CLogin()
{
}

void CLogin::focus_user()
{
    UserEdit->setFocus();
}
void CLogin::focus_password()
{
    PassEdit->setFocus();
}
void CLogin::focus_port()
{
    PortEdit->setFocus();
}
void CLogin::focus_ok()
{
    OkButton->setFocus();
}

void CLogin::keyPressEvent(QKeyEvent*e)
{
    if (e->key() == Key_Return && (OkButton->hasFocus()) ) {
	e->accept();
	OkButton->animateClick();
	return;
    }
    if (e->isAccepted())
	return;
    QDialog::keyPressEvent(e);
}
