/***************************************************************************
                          cprintoptions.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Jul 18 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cprintoptions.h"

CPrintOptions::CPrintOptions(QWidget *parent, const char *name) : QWidget(parent,name)
{
	initDialog();
	config=kapp->getConfig();
	
	KDEFonts=new QStrList;
	kapp->getKDEFonts(KDEFonts);
	QComboBox_1->insertStrList(KDEFonts);
	QComboBox_2->insertStrList(KDEFonts);
	
	this->readSettings();
}

CPrintOptions::~CPrintOptions()
{
}

void CPrintOptions::readSettings()
{
 	config->setGroup("Printing"); 	
 	
 	KColorButton_1->setColor(config->readColorEntry("printVerseColor", &black ));
 	KColorButton_2->setColor(config->readColorEntry("printVersenumberColor", &red));
 	QSpinBox_1->setValue(config->readNumEntry("printHeadingFontSize", 14));
 	QSpinBox_2->setValue(config->readNumEntry("printTextFontSize", 12)); 	
/* 	QSpinBox_3->setValue(config->readNumEntry("leftBorder" , 40));
 	QSpinBox_4->setValue(config->readNumEntry("upperBorder", 40));
 	QSpinBox_5->setValue(config->readNumEntry("lowerBorder", 40));
 	QSpinBox_6->setValue(config->readNumEntry("rightBorder", 40));*/
	QSpinBox_7->setValue(config->readNumEntry("newLineSpace", 3));
	QSpinBox_8->setValue(config->readNumEntry("newParagraphSpace", 8));
	
	QString headingFont=config->readEntry("printHeadingFont", "times");
	int n;
	for (n=0; n< QComboBox_1->count(); n++)
	{
		if (QComboBox_1->text(n) == headingFont)
		{
			QComboBox_1->setCurrentItem(n);
			break;
		};
	};
	
	QString textFont= config->readEntry("printTextFont", "times");
	for (n=0; n< QComboBox_2->count(); n++)
	{
		if (QComboBox_2->text(n) == textFont)
		{
			QComboBox_2->setCurrentItem(n);
			break;
		};
	};
	
	QString printFlag = config->readEntry("printFlag", "Align left");
	for (n=0; n< QComboBox_3->count(); n++)
	{
		if (QComboBox_3->text(n) == printFlag)
		{
			QComboBox_3->setCurrentItem(n);
			break;
		};
	};	
};

void CPrintOptions::saveSettings()
{
 	config->setGroup("Printing");
 	
 	config->writeEntry("printVerseColor", KColorButton_1->color());
 	config->writeEntry("printTextColor", KColorButton_1->color());
 	config->writeEntry("printVersenumberColor", KColorButton_2->color());
	config->writeEntry("printHeadingFont", QComboBox_1->currentText());
	config->writeEntry("printTextFont", QComboBox_2->currentText());	
	config->writeEntry("printHeadingFontSize",QSpinBox_1->value());
	config->writeEntry("printTextFontSize", 	QSpinBox_2->value());		
/*	config->writeEntry("leftBorder", QSpinBox_3->value());
	config->writeEntry("upperBorder",QSpinBox_4->value());
	config->writeEntry("lowerBorder",QSpinBox_5->value());
	config->writeEntry("rightBorder",QSpinBox_6->value());*/
	config->writeEntry("newLineSpace", QSpinBox_7->value());
	config->writeEntry("newParagraphSpace", QSpinBox_8->value());
	config->writeEntry("printFlag", QComboBox_3->currentText());
	
	emit sigPrintOptionsChanged();
};




