/***************************************************************************
                          coptionsdialog.h  -  description                              
                             -------------------                                         
    begin                : Sat Oct 2 1999                                           
    copyright            : (C) 1999 by The team of BibleTime                         
    email                : BibleTime@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef COPTIONSDIALOG_H
#define COPTIONSDIALOG_H

//QT includes
#include <qdialog.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qwidgetstack.h>
#include <qpushbutton.h>
#include <qdict.h>

//KDE includes
#include <knewpanner.h>
#include <kquickhelp.h>
#include <kkeydialog.h>
#include <ksconfig.h>

//own includes
#include "cprintoptions.h"
#include "cforeignfontoptions.h"
#include "clinkmanagement.h"
#include "../structdef.h"
#include "../cdocbrowser.h"


/**The optionsdialog of BibelTime.
  *@author The team of BibleTime
  */
class COptionsDialog : public QDialog
{
   Q_OBJECT

public:
	COptionsDialog(QWidget *parent=0, KAccel* accel=0, QList<TBibleFont>* fontList=0,const char *name=0);
	~COptionsDialog();
	
protected:
	void setupGeneralOptions();
	void setupKeyOptions();	
	void setupPrintOptions();	
	void setupFontsOptions();	
	void setupColorsOptions();	
	void setupSpellingOptions();		
	void setupFontManagementOptions();		
	void setupLinkManagementOptions();		

	void saveGeneralOptions();
	void saveKeyOptions();	
	void savePrintOptions();	
	void saveFontsOptions();	
	void saveColorsOptions();	
	void saveSpellingOptions();		
	void saveFontManagementOptions();		
	void saveLinkManagementOptions();		
	
	KConfig	*config;
	
	KAccel  *key_accel;
	QDict<KKeyEntry> *dict;
	
	QListViewItem *general_Item;
	QListViewItem *fontManagement_Item;
	QListViewItem *linkManagement_Item;
	QListViewItem *keyChooser_Item;
	QListViewItem *print_Item;	
	QListViewItem *colorOptions_Item;	
	QListViewItem *fontOptions_Item;	
	QListViewItem *spelling_Item;	
	QListViewItem *lastItem;
	
	QListView			*optionsTree;
	QWidgetStack	*widgetStack;
	KNewPanner		*mainPanner;
		
	//the widgets and their content
	QWidget		*general_Widget;
	QCheckBox	*tip_CheckBox;	
  QCheckBox	*logo_CheckBox;
  QCheckBox	*browse_CheckBox;
	
	CForeignFontOptions*	foreignFonts_Widget;
	CLinkManagement		*linkManagement_Widget;
	KKeyChooser				*keyChooser_Widget;
	CPrintOptions			*print_Widget;	
	KSpellConfig			*spelling_Widget;
	CDocBrowserFont		*fontOptions_Widget;
	CDocBrowserColor	*colorOptions_Widget;
	
	QPushButton	*ok_Button;
	QPushButton	*cancel_Button;	
	
protected: // Protected methods
  void resizeEvent(QResizeEvent *event);
  /**  */
  void createGeneralOptions();

protected slots: // Protected slots
  void slotSelectionChanged(QListViewItem*);
  /**  */
  void slotCancel();
  /**  */
  void slotOK();

signals:
	void sigKeyChange();
	void sigPrintOptionsChanged();
	void sigChangeColors();
	void sigChangeBrowserColors( const QColor&,const QColor&,const QColor&,const QColor&,const bool);
  void sigBrowserFixedFont(const char*);
  void sigBrowserFontSize(int);
  void sigBrowserStandardFont(const char*);
  /**  */
  void sigRefreshLinkLists();
};

#endif





