/***************************************************************************
                          coptionsdialog.cpp  -  description
                             -------------------
    begin                : Sat Oct 2 1999
    copyright            : (C) 1999 by The team of BibleTime
    email                : BibleTime@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "coptionsdialog.h"

#include <qheader.h>
#include <kapp.h>

#define BUTTON_WIDTH 100

COptionsDialog::COptionsDialog(QWidget *parent, KAccel* accel, QList<TBibleFont>* fontList, const char *name ) : QDialog(parent, name, true)
{
	config= kapp->getConfig();
  key_accel=accel;
	
	mainPanner= new KNewPanner(this,"mainPanner", KNewPanner::Vertical, KNewPanner::Percent, 25);
	
	//create main widgets	
	optionsTree = new QListView (mainPanner);
	optionsTree->addColumn("Options", optionsTree->width());
	optionsTree->setColumnWidthMode(0, QListView::Maximum);
	optionsTree->header()->hide();
	optionsTree->setRootIsDecorated(true);
  optionsTree->setSorting(0,-1);	//turn off sorting
	optionsTree->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  optionsTree->setLineWidth( 2 );

 	widgetStack=new QWidgetStack(mainPanner);
	widgetStack->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
  widgetStack->setLineWidth( 2 );

  mainPanner->activate(optionsTree, widgetStack);
   	  	
  ok_Button = new QPushButton(this, "ok_Button");
  ok_Button->setText(i18n("OK"));

  cancel_Button = new QPushButton(this, "cancel_Button");
  cancel_Button->setText(i18n("Cancel"));
  	
	//now create for each section a QListViewItem declared int eh header
	general_Item= 				new QListViewItem(optionsTree, i18n("General"));
	keyChooser_Item= 			new QListViewItem(optionsTree, i18n("Keys"));		
	fontManagement_Item= 	new QListViewItem(optionsTree, i18n("Font managment"));
	linkManagement_Item= 	new QListViewItem(optionsTree, i18n("Link managment"));
	colorOptions_Item= 		new QListViewItem(optionsTree, i18n("Colors"));		
	print_Item= 					new QListViewItem(optionsTree, i18n("Print"));
	fontOptions_Item= 		new QListViewItem(optionsTree, i18n("Fonts"));
	spelling_Item= 				new QListViewItem(optionsTree, i18n("Spelling"));
	
	optionsTree->setSelected(general_Item, true);
	lastItem= general_Item;	
	
	this->createGeneralOptions();
	widgetStack->addWidget(general_Widget,0);
	
	print_Widget=new CPrintOptions(widgetStack);
	widgetStack->addWidget(print_Widget,1);
	
	foreignFonts_Widget = new CForeignFontOptions(widgetStack,"fontManager", fontList);
	widgetStack->addWidget(foreignFonts_Widget,2);

	linkManagement_Widget = new CLinkManagement(widgetStack,"linkManager");
	widgetStack->addWidget(linkManagement_Widget,3);
	
	dict = new QDict<KKeyEntry>(key_accel->keyDict());
	keyChooser_Widget= new KKeyChooser(dict, widgetStack, true);
	widgetStack->addWidget(keyChooser_Widget, 4);
		
	fontOptions_Widget= new CDocBrowserFont(widgetStack);
	widgetStack->addWidget(fontOptions_Widget, 5);
	
	colorOptions_Widget= new CDocBrowserColor(widgetStack);
	widgetStack->addWidget(colorOptions_Widget, 6);
	
  spelling_Widget = new KSpellConfig(widgetStack, "spellconfig");	
  widgetStack->addWidget(spelling_Widget, 7);
	
	this->resize(600,400);
  this->setMinimumSize(600,400);
	
	//general_Widget is the standard widget we raise on startup
	widgetStack->raiseWidget(general_Widget);	
	
	//connect signals
	connect(optionsTree, SIGNAL(selectionChanged(QListViewItem*)),
					this, SLOT(slotSelectionChanged(QListViewItem*)));
	connect(ok_Button, SIGNAL(clicked()),
					this, SLOT(slotOK()));
	connect(cancel_Button, SIGNAL(clicked()),
					this, SLOT(slotCancel()));


	connect(fontOptions_Widget, SIGNAL(fixedFont(const char*)),
					this, SIGNAL(sigBrowserFixedFont(const char*)));	
	connect(fontOptions_Widget, SIGNAL(standardFont(const char*)),
					this, SIGNAL(sigBrowserStandardFont(const char*)));	
	connect(fontOptions_Widget, SIGNAL(fontSize(int)),
					this, SIGNAL(sigBrowserFontSize(int)));	

	connect(colorOptions_Widget, SIGNAL(sigChangeColors()),
					this, SIGNAL(sigChangeColors()));	
	connect(colorOptions_Widget, SIGNAL(colorsChanged( const QColor&, const QColor&,const QColor&, const QColor&, const bool)),
       	  this,SIGNAL(sigChangeBrowserColors( const QColor&, const QColor&,const QColor&, const QColor&, const bool)));

  connect(keyChooser_Widget, SIGNAL(keyChange()),
  				this, SIGNAL(sigKeyChange()));
		
	connect (print_Widget, SIGNAL(sigPrintOptionsChanged()),
					 this, SIGNAL(sigPrintOptionsChanged()));
					
	connect(linkManagement_Widget, SIGNAL(sigRefreshLinkLists()),
					this, SIGNAL(sigRefreshLinkLists()));

}

COptionsDialog::~COptionsDialog()
{
	if (foreignFonts_Widget)
		delete foreignFonts_Widget;
	if (fontOptions_Widget)		
		delete fontOptions_Widget;
	if (spelling_Widget)
		delete spelling_Widget;
	if (keyChooser_Widget)
		delete keyChooser_Widget;
	if (general_Widget)
		delete general_Widget;
	if(ok_Button)
		delete ok_Button;
	if(cancel_Button)
		delete cancel_Button;

}

void COptionsDialog::resizeEvent(QResizeEvent *event)
{
	QDialog::resizeEvent( event );
	
	mainPanner->resize(this->width(), this->height()-40);
	
	cancel_Button->setGeometry(this->width()-BUTTON_WIDTH-5, this->height()-35, BUTTON_WIDTH, 30 );
	ok_Button->setGeometry(this->width()-BUTTON_WIDTH-BUTTON_WIDTH-10, this->height()-35, BUTTON_WIDTH, 30 );
}

/**  */
void COptionsDialog::slotSelectionChanged(QListViewItem* item)
{
	if (item == general_Item)
 		this->setupGeneralOptions();
 	if (item == keyChooser_Item)
 		this->setupKeyOptions();
 	if (item == print_Item)
 		this->setupPrintOptions();
 	if (item == colorOptions_Item)
 		this->setupColorsOptions();
 	if (item == fontOptions_Item)
 		this->setupFontsOptions();
 	if (item == spelling_Item)
 		this->setupSpellingOptions();
 	if (item == fontManagement_Item)
 		this->setupFontManagementOptions();
 	if (item == linkManagement_Item)
 		this->setupLinkManagementOptions();

 		
 	lastItem = item;
}


void COptionsDialog::setupGeneralOptions()
{
	widgetStack->raiseWidget(general_Widget);
};

void COptionsDialog::setupKeyOptions()
{
	widgetStack->raiseWidget(keyChooser_Widget);	
}

void COptionsDialog::setupPrintOptions()
{
	widgetStack->raiseWidget(print_Widget);	
}

void COptionsDialog::setupFontsOptions()
{
	widgetStack->raiseWidget(fontOptions_Widget);	
}

void COptionsDialog::setupColorsOptions()
{
	widgetStack->raiseWidget(colorOptions_Widget);	
}

void COptionsDialog::setupSpellingOptions()
{
  widgetStack->raiseWidget(spelling_Widget);
}

void COptionsDialog::setupFontManagementOptions()
{
	widgetStack->raiseWidget(foreignFonts_Widget);
}

void COptionsDialog::setupLinkManagementOptions()
{
	widgetStack->raiseWidget(linkManagement_Widget);
}



//save routines
void COptionsDialog::saveGeneralOptions()
{
	config->setGroup("TipOfTheDay");
	config->writeEntry("show_tod", tip_CheckBox->isChecked());

	config->setGroup("General Options");
	config->writeEntry("Logo",logo_CheckBox->isChecked());	
	config->writeEntry("useKFM",browse_CheckBox->isChecked());	
	config->writeEntry("isConfigured", true);	
};

void COptionsDialog::saveKeyOptions()
{
	key_accel->setKeyDict( *dict);	
	key_accel->writeSettings(config);
}

void COptionsDialog::savePrintOptions()
{
	print_Widget->saveSettings();
}

void COptionsDialog::saveFontsOptions()
{
	colorOptions_Widget->writeOptions();
}

void COptionsDialog::saveColorsOptions()
{
	fontOptions_Widget->writeOptions();
}

void COptionsDialog::saveSpellingOptions()
{
	spelling_Widget->writeGlobalSettings();  	
}

void COptionsDialog::saveFontManagementOptions()
{
	foreignFonts_Widget->saveSettings();	
}

void COptionsDialog::saveLinkManagementOptions()
{
	linkManagement_Widget->saveSettings();	
}


void COptionsDialog::createGeneralOptions()
{
	general_Widget = new QWidget(widgetStack);
	
	config->setGroup("General Options");	
	logo_CheckBox = new QCheckBox(general_Widget, "logo_CheckBox");
	logo_CheckBox->setGeometry(10,10,250,30);
	logo_CheckBox->setText(i18n("Show logo on startup"));
	logo_CheckBox->setChecked(config->readBoolEntry("Logo", true));	
  KQuickHelp::add(logo_CheckBox, i18n("Enable this box if you want to see the <b>startuplogo</b>."));

	config->setGroup("TipOfTheDay");	
	tip_CheckBox = new QCheckBox(general_Widget, "tip_CheckBox");
	tip_CheckBox->setGeometry(10,40,250,30);
	tip_CheckBox->setText(i18n("Show Tip of the Day on startup"));
	tip_CheckBox->setChecked(config->readBoolEntry("show_tod", true));	
  KQuickHelp::add(tip_CheckBox, i18n("Enable this box if you want to see the <b>tip of the day on startup</b>."));

  config->setGroup("General Options");
  browse_CheckBox = new QCheckBox(general_Widget, "browse_checkbox");
 	browse_CheckBox->setGeometry(10,70,250,30);
	browse_CheckBox->setText(i18n("Use KFM to display http:// URL"));
	browse_CheckBox->setChecked(config->readBoolEntry("useKFM", true));	
  KQuickHelp::add(browse_CheckBox, i18n("Enable this box if you want to display URLs of the modules in KFM."));
}


void COptionsDialog::slotOK()
{
	this->saveGeneralOptions();
	this->saveKeyOptions();
	this->saveColorsOptions();
	this->savePrintOptions();
	this->saveFontsOptions();
	this->saveSpellingOptions();
	this->saveFontManagementOptions();	
	this->saveLinkManagementOptions();
		
  config->sync();
  accept();
	
//	this->hide();
}

void COptionsDialog::slotCancel()
{
	this->hide();
}




















