/***************************************************************************
                          cresultlistbox.h  -  description                              
                             -------------------                                         
    begin                : Sat Jul 3 1999                                           
    copyright            : (C) 1999 by Joachim Ansorg
    email                : Jockel123@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/cresultlistbox.h,v 1.2 1999/10/31 14:58:39 jockel Exp $ */
/* $Revision: 1.2 $ */

#ifndef CRESULTLISTBOX_H
#define CRESULTLISTBOX_H

#include <qwidget.h>
#include <qlistbox.h>
#include <qpopupmenu.h>
#include <qstrlist.h>
#include <qlabel.h>

#include <kapp.h>
#include <kiconloader.h>
/**
	* This widget displays the result in a list
	* and lists the count of the entries at the bottom of the widget
	* together with the position of the selected entry.
  *
	* @short displays the result in a list.
  * @author Joachim Ansorg
  * @see QListBox
  */
class CResultListBox : public QListBox
{
   Q_OBJECT

public: 
	/** The constructor
		*/
	CResultListBox(QWidget *parent=0, const char *name=0);
	
	/** The destructor
		*/
	~CResultListBox();
	
	/** Returns the popup menu we use
		*/
	QPopupMenu* getPopup();
	
	/** Sets the content of ths widget to the entries in the list
	  *
		* @param QStrList	The list which contains the new content
		*	@param int
		*/
	void insertStrList(QStrList*, int index=-1 );
	
protected:
	void mousePressEvent(QMouseEvent *e);	
	QStrList *currentList;
	QStrList *tmpList;
	
protected slots:
	void slotSaveAll();
	void slotSaveAllWithText();
	void slotSaveCurrent();
	void slotSaveCurrentWithText();	
	void slotCopyAll();
	void slotCopyAllWithText();		
	void slotCopyCurrent();
	void slotCopyCurrentWithText();
	void slotPrintCurrent();
	void slotPrintCurrentWithText();
	void slotPrintAll();
	void slotPrintAllWithText();
  void slotAnalyse();
	
private:
	/** The poup menu which appears when the user clicks on the list
		*/
	QPopupMenu *popup;

signals:
	void sigSaveListToFile(QStrList*, bool);
	void sigCopyListToClipboard(QStrList*, bool);
	void sigPrintList(QStrList*, bool);
	
};

#endif


/***** The CResultList widget *******************************
*************************************************************/
#ifndef RESULTLIST_H
#define RESULTLIST_H

/** A widget which displays the reult lsit. It uses CResultListBox to do this.
  *
  * @author Joachim Ansorg
	* @short provides a listview for the searchresult
	* @see CResultListBox
	*/
class CResultWidget : public QWidget
{
   Q_OBJECT

public:
	/** The connstructor
		*/
	CResultWidget(QWidget *parent=0, const char *name=0);
	
	/** The destructor
		*/
	~CResultWidget();

	/** This function sets up the listbox with the given QStrList and
		* uses the function count() of the listbox to set up the label.
		*
		* @short Set up the listbox and the label
		*/
	virtual void setResult (QStrList *);

	/** This function clears the listbox and sets the text of the label to ""
		*
		* @short Clears the listbx and the label
		*/
	virtual void clear();

protected:
	/** The overrided resizeEvent implementation
		*/
	virtual void resizeEvent (QResizeEvent *);
	
protected:
	/** The listbox which contains the result
		*/
	CResultListBox 	*rList;
	
	/** The label which displays the current selcted entry and the count of the entries
		*/
	QLabel 					*textLabel;
	
protected slots:
	/** This SLOT is called when ther was something selected in the lisbox
		*/
	void slotHighlighted(int);

signals:
	/** This SIGNAL is emitted when ther was something selected in the listbox
		*/
	void highlighted(const char *);
	
	/** Is emiited if the user wants to save the result.
		*
		* @param QStrList	The list which contains the entries we want to save
		* @param If true we save with versetext otherwhise only the keyname
		*/
	void sigSaveListToFile(QStrList *, bool);
	
	/** Is emiited if the user wants to copy the result to the clipboard
		*
		* @param QStrList	The list which contains the entries we want to copy
		* @param bool If true we copy with versetext otherwhise only the keyname
		*/
	void sigCopyListToClipboard(QStrList* lost, bool);
	
	/** Is emiited if the user wants to print the result.
		*
		* @param QStrList	The list which contains the entries we want to print
		* @param bool If true we print with versetext otherwhise only the keyname
		*/
	void sigPrintList(QStrList*, bool);
};

#endif