/***************************************************************************
                          bookmarkmanager.h  -  description                              
                             -------------------                                         
    begin                : Fri Jul 16 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/bookmarkmanager.h,v 1.1.1.1 1999/09/24 06:22:46 uhl Exp $ */
/* $Revision: 1.1.1.1 $ */

#ifndef BOOKMARKMANAGER_H
#define BOOKMARKMANAGER_H

#include <qlist.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include <qpixmap.h>

enum ModuleType { Bible , Dictionary , Commentary , Group , Bookmark};
	
struct BookmarkInfo {
	QListViewItem	*item;
	ModuleType type;
};

//typedef QList<QListViewItem>	GroupItemList;
typedef QList<BookmarkInfo>		BookmarkItemList;

/**
  *@author Torsten Uhlmann
  */
class BookmarkManager : public QListView
{
	Q_OBJECT
	
public:

	BookmarkManager(QWidget *parent = 0, const char *name = 0);
	~BookmarkManager();
	
public slots:
	void slotSetCurrentKeyModule(const QString&, const QString&, const QString&);
	
signals:
	void sigBookmarkChosen(const QString &module, const QString &key);
	
private slots:
  /** open the BookmarkManager Popup menu */
	void slotPopupMenu( QListViewItem *, const QPoint &, int );
	void slotAddBookmark();
	void slotDeleteBookmark();
	void slotNewGroup();
	void slotDeleteGroup();
	void slotGroupProperties();
	void slotBookmarkChosen( QListViewItem *i );
	void slotMarkItem();
	void slotMoveItem();
	
private:
	/** read the available bookmarks from the config file
			and build a bookmark tree */
	void readOptions();
	/** save all bookmarks to the config file */
	void saveOptions();
	/** returns the Group Name of the parent or #NULL# if none */
	QString parentName(QListViewItem*);
	/** returns the Group Id of the parent or -1 if none */
	int parentId(BookmarkItemList*, QListViewItem*);
	/** returns pointer to parent group with given id */
	QListViewItem *findParent(int);
	/** restorate an marked item (set the original pixmap) */
	void restoreMarkedItem();
	/** gets a parent item and processes all children, grand children etc. */
	void traverseTree(QListViewItem*, QListViewItem*);
	/** check if second is child of first item */
	bool isChild( QListViewItem*, QListViewItem*);
	/** get the BookmarkInfo struct for that item */
	BookmarkInfo *getBookmarkInfo( QListViewItem * );
	
protected:
	QPopupMenu				*bookmarkPopup;
	QString						currentKey;
	QString						currentModule;
	QString						currentType;
	BookmarkItemList	groupList;
	BookmarkItemList	bookmarkList;
	BookmarkInfo			pasteBuffer;
	
	// Pixmaps	
	QPixmap groupPix;
	QPixmap textPix;
	QPixmap dictionaryPix;
	QPixmap commentaryPix;
	QPixmap *currentPixmap;

};

#endif