/***************************************************************************
                          bibletimedoc.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun 15 15:34:26 CEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/bibletimedoc.h,v 1.3 1999/10/10 16:26:52 jockel Exp $ */
/* $Revision: 1.3 $ */

#ifndef BIBLETIMEDOC_H
#define BIBLETIMEDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qlist.h>

//SWORD includes
#include <swmgr.h>
#include <swkey.h>
#include <versekey.h>
#include <listkey.h>

//own includes
#include "bibletime.h"
#include "swordapi.h"
#include "structdef.h"

// forward declaration of the BibleTime classes
class BibleTimeView;

/** this structure stores info about one Module */
struct ModuleDefinition
{
	QString	custom; // custom field for others to use
	QString	name;
	QString	description;
	QString	type;
};

typedef QList<ModuleDefinition> ModuleDefinitionList;

/**	BibleTimeDoc provides a document object for a document-view model.
  *
	* The BibleTimeDoc class provides a document object that can be used in conjunction with the classes BibleTimeApp and BibleTimeView
	* to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
	* is created by the BibleTimeApp instance and contains the document structure with the according methods for manipulation of the document
	* data by BibleTimeView objects. Also, BibleTimeDoc contains the methods for serialization of the document data from and to files.
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
	* @version KDevelop version 0.4 code generation
	*/
class BibleTimeDoc : public QObject
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  BibleTimeDoc(QWidget* parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~BibleTimeDoc();
	/** adds a view to the document which represents the document contents. Usually this is your main view. */
  void addView(BibleTimeView* m_pView);
	/** removes a view from the list of currently connected views */
	void removeView(BibleTimeView* m_pView);
	/** closes the acutal document */
	void closeDocument();
	
	/** Get list of SWORD Modules installed */
	void getModuleList();
	/** initialize SWORD components */
	void initSWORD();
	/** interface to signal/slot mechanism for the display classes */
	void sendHTML(const QString&, const QString&);
	/** return the text of the current module for the given key */
	QString getTextForKey (const QString&);
	/** produce the next key for given abbrev for the current module */
	QString getKeyFromAbbrev (const QString&);

  QString getForeignFont( QString module);
  /** Sets up the font list of the different bible modules. */
  QList <TBibleFont>* setupFontList();
	
 public slots:
 	/** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
 	  * As this view normally repaints itself, it is excluded from the paintEvent. */
 	void slotUpdateAllViews(BibleTimeView* pSender);

 	// ///////////////////////
 	// The DOC-API starts here
 	// ///////////////////////

 	/** call this slot whenever the current module was changed by the app */ 	
	void slotViewModActivate(const QString&);
	/** call when the browsertab was changed */
	void slotSetCurrentModule(const QString&);

	/** call when the lookup text changed */
	void slotLookupTextChanged(const QString&);
	/** call whenever another search result was selected and should be shown */
	void slotResultListSelectionChanged(const char*);
	
	/** emit the signals that send the current key */
	void slotCurrentKeyRequested();
	
	/** only called to refresh the display of an already chosen module */
	void slotRefreshDisplay(const QString&);
	
	// //////////////////// //
	// Search functionality //
	// //////////////////// //
	
	/** set the search scope with lower bounds / upper bounds */
	void slotSetSearchScope(const QString &lb, const QString &up);
	/** set the search scope with the result of the last search
			as scope for the new one */
	void slotSetSearchScope();
	/** reset the scope to the whole module */
	void slotResetSearchScope();
	
	/** use this to accomplish a search in the current module */
	void slotSearchCurrentModule(BibleTimeApp::SearchType, bool, const QString&);
	/** search a module for a given key */
	void slotSearchInModule(const QString&, const QString&);
	
	/** call this slot when you want the previous chapter/text to the current */
	void slotMoveToPreviousChapter();
	/** if bible go to previous book */
	void slotMoveToPreviousBook();
	/** call this slot when you want the next chapter/text to the current */
	void slotMoveToNextChapter();
	/** if bible go to next book */
	void slotMoveToNextBook();
  /** */
  void slotMoveToPreviousVerse();
  /** */
  void slotMoveToNextVerse();

	// /////////////////////// //
	// Personal Comment Editor //
	// /////////////////////// //
	/** Add a comment to the personal comments module
		* modName:		the module to work with
		* startVerse: verse to start with
		* stopVerse:	up to this verse
		* comment:		comment to add
		*/
	void slotPersonalCommentAdd(const QString &modName, const QString &startVerse, const QString &stopVerse, const QString &comment);
	void slotPersonalCommentRemove(const QString &modName, const QString &startVerse, const QString &stopVerse);
	
	// //////////// //
	// VIEW OPTIONS //
	// //////////// //
	
  /** toggle the view of Strongs numbers */
	void slotDisplayStrongs(bool);
  /** toggle the view of footnotes */
	void slotDisplayFootnotes(bool);
	
	void slotChangeColors();
			
 signals:
 	/** sends a new module list */
 	void sigModuleList(ModuleDefinitionList*);
 	/** sends HTML text subsequent to a lookup */
 	void sigHTMLText(const QString&, const QString&);
 	/** send the current key with (module) as text */
 	void sigCurrentKeyTextChanged(const QString&);
 	/** send only the current key as text */
 	void sigCurrentKeyVerseChanged(const QString&);
 	/** send the current key and the current module as text */
 	void sigCurrentKeyModuleChanged(const QString&, const QString&, const QString&);
 	/** sends a result list subsequent to a search */
 	void sigSearchResultList(QStrList*);
	/** sens a request that the key of the module (first parameter) should be changed to the font (second parameter)*/
 	void sigChangeFont( QString,QString );
 	
protected:
	/** This funtion saves the parameters
	of the class BibleTimeDoc. */
	void saveOptions();	
	/** This funtion reads the parameters
	of the class BibleTimeDoc. */
	void readOptions();

 public:	
 	/** the list of the views currently connected to the document */
	static QList<BibleTimeView>* viewList;
		
 private:
 	KConfig						*config;

	// Variables to hold the data
	ModuleDefinitionList 	*_moduleList;
	QList<TBibleFont>	*bibleFontList;
	
	QString		currentVerseKey;
	QString		currentStrKey;
	int				searchType;
	int				searchParams;
	
	BibleTimeMgr	*mainMgr;
	SWModule			*currentText;
	SWModule			*currentLexicon;
	SWModule			*currentComment;
	SWModule 			*curMod; // pointer to the activated Module
	HTMLChapterDisplay 		*chapterDisplay;
	HTMLEntryDisplay	 		*entryDisplay;
	VerseKey			searchScopeLowUp;
	ListKey				searchScopeList;
	SWKey					*currentScope;
	
	/* the last keys for each module */
	QString						recentTextKey;
	QString						recentLexiconKey;
	QString						recentCommentKey;

};

#endif // BIBLETIMEDOC_H
















