/***************************************************************************
                          bibletimedoc.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 15 15:34:26 CEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for Qt

#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// SWORD STUFF
//#include <string>
#include <swmgr.h>
#include <versekey.h>
#include <regex.h>

// application specific includes
#include <bibletimedoc.h>
#include "bibletime.h"
#include "bibletimeview.h"
#include "swordapi.h"

QList<BibleTimeView>* BibleTimeDoc::viewList = 0;

BibleTimeDoc::BibleTimeDoc(QWidget *parent, const char* name):QObject(parent, name)
{
	if( !viewList )
		viewList = new QList<BibleTimeView>;
	viewList->setAutoDelete(true);
	
	_moduleList = new ModuleDefinitionList;
	_moduleList->setAutoDelete(true);

	//mainMgr         = new BibleTimeMgr();
	mainMgr = new BibleTimeMgr();
	CHECK_PTR(mainMgr);
	chapterDisplay 	= new HTMLChapterDisplay(this);
	CHECK_PTR(chapterDisplay);
	entryDisplay 		= new HTMLEntryDisplay(this);
	CHECK_PTR(entryDisplay);

	curMod          = 0;
	currentText 		= 0;
	currentLexicon 	= 0;
	currentComment 	= 0;
	
	currentVerseKey.setStr("Genesis 1:1"); // initial value
	currentStrKey.setStr("Genesis");

	currentScope = 0;
	searchScopeLowUp.ClearBounds();
	searchScopeList.ClearList();
	
	// initialize SWORD components
	initSWORD();

	config=kapp->getConfig();
	this->readOptions();
	if (!recentTextKey.isEmpty())
		currentVerseKey = recentTextKey.copy();
	if (!recentLexiconKey.isEmpty())
		currentStrKey = recentLexiconKey.copy();
}

BibleTimeDoc::~BibleTimeDoc()
{
	this->saveOptions();
	
	if (mainMgr)
		delete mainMgr;
	if (chapterDisplay)
		delete chapterDisplay;
	if (entryDisplay)
		delete entryDisplay;
		
}

void BibleTimeDoc::saveOptions()
{
//save options
	config->setGroup("Document Settings");

	config->writeEntry("currentTextKey",				recentTextKey);
	config->writeEntry("currentLexiconKey",			recentLexiconKey);
	config->writeEntry("currentCommentKey",			recentCommentKey);
}

void BibleTimeDoc::readOptions()
{
	config->setGroup("Document Settings");
	recentTextKey 		= config->readEntry("currentTextKey");
	recentLexiconKey 	= config->readEntry("currentLexiconKey");
	recentCommentKey 	= config->readEntry("currentCommentKey");
	debug("%s %s %s",recentTextKey.data(),recentLexiconKey.data(),recentCommentKey.data());
}

void BibleTimeDoc::addView(BibleTimeView* m_pView)
{
	viewList->append(m_pView);
}

void BibleTimeDoc::removeView(BibleTimeView* m_pView)
{
	viewList->remove(m_pView);
}

void BibleTimeDoc::slotUpdateAllViews(BibleTimeView* pSender)
{
	BibleTimeView* w;
	if(viewList)
	{
		for( w = viewList->first(); w; w = viewList->next() )
		{ if( w != pSender)
				w->repaint();
		}
	}

}


void BibleTimeDoc::closeDocument()
{

}


void BibleTimeDoc::getModuleList()
{
	ModuleDefinition *moDef;
	SWModule         *mo;
	_moduleList->clear();
	
	// use SWMgr to traverse installed modules
	ModMap::iterator modIterator;

	for (modIterator = mainMgr->Modules.begin(); modIterator != mainMgr->Modules.end(); modIterator++)
	{
		mo = (*modIterator).second;
		moDef = new ModuleDefinition;
		moDef->name.setStr((mo->Name() != 0 ? mo->Name() : ""));
		moDef->description.setStr((mo->Description() != 0 ? mo->Description() : ""));
		moDef->type.setStr((mo->Type() != 0 ? mo->Type() : ""));
		_moduleList->append(moDef);
		debug("%s,%s,%s",moDef->name.data(),moDef->type.data(),moDef->description.data());
	}
		
	emit sigModuleList(_moduleList);
	slotUpdateAllViews(0);
	//modIterator->first.c_str());
}

void BibleTimeDoc::initSWORD()
{
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	char *font;
	SWModule *curMod = 0;
 	
 	bibleFontList = new QList<TBibleFont>;
	
	for (it = mainMgr->Modules.begin(); it != mainMgr->Modules.end(); it++)
	{
		curMod = (*it).second;

		if (!strcmp((*it).second->Type(), "Biblical Texts"))
		{
			font = 0;
			if ((sit = mainMgr->config->Sections.find((*it).second->Name())) != mainMgr->config->Sections.end()) {
				if ((eit = (*sit).second.find("Font")) != (*sit).second.end())
				{
					font = (char *)(*eit).second.c_str();
					debug(font);
					
					TBibleFont *fontListItem = new TBibleFont;
					fontListItem->module = curMod->Description();
					fontListItem->fontname = font;
					bibleFontList->append( fontListItem );
				}
			}
			curMod->Disp(chapterDisplay);	// set our HTMLChapterDisp object up for the diplayer of each Biblical Text module
			
			if (!this->curMod) 	// set currently selected module for app to first module from SWMgr (Bible Texts get first preference
				this->curMod = curMod;
		}	else {
			curMod->Disp(entryDisplay);	// set our HTMLEntryDisplay object up for the diplayer of each module other than Biblical Texts
		}
	}
	
	if (!this->curMod) 	// set currently selected module for app to first module from SWMgr
		this->curMod = curMod;
		
	// see what options we have
	OptionsList options = mainMgr->getGlobalOptions();
			
	//for (OptionsList::iterator oit = options.begin(); oit != options.end(); oit++)
	//{
	//	debug ("Options: %s", oit->c_str());		
	//}
}

void BibleTimeDoc::sendHTML(const QString &type, const QString &text)
{
	emit sigHTMLText(type, text);
}

QString BibleTimeDoc::getTextForKey (const QString &key)
{
	QString result 	= 0;

	if (curMod)
	{
		curMod->SetKey(key.data());
		(const char *)(*curMod);	// snap to entry
		//result.setStr( (const char *)(*curMod) );
		result.setStr( curMod->StripText() );
	}
	return result;
}

QString BibleTimeDoc::getKeyFromAbbrev (const QString &t)
{
	SWKey *key = 0;
	QString keyStr = 0;
	if (curMod)
	{
		if (!strcmp(curMod->Type(),"Lexicons / Dictionaries"))
		{
			key = new SWKey;
			*key = t.data();
		} else {
			key = new VerseKey;
			*key = t.data();
		}
		keyStr.setStr((const char*)(*key));
		//debug("key is %s",keyStr.data());
	}
	return keyStr;
}

void BibleTimeDoc::slotCurrentKeyRequested()
{
	QString tmpBuf;
	QString tmpMod;
	QString tmpType;
	
	if (curMod)
	{
		tmpBuf.sprintf("%s (%s)", curMod->KeyText(), curMod->Name());
		emit sigCurrentKeyTextChanged(tmpBuf);
		
		tmpBuf.setStr(curMod->KeyText());
		tmpMod.setStr(curMod->Name());
		tmpType.setStr(curMod->Type());
		
		emit sigCurrentKeyVerseChanged(tmpBuf);
		emit sigCurrentKeyModuleChanged(tmpBuf, tmpMod, tmpType);
	}	
}

void BibleTimeDoc::slotLookupTextChanged(const QString &text)
{
	QString keyText;
	QString tmpBuf;
	QString tmpMod;
	QString tmpType;

	keyText = text;

	if (curMod)
	{
		if (!strcmp(curMod->Type(),"Lexicons / Dictionaries"))
			currentStrKey = text.copy();
		else
			currentVerseKey = text.copy();
		
		curMod->SetKey(keyText.data());
		curMod->Display();
		tmpBuf.sprintf("%s (%s)", curMod->KeyText(), curMod->Name());
		emit sigCurrentKeyTextChanged(tmpBuf);
			
		tmpBuf.setStr(curMod->KeyText());
		tmpMod.setStr(curMod->Name());
		tmpType.setStr(curMod->Type());
		emit sigCurrentKeyVerseChanged(tmpBuf);
		emit sigCurrentKeyModuleChanged(tmpBuf, tmpMod, tmpType);
				
	// set recent Key
		if (tmpType.contains("Biblical Texts"))
			recentTextKey = tmpBuf.copy();
		if (tmpType.contains("Lexicons / Dictionaries"))
			recentLexiconKey = tmpBuf.copy();
		if (tmpType.contains("Commentaries"))
			recentCommentKey = tmpBuf.copy();
	}
}

void BibleTimeDoc::slotRefreshDisplay(const QString &text)
{
	QString tmpBuf 	= 0;
	QString tmpType = 0;
	
	if (curMod)
	{
		curMod->SetKey(text.data());
		curMod->Display();
		
		tmpBuf.setStr(curMod->KeyText());
		tmpType.setStr(curMod->Type());
		// set recent Key
		if (tmpType.contains("Biblical Texts"))
			recentTextKey = tmpBuf.copy();
		if (tmpType.contains("Lexicons / Dictionaries"))
			recentLexiconKey = tmpBuf.copy();
		if (tmpType.contains("Commentaries"))
			recentCommentKey = tmpBuf.copy();
	}
}

void BibleTimeDoc::slotViewModActivate(const QString &modName)
{
	ModMap::iterator it;
	QString *key = &currentVerseKey;

	it = mainMgr->Modules.find(modName.data());
	if (it != mainMgr->Modules.end())
	{
		if (!strcmp((*it).second->Type(), "Biblical Texts"))
		{
			currentText = (*it).second;
			emit sigChangeFont( currentText->Description(), getForeignFont(currentText->Description()) );
		};
		
		if (!strcmp((*it).second->Type(), "Lexicons / Dictionaries"))
		{
			currentLexicon = (*it).second;
			key = &currentStrKey;
		}
		if (!strcmp((*it).second->Type(), "Commentaries"))
			currentComment = (*it).second;
		
		curMod = (*it).second;
		slotLookupTextChanged(*key);
	}
	else	curMod = 0;
}

void BibleTimeDoc::slotSetCurrentModule(const QString &m)
{
	if (m.contains("Biblical Texts"))
	{
		curMod = currentText;
		
		if (recentTextKey != recentCommentKey)
			slotRefreshDisplay(currentVerseKey);
	}
	if (m.contains("Lexicons / Dictionaries"))
		curMod = currentLexicon;
	if (m.contains("Commentaries"))
	{
		curMod = currentComment;
		if (recentTextKey != recentCommentKey)
			slotRefreshDisplay(currentVerseKey);
	}
}

/* set search scope */
void BibleTimeDoc::slotSetSearchScope(const QString &lb, const QString &up)
{
	searchScopeLowUp.ClearBounds();
//	VerseKey lbK = lb.data();
//	VerseKey ubK = up.data();
//	searchScopeLowUp.LowerBound((const char *) lbK);
//	searchScopeLowUp.UpperBound((const char *) ubK);
// debug("lower Bound: %s", (const char*) searchScopeLowUp.LowerBound((const char *) lbK));
// debug("upper Bound: %s", (const char*) searchScopeLowUp.UpperBound((const char *) ubK));
	searchScopeLowUp.LowerBound(lb.data());
	searchScopeLowUp.UpperBound(up.data());
	currentScope = &searchScopeLowUp;
}

void BibleTimeDoc::slotSetSearchScope()
{
	currentScope = &searchScopeList;
}

void BibleTimeDoc::slotResetSearchScope()
{
	currentScope = 0;
	searchScopeLowUp.ClearBounds();
	searchScopeList.ClearList();
}

/* search functions */
void BibleTimeDoc::slotSearchCurrentModule(BibleTimeApp::SearchType type, bool cs, const QString &searchText)
{
	if (cs)
		searchParams = 0;
	else
		searchParams = REG_ICASE;

	switch (type)
	{
		case BibleTimeApp::MultiWord: 	searchType = -2; break;
		case BibleTimeApp::ExactPhrase: searchType = -1; break;
		case BibleTimeApp::RegEx:				searchType =  0; break;
	}
		
 	QStrList *resultList = new QStrList;
	CHECK_PTR(resultList);
	resultList->setAutoDelete(true);
	resultList->clear();

	if (curMod)
	{
		// set wait cursor
		kapp->setOverrideCursor( waitCursor );
		
		for (ListKey &searchResults = curMod->Search(searchText.data(), searchType, searchParams, currentScope); !searchResults.Error(); searchResults++)
		{
			resultList->append((const char *)searchResults);
			searchScopeList << (const char *)searchResults;
		}
		emit sigSearchResultList(resultList);
		
		// reset wait cursor
		kapp->restoreOverrideCursor();
	}
}

void BibleTimeDoc::slotSearchInModule(const QString &modName, const QString &key)
{
	slotViewModActivate(modName);
	slotLookupTextChanged(key);
}

void BibleTimeDoc::slotMoveToPreviousChapter()
{
	QString		keyStr = 0;	
	VerseKey	vKey;
	SWKey			sKey;

	if (curMod)
	{
		if (!strcmp(curMod->Type(), "Biblical Texts"))
		{
			vKey = (*(SWKey *)*curMod);
			vKey.Chapter(vKey.Chapter()-1);
		}
		if (!strcmp(curMod->Type(), "Commentaries"))
		{
			vKey = (*(SWKey *)*curMod);
			//debug("Key is %s",(const char*) vKey);
			(*curMod)--;
			vKey = (*(SWKey *)*curMod);
		}
		if (!strcmp(curMod->Type(), "Lexicons / Dictionaries"))
		{
			(*curMod)--;
			sKey = (*(SWKey *)*curMod);
			keyStr.setStr((const char *) sKey);
		} else
			keyStr.setStr((const char *) vKey);
		slotLookupTextChanged(keyStr);
	}
}

void BibleTimeDoc::slotMoveToNextChapter()
{
	QString		keyStr = 0;	
	VerseKey	vKey;
	SWKey			sKey;

	if (curMod)
	{
		if (!strcmp(curMod->Type(), "Biblical Texts"))
		{
			vKey = (*(SWKey *)*curMod);
			vKey.Chapter(vKey.Chapter()+1);
		}
		if (!strcmp(curMod->Type(), "Commentaries"))
		{
			(*curMod)++;
			vKey = (*(SWKey *)*curMod);
		}
		if (!strcmp(curMod->Type(), "Lexicons / Dictionaries"))
		{
			(*curMod)++;
			sKey = (*(SWKey *)*curMod);
			keyStr.setStr((const char *) sKey);
		} else
			keyStr.setStr((const char *) vKey);
		slotLookupTextChanged(keyStr);
	}
}

void BibleTimeDoc::slotMoveToPreviousBook()
{
	QString		keyStr = 0;	
	VerseKey	vKey;

	if (curMod)
	{
		if (strcmp(curMod->Type(), "Lexicons / Dictionaries"))
		{
			vKey = (*(SWKey *)*curMod);
			vKey.Book(vKey.Book()-1);
			keyStr.setStr((const char *) vKey);
			slotLookupTextChanged(keyStr);
		}
	}
}

void BibleTimeDoc::slotMoveToNextBook()
{
	QString		keyStr = 0;	
	VerseKey	vKey;

	if (curMod)
	{
		if (strcmp(curMod->Type(), "Lexicons / Dictionaries"))
		{
			vKey = (*(SWKey *)*curMod);
			vKey.Book(vKey.Book()+1);
			keyStr.setStr((const char *) vKey);
			slotLookupTextChanged(keyStr);
		}
	}
}

void BibleTimeDoc::slotResultListSelectionChanged(const char *selection)
{
	if (*selection)
	{
		QString text;
		text.setStr(selection);
		slotLookupTextChanged(text);
	}
}

// //////////////////////////// //
// API to the personal comments //
// //////////////////////////// //

void BibleTimeDoc::slotPersonalCommentAdd(const QString &modName, const QString &startVerse, const QString &stopVerse, const QString &comment)
{
	ModMap::iterator 	it;
	SWModule 					*commentModule = 0;
	VerseKey 					startKey;
	VerseKey 					stopKey;

	it = mainMgr->Modules.find(modName.data());
	if (it != mainMgr->Modules.end())
	{
		commentModule = (*it).second;
		
		// should return Personal Commentary (or other RawFiles module)
		//	debug("Module is %s",commentModule->Name());

		startKey = startVerse.data();
		stopKey = stopVerse.data();

		commentModule->SetKey(startVerse.data()); // position mod to key
		(*commentModule) << comment.data();   // set entry to comment
		if ((*(SWKey *)*commentModule) < stopKey)
		{
			(*commentModule)++;
			
			while ((*(SWKey *)*commentModule) <= stopKey)
			{
				(*commentModule) << startKey;   // link all subsequent verses to the comment at 'startKey'
				(*commentModule)++;
			}
		}
		if (commentModule == curMod)
			commentModule->Display();
			
		debug("Added Comment");
	} else
		debug("Module %s not found!", commentModule->Name());
}
		
void BibleTimeDoc::slotPersonalCommentRemove(const QString &modName, const QString &startVerse, const QString &stopVerse)
{
	ModMap::iterator 	it;
	SWModule 					*commentModule = 0;
	VerseKey 					startKey;
	VerseKey 					stopKey;
	
	it = mainMgr->Modules.find(modName.data());
	if (it != mainMgr->Modules.end())
	{
		commentModule = (*it).second;
		
		// should return Personal Commentary (or other RawFiles module)
		debug("Module is %s", commentModule->Name());

		startKey = startVerse.data();
		stopKey = stopVerse.data();

		commentModule->SetKey(startVerse.data()); // position mod to key
		(*commentModule).Delete();   // remove entry
		if ((*(SWKey *)*commentModule) < stopKey)
		{
			(*commentModule)++;
		
			while ((*(SWKey *)*commentModule) <= stopKey)
			{
				(*commentModule).Delete();   // link all subsequent verses to the comment at 'startKey'
				(*commentModule)++;
			}
		}
		if (commentModule == curMod)
			commentModule->Display();

		debug("Removed Comment");
	} else
		debug("Module %s not found!", commentModule->Name());
}

void BibleTimeDoc::slotDisplayStrongs(bool f)
{
	if (f)
		mainMgr->setGlobalOption("Strong's Numbers","On");
	else
		mainMgr->setGlobalOption("Strong's Numbers","Off");
		
	if (curMod)
		curMod->Display();
}

void BibleTimeDoc::slotDisplayFootnotes(bool f)
{
	if (f)
		mainMgr->setGlobalOption("Footnotes","On");
	else
		mainMgr->setGlobalOption("Footnotes","Off");
	
	if (curMod)
		curMod->Display();
}

void BibleTimeDoc::slotChangeColors()
{
	entryDisplay->slotChangeColors();
	chapterDisplay->slotChangeColors();

	//now update the current HTML text	
	slotLookupTextChanged( currentVerseKey );
};


/** Sets up the font list of the different bible modules. */
QList <TBibleFont>* BibleTimeDoc::setupFontList()
{
	return bibleFontList;
}

QString BibleTimeDoc::getForeignFont( QString module)
{
	for (uint n=0; n < bibleFontList->count(); n++)
	{
		if (bibleFontList->at(n)->module == module)
			return bibleFontList->at(n)->fontname;
	};
	
	//if no font was found simply return ""
	return "";
};

/** Jumps tot he next verse and highlights it. */
void BibleTimeDoc::slotMoveToNextVerse()
{
	QString		keyStr = 0;	
	VerseKey	vKey;
	SWKey			sKey;

	if (curMod)
	{
		if (!strcmp(curMod->Type(), "Biblical Texts"))
		{
			vKey = (*(SWKey *)*curMod);
			vKey.Verse(vKey.Verse()+1);
		}
		if (!strcmp(curMod->Type(), "Commentaries"))
		{
			(*curMod)++;
			vKey = (*(SWKey *)*curMod);
		}
		if (!strcmp(curMod->Type(), "Lexicons / Dictionaries"))
		{
			(*curMod)++;
			sKey = (*(SWKey *)*curMod);
			keyStr.setStr((const char *) sKey);
		} else
			keyStr.setStr((const char *) vKey);

		slotLookupTextChanged(keyStr);
	}
}

/**  */
void BibleTimeDoc::slotMoveToPreviousVerse()
{
	QString		keyStr = 0;	
	VerseKey	vKey;
	SWKey			sKey;

	if (curMod)
	{
		if (!strcmp(curMod->Type(), "Biblical Texts"))
		{
			vKey = (*(SWKey *)*curMod);
			vKey.Verse(vKey.Verse()-1);
		}
		if (!strcmp(curMod->Type(), "Commentaries"))
		{
			(*curMod)--;
			vKey = (*(SWKey *)*curMod);
		}
		if (!strcmp(curMod->Type(), "Lexicons / Dictionaries"))
		{
			(*curMod)--;
			sKey = (*(SWKey *)*curMod);
			keyStr.setStr((const char *) sKey);
		} else
			keyStr.setStr((const char *) vKey);

		slotLookupTextChanged(keyStr);
	}
}




