/*
    File: oszi.h
    Version: 0.2.2
    Date: 1998/07/02
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    This file defines some kind of osziloscope: two inputs
    can be set, and the display can be advanced.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#ifndef OSZI_H
#define OSZI_H



#include <qframe.h>
#include <qdrawutl.h>
#include <qpixmap.h>

#include "ringbuffer.h"



// define standard color for osziloscope

#define OSZI_STD_CLR black
#define OSZI_STD_Y1 green
#define OSZI_STD_Y2 green



// define length of history buffer

#define OSZI_HISTORY 2048



// define osziloscope widget

class oszi : public QFrame {

  // this widget is Q-Object
  Q_OBJECT;
  
public:

  // constructor
  oszi(QWidget* parent=0,float maximum=1,char* name="",QColor y1c=OSZI_STD_Y1,
       QColor y2c=OSZI_STD_Y2,QColor clrColor=OSZI_STD_CLR);

  // read current maximum display value
  float getMaximum();

protected:
 
  // what to do when widget have to be resized
  void resizeEvent(QResizeEvent*);
  
private:

  // current and old channel values (0 <= y1,y2 <= 1)
  float y1,y2;

  // float maximum value
  float maximum;

  // background brush
  QBrush clrBrush;

  // background color
  QColor clrColor;
  
  // color for first channel
  QColor y1Color;

  // color for second channel
  QColor y2Color;

  // painter for the widget
  QPainter p;
  
  // buffer-pixmap
  QPixmap pmap;

  // misc vars
  int w,h,z1,z2,o1,o2;

  // history buffers for y1 and y2
  Ringbuffer* y1_rbuf;
  Ringbuffer* y2_rbuf;

public slots:

  // set value of first Channel
  void setY1(float newValue);
  
  // set value of second Channel
  void setY2(float newValue);

  // set new Maximum value
  void setMaximum(float newMaximum);

  // go on one step
  void advance();

};



#endif
