/*
    File: oszi.cpp
    Version: 0.2.2
    Date: 1998/07/02
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    This file defines some kind of osziloscope: two inputs
    can be set, and the display can be advanced.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#include "oszi.h"



// constructor

oszi::oszi(QWidget* parent=0,float maximum=1,char* name="",
  QColor y1c=OSZI_STD_Y1,QColor y2c=OSZI_STD_Y2,QColor clrColor=OSZI_STD_CLR)
  : QFrame(parent,name),y1(0),y2(0),maximum(maximum),
    clrColor(clrColor),y1Color(y1c),y2Color(y2c),o1(0),o2(0) {

  // Apperance
  setFrameStyle(WinPanel|Sunken);
  
  // osziloscope background
  clrBrush=QBrush(clrColor);

  y1_rbuf=new Ringbuffer(OSZI_HISTORY);
  y2_rbuf=new Ringbuffer(OSZI_HISTORY);

};




// change value for channel 1

void oszi::setY1(float newValue) {
  y1=newValue;
  z1=(int)(h*(1-y1/maximum));
};



// change value for channel 2

void oszi::setY2(float newValue) {
  y2=newValue;
  z2=(int)(h*(1-y2/maximum));
};



// change maximum

void oszi::setMaximum(float newMaximum) {
  maximum=newMaximum;
  if(maximum<=0) maximum=1;
  resize(size());
};



void oszi::advance() {

  if(!pmap.isNull()) {

    // scroll pixmap-buffer on unit to the left
    bitBlt(&pmap,-1,0,&pmap);
  
    // begin drawing onto pixmap-buffer
    p.begin(&pmap);
  
    // clear the most right column
    p.setPen(clrColor);
    p.drawLine(w,0,w,h);

    // draw channel 1
    p.setPen(y1Color);
    p.drawLine(w,o1,w,z1);
    o1=z1;
  
    // draw channel 2
    p.setPen(y2Color);
    p.drawLine(w,o2,w,z2);
    o2=z2;
    
    // stop drawing onto pixmap-buffer
    p.end();
    
    // transfer pixmap-buffer to foreground
    bitBlt(this,contentsRect().x(),contentsRect().y(),&pmap);

    y1_rbuf->push(y1);
    y2_rbuf->push(y2);

  };
};



// resize event

void oszi::resizeEvent(QResizeEvent*) {

  w=contentsRect().width()-1;
  h=contentsRect().height()-1;

  pmap.resize(contentsRect().size());
  
  if(!pmap.isNull()) {
    pmap.fill(clrColor);

    // begin drawing onto pixmap-buffer
    p.begin(&pmap);

    o1=(int)(h*(1-y1_rbuf->get(w+1)/maximum));
    o2=(int)(h*(1-y2_rbuf->get(w+1)/maximum));
  
    // for(int i=(w>=OSZI_HISTORY)?0:w-OSZI_HISTORY;i<w;i++) {
    for(int i=0;i<=w;i++) {
      z1=(int)(h*(1-y1_rbuf->get(w-i)/maximum));
      z2=(int)(h*(1-y2_rbuf->get(w-i)/maximum));
      
      // draw channel 1
      p.setPen(y1Color);
      p.drawLine(i,o1,i,z1);
      o1=z1;
      
      // draw channel 2
      p.setPen(y2Color);
      p.drawLine(i,o2,i,z2);
      o2=z2;
      
    };
    
    p.end();

  };
};



// read current maximum display value

float oszi::getMaximum() {
  return maximum;
};
