/*
    File: led.h
    Version: 0.2.1
    Date: 1998/14/01
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    This file defines an Led, which can be turned on or off :-)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#ifndef LED_H
#define LED_H



#include <qframe.h>
#include <qdrawutl.h>



// define standard colors for enabled and disabled leds

#define LED_STD_SET red
#define LED_STD_CLR black



// define class for led-widget (used for TX,RX,CTS,RTS,DTR,DSR,DCD and RI)

class led : public QFrame {

  // this class is an QOBJECT
  Q_OBJECT
  
public:

  // constructor for led-widget
  led(QWidget* parent=0,char* name="",bool initstate=false,
    QColor setColor=LED_STD_SET,QColor clrColor=LED_STD_CLR);
    
protected:

  // what to do when widget should be repainted
  void drawContents(QPainter* p);
  
private:

  // state of led
  bool ledOn;
  
  // pointer to current led brush
  QBrush ledBrush;
  
  // brush for disabled led
  QColor setColor,clrColor;
    
public slots:

  // change state of led
  void setLed(bool newstate=true);

};



#endif
