/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [emulation.h]          Fundamental Terminal Emulation                      */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef EMULATION_H
#define EMULATION_H

#include "TEWidget.h"
#include "TEScreen.h"
#include <qtimer.h>
#include <stdio.h>

class Emulation : public QObject
{ Q_OBJECT

public:

  Emulation(TEWidget* gui);
  ~Emulation();

public slots: // signals incoming from TEWidget

  virtual void onImageSizeChange(int lines, int columns);
  virtual void onKeyPress(QKeyEvent*);
//void onMouse(int cb, int cx, int cy);

public slots: // signals incoming from data source

  void onRcvBlock(char* txt,int len);

signals:

  void sndBlock(char* txt,int len);
  virtual void ImageSizeChanged(int lines, int columns);

public:

  virtual void onRcvByte(int);

protected slots: // triggered by timer

  void showBulk();

protected:

  void sendString(char*);

protected:

  TEWidget* gui;
  TEScreen* scr;       // referes to one `screen'

private:

  QTimer bulk_timer;
  int    bulk_nlcnt; // bulk newline counter

protected:

  void bulkNewline();
  void bulkStart();
  void bulkEnd();

};

#endif // ifndef EMULATION_H
