/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [iemsi_view.cpp]             Display IEMSI Server Info                     */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#include "iemsi_view.h"
#include "iemsi.h"

#include <qcolor.h>
#include <time.h>
#include <qtimer.h>

#include "iemsi_view.moc"

void IemsiView::addLine(int row, char* l, char* r)
{ 
  QLabel *Ll = new QLabel(l,f0); Ll->sizeHint(); Ll->setPalette(pal);
  QLabel *Lr = new QLabel(r,f0); Lr->sizeHint();
  v1->addWidget(Ll,row,0,AlignLeft);
  v1->addWidget(Lr,row,1,AlignLeft);
//Lr->setFont( QFont("times",14,QFont::Bold,TRUE) );
}

IemsiView::IemsiView(IemsiServerInfo *isi, int autoclose)
  :QWidget(0,0,WStyle_Customize|WStyle_DialogBorder)
// automatic closes after 'autoclose' millisecs. 0 -> button 
{
  // blue labels
  QColorGroup coln = this->palette().normal();
  QColorGroup x(coln.foreground(), coln.background(),
                coln.light(), coln.dark(), coln.mid(), 
                blue/*coln.text()*/, coln.base());
  pal = QPalette(x,x,x);

  // autoclose or button
  if (autoclose)
    QTimer::singleShot( autoclose, this, SLOT(quit()) );
  else
  {
    CloseB = new QPushButton("&Close",this);
    CloseB->sizeHint(); CloseB->setFixedSize(CloseB->size());
    QObject::connect( CloseB, SIGNAL(clicked()), this, SLOT(quit()) );
  }

  v0 = new QBoxLayout(this,QBoxLayout::TopToBottom,5);
  f0 = new QGroupBox("Interactive Server Identification",this);
  v0->addWidget(f0,10);
  if (!autoclose) v0->addWidget(CloseB,1,AlignRight);
  v0->activate();

  struct tm* tm = gmtime(&isi->localtime);
  char ti[100]; sprintf(ti,"%02d.%02d.%04d %02d:%02d:%02d",
                        // ok, date format is DD.MM.YYYY,
                        // until KDE has some internationalization means.
                        tm->tm_mday+1, tm->tm_mon, tm->tm_year+1900,
                        tm->tm_hour+1, tm->tm_min+1, tm->tm_sec+1 );
                        

  v1 = new QGridLayout(f0,8,2,20,5);
  v1->setColStretch(0,1);
  v1->setColStretch(1,5);
  addLine(0,"System",       isi->system      .data());
  addLine(1,"Box",          isi->box         .data());
  addLine(2,"Location",     isi->location    .data());
  addLine(3,"Sysop",        isi->sysop       .data());
  addLine(4,"Box time",     ti                      );
  addLine(5,"Notice",       isi->notice      .data());
  addLine(6,"Wait",         isi->wait        .data());
  addLine(7,"Capabilities", isi->capabilities.data());
  v1->activate();

  setFixedSize(500,260);
//adjustSize();
  show();
}

void IemsiView::quit()
{
  delete this;
}

IemsiView::~IemsiView()
{
  delete v0;
  delete v1;
}

